/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.commands.rule.commandCustomBlockHardness;

import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.config.rule.commandCustomBlockHardness.CustomBlockHardnessConfig;
import club.mcams.carpet.network.rule.commandCustomBlockHardness.CustomBlockHardnessS2CPacket;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.CommandHelper;
import club.mcams.carpet.utils.Messenger;
import club.mcams.carpet.utils.RegexTools;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2257;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5218;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class CustomBlockHardnessCommandRegistry {
    private static final Translator translator = new Translator("command.customBlockHardness");
    public static final Map<class_2680, Float> CUSTOM_BLOCK_HARDNESS_MAP = new HashMap<class_2680, Float>();
    private static final String MESSAGE_HEAD = "<customBlockHardness> ";

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"customBlockHardness").requires(source -> CommandHelper.canUseCommand(source, AmsServerSettings.commandCustomBlockHardness))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandRegistryAccess)).then(class_2170.method_9244((String)"hardness", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> CustomBlockHardnessCommandRegistry.set(class_2257.method_9655((CommandContext)context, (String)"block").method_9494(), FloatArgumentType.getFloat((CommandContext)context, (String)"hardness"), ((class_2168)context.getSource()).method_9211(), (class_1657)((class_2168)context.getSource()).method_9207())))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandRegistryAccess)).executes(context -> CustomBlockHardnessCommandRegistry.remove(class_2257.method_9655((CommandContext)context, (String)"block").method_9494(), ((class_2168)context.getSource()).method_9211(), (class_1657)((class_2168)context.getSource()).method_9207()))))).then(class_2170.method_9247((String)"removeAll").executes(context -> CustomBlockHardnessCommandRegistry.removeAll(((class_2168)context.getSource()).method_9211(), (class_1657)((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"list").executes(context -> CustomBlockHardnessCommandRegistry.list((class_1657)((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"help").executes(context -> CustomBlockHardnessCommandRegistry.help((class_1657)((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"getDefaultHardness").then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandRegistryAccess)).executes(context -> CustomBlockHardnessCommandRegistry.getDefaultHardness((class_1657)((class_2168)context.getSource()).method_9207(), class_2257.method_9655((CommandContext)context, (String)"block").method_9494())))));
    }

    private static int set(class_2680 state, float hardness, MinecraftServer server, class_1657 player) {
        String CONFIG_FILE_PATH = CustomBlockHardnessCommandRegistry.getPath(server);
        if (CUSTOM_BLOCK_HARDNESS_MAP.containsKey(state)) {
            float oldHardness = CUSTOM_BLOCK_HARDNESS_MAP.get(state).floatValue();
            player.method_7353((class_2561)Messenger.s(MESSAGE_HEAD + RegexTools.getBlockRegisterName(state) + "/" + oldHardness + " -> " + RegexTools.getBlockRegisterName(state) + "/" + hardness).method_27692(class_124.field_1060), false);
        } else {
            player.method_7353((class_2561)Messenger.s("<customBlockHardness> + " + RegexTools.getBlockRegisterName(state) + "/" + hardness).method_27692(class_124.field_1060), false);
        }
        CUSTOM_BLOCK_HARDNESS_MAP.put(state, Float.valueOf(hardness));
        CustomBlockHardnessConfig.saveToJson(CUSTOM_BLOCK_HARDNESS_MAP, CONFIG_FILE_PATH);
        CustomBlockHardnessCommandRegistry.sendSyncPacketToAllOnlinePlayer(server);
        return 1;
    }

    private static int remove(class_2680 state, MinecraftServer server, class_1657 player) {
        String CONFIG_FILE_PATH = CustomBlockHardnessCommandRegistry.getPath(server);
        if (CUSTOM_BLOCK_HARDNESS_MAP.containsKey(state)) {
            float hardness = CUSTOM_BLOCK_HARDNESS_MAP.get(state).floatValue();
            CUSTOM_BLOCK_HARDNESS_MAP.remove(state);
            CustomBlockHardnessConfig.saveToJson(CUSTOM_BLOCK_HARDNESS_MAP, CONFIG_FILE_PATH);
            CustomBlockHardnessCommandRegistry.sendSyncPacketToAllOnlinePlayer(server);
            player.method_7353((class_2561)Messenger.s("<customBlockHardness> - " + RegexTools.getBlockRegisterName(state) + "/" + hardness).method_27692(class_124.field_1061), false);
            return 1;
        }
        player.method_7353((class_2561)Messenger.s(MESSAGE_HEAD + RegexTools.getBlockRegisterName(state) + translator.tr("not_found", new Object[0]).getString()).method_27692(class_124.field_1061), false);
        return 0;
    }

    private static int removeAll(MinecraftServer server, class_1657 player) {
        String CONFIG_FILE_PATH = CustomBlockHardnessCommandRegistry.getPath(server);
        CUSTOM_BLOCK_HARDNESS_MAP.clear();
        CustomBlockHardnessConfig.saveToJson(CUSTOM_BLOCK_HARDNESS_MAP, CONFIG_FILE_PATH);
        CustomBlockHardnessCommandRegistry.sendSyncPacketToAllOnlinePlayer(server);
        player.method_7353((class_2561)Messenger.s(MESSAGE_HEAD + translator.tr("removeAll", new Object[0]).getString()).method_27692(class_124.field_1061), false);
        return 1;
    }

    private static int getDefaultHardness(class_1657 player, class_2680 state) {
        float hardness = state.method_26204().method_36555();
        String blockName = RegexTools.getBlockRegisterName(state);
        player.method_7353((class_2561)Messenger.s(String.format("%s%s %s %s", MESSAGE_HEAD, blockName, translator.tr("default_hardness", new Object[0]).getString(), Float.valueOf(hardness))).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int list(class_1657 player) {
        player.method_7353((class_2561)Messenger.s(translator.tr("list", new Object[0]).getString() + "\n-------------------------------").method_27692(class_124.field_1060), false);
        for (Map.Entry<class_2680, Float> entry : CUSTOM_BLOCK_HARDNESS_MAP.entrySet()) {
            class_2680 state = entry.getKey();
            float hardness = entry.getValue().floatValue();
            class_2248 block = state.method_26204();
            String blockName = RegexTools.getBlockRegisterName(block.toString());
            player.method_7353((class_2561)Messenger.s(blockName + "/" + hardness).method_27692(class_124.field_1060), false);
        }
        return 1;
    }

    private static int help(class_1657 player) {
        String setHelpText = translator.tr("help.set", new Object[0]).getString();
        String removeHelpText = translator.tr("help.remove", new Object[0]).getString();
        String removeAllHelpText = translator.tr("help.removeAll", new Object[0]).getString();
        String listHelpText = translator.tr("help.list", new Object[0]).getString();
        String getDefaultHardnessHelpText = translator.tr("help.get_default_hardness", new Object[0]).getString();
        player.method_7353((class_2561)Messenger.s(setHelpText + "\n" + removeHelpText + "\n" + removeAllHelpText + "\n" + getDefaultHardnessHelpText + "\n" + listHelpText).method_27692(class_124.field_1080), false);
        return 1;
    }

    private static void sendSyncPacketToAllOnlinePlayer(MinecraftServer server) {
        server.method_3760().method_14571().forEach(CustomBlockHardnessS2CPacket::sendToPlayer);
    }

    private static String getPath(MinecraftServer server) {
        return server.method_27050(class_5218.field_24188).resolve("carpetamsaddition/custom_block_hardness.json").toString();
    }
}

