/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.commands.rule.commandCustomCommandPermissionLevel;

import club.mcams.carpet.AmsServerSettings;
import club.mcams.carpet.commands.suggestionProviders.ListSuggestionProvider;
import club.mcams.carpet.commands.suggestionProviders.LiteralCommandSuggestionProvider;
import club.mcams.carpet.commands.suggestionProviders.SetSuggestionProvider;
import club.mcams.carpet.config.rule.commandCustomCommandPermissionLevel.CustomCommandPermissionLevelConfig;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.CommandHelper;
import club.mcams.carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class CustomCommandPermissionLevelRegistry {
    private static final Translator translator = new Translator("command.customCommandPermissionLevel");
    private static final String MSG_HEAD = "<customCommandPermissionLevel> ";
    public static final Map<String, Integer> COMMAND_PERMISSION_MAP = new HashMap<String, Integer>();
    public static final Map<String, Predicate<class_2168>> DEFAULT_PERMISSION_MAP = new HashMap<String, Predicate<class_2168>>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"customCommandPermissionLevel").requires(source -> CommandHelper.canUseCommand(source, AmsServerSettings.commandCustomCommandPermissionLevel))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new LiteralCommandSuggestionProvider()).then(class_2170.method_9244((String)"permissionLevel", (ArgumentType)IntegerArgumentType.integer()).suggests(ListSuggestionProvider.of(CommandHelper.permissionLevels)).executes(context -> CustomCommandPermissionLevelRegistry.set(((class_2168)context.getSource()).method_9211(), ((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"command"), IntegerArgumentType.getInteger((CommandContext)context, (String)"permissionLevel"))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.string()).suggests(SetSuggestionProvider.of(COMMAND_PERMISSION_MAP.keySet())).executes(context -> CustomCommandPermissionLevelRegistry.remove(((class_2168)context.getSource()).method_9211(), (class_1657)((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"command")))))).then(class_2170.method_9247((String)"removeAll").executes(context -> CustomCommandPermissionLevelRegistry.removeAll(((class_2168)context.getSource()).method_9211(), ((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"refresh").executes(context -> CustomCommandPermissionLevelRegistry.refreshCommandTree(((class_2168)context.getSource()).method_9211())))).then(class_2170.method_9247((String)"list").executes(context -> CustomCommandPermissionLevelRegistry.list((class_1657)((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9247((String)"help").executes(context -> CustomCommandPermissionLevelRegistry.help((class_1657)((class_2168)context.getSource()).method_9207()))));
    }

    private static int set(MinecraftServer server, class_3222 player, String command, int permissionLevel) {
        if (Objects.equals(command, "customCommandPermissionLevel")) {
            player.method_7353((class_2561)Messenger.s(MSG_HEAD + translator.tr("cant_modify_self", new Object[0]).getString()).method_27695(new class_124[]{class_124.field_1056, class_124.field_1061}), false);
            return 0;
        }
        if (COMMAND_PERMISSION_MAP.containsKey(command)) {
            int oldPermissionLevel = COMMAND_PERMISSION_MAP.get(command);
            player.method_7353((class_2561)Messenger.s(String.format("%s%s %d -> %d", MSG_HEAD, command, oldPermissionLevel, permissionLevel)).method_27692(class_124.field_1060), false);
        } else {
            player.method_7353((class_2561)Messenger.s(String.format("%s+ %s/%d", MSG_HEAD, command, permissionLevel)).method_27692(class_124.field_1060), false);
        }
        COMMAND_PERMISSION_MAP.put(command, permissionLevel);
        CustomCommandPermissionLevelRegistry.saveToJson(server);
        CommandHelper.setPermission(server, command, permissionLevel);
        CommandHelper.updateAllCommandPermissions(server);
        return 1;
    }

    private static int remove(MinecraftServer server, class_1657 player, String command) {
        if (COMMAND_PERMISSION_MAP.containsKey(command)) {
            COMMAND_PERMISSION_MAP.remove(command);
            CustomCommandPermissionLevelRegistry.saveToJson(server);
            player.method_7353((class_2561)Messenger.s(String.format("%s- %s", MSG_HEAD, command)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), false);
            CommandHelper.updateAllCommandPermissions(server);
        } else {
            player.method_7353((class_2561)Messenger.s(MSG_HEAD + command + translator.tr("not_found", new Object[0]).getString()).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), false);
        }
        return 1;
    }

    private static int removeAll(MinecraftServer server, class_3222 player) {
        if (!COMMAND_PERMISSION_MAP.isEmpty()) {
            COMMAND_PERMISSION_MAP.clear();
            CustomCommandPermissionLevelRegistry.saveToJson(server);
        }
        player.method_7353((class_2561)Messenger.s(MSG_HEAD + translator.tr("removeAll", new Object[0]).getString()).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), false);
        CommandHelper.updateAllCommandPermissions(server);
        return 1;
    }

    private static int refreshCommandTree(MinecraftServer server) {
        CommandHelper.updateAllCommandPermissions(server);
        return 1;
    }

    private static int list(class_1657 player) {
        String LINE = "------------------------------------";
        player.method_7353((class_2561)Messenger.s(translator.tr("list", new Object[0]).getString() + "\n------------------------------------").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), false);
        for (Map.Entry<String, Integer> entry : COMMAND_PERMISSION_MAP.entrySet()) {
            String command = entry.getKey();
            int permissionLevel = entry.getValue();
            player.method_7353((class_2561)Messenger.s(command + " -> " + permissionLevel).method_27692(class_124.field_1062), false);
        }
        return 1;
    }

    private static int help(class_1657 player) {
        String setHelp = translator.tr("help.set", new Object[0]).getString();
        String removeHelp = translator.tr("help.remove", new Object[0]).getString();
        String removeAllHelp = translator.tr("help.removeAll", new Object[0]).getString();
        String refreshHelp = translator.tr("help.refresh", new Object[0]).getString();
        String listHelp = translator.tr("help.list", new Object[0]).getString();
        player.method_7353((class_2561)Messenger.s(setHelp + "\n" + removeHelp + "\n" + removeAllHelp + "\n" + listHelp + "\n" + refreshHelp).method_27692(class_124.field_1080), false);
        return 1;
    }

    private static void saveToJson(MinecraftServer server) {
        String CONFIG_PATH = CustomCommandPermissionLevelConfig.getPath(server);
        CustomCommandPermissionLevelConfig.saveToJson(COMMAND_PERMISSION_MAP, CONFIG_PATH);
    }
}

