/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.config.rule.commandAntiFireItems;

import club.mcams.carpet.AmsServer;
import club.mcams.carpet.commands.rule.commandCustomAntiFireItems.CustomAntiFireItemsCommandRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class CustomAntiFireItemsConfig {
    public static void loadFromJson(String configFilePath) {
        Gson gson = new Gson();
        Path path = Paths.get(configFilePath, new String[0]);
        CustomAntiFireItemsCommandRegistry.CUSTOM_ANTI_FIRE_ITEMS.clear();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                String json = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                Type type = new TypeToken<List<String>>(){}.getType();
                List simplifiedMap = (List)gson.fromJson(json, type);
                CustomAntiFireItemsCommandRegistry.CUSTOM_ANTI_FIRE_ITEMS.addAll(simplifiedMap);
            }
            catch (IOException e) {
                AmsServer.LOGGER.warn("Failed to load config", (Throwable)e);
            }
        }
    }

    public static void saveToJson(List<String> customBlockMap, String configFilePath) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        ArrayList<String> simplifiedMap = new ArrayList<String>(customBlockMap);
        String json = gson.toJson(simplifiedMap);
        try {
            Path path = Paths.get(configFilePath, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            AmsServer.LOGGER.warn("Failed to save config", (Throwable)e);
        }
    }

    public static String getPath(MinecraftServer server) {
        return server.method_27050(class_5218.field_24188).resolve("carpetamsaddition/custom_anti_fire_items.json").toString();
    }
}

