/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.config.rule.commandCustomBlockBlastResistance;

import club.mcams.carpet.AmsServer;
import club.mcams.carpet.commands.rule.commandCustomBlockBlastResistance.CustomBlockBlastResistanceCommandRegistry;
import club.mcams.carpet.utils.IdentifierUtil;
import club.mcams.carpet.utils.RegexTools;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_5218;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class CustomBlockBlastResistanceConfig {
    public static void loadFromJson(String configFilePath) {
        Gson gson = new Gson();
        Path path = Paths.get(configFilePath, new String[0]);
        CustomBlockBlastResistanceCommandRegistry.CUSTOM_BLOCK_BLAST_RESISTANCE_MAP.clear();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                String json = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                Type type = new TypeToken<Map<String, Float>>(){}.getType();
                Map simplifiedMap = (Map)gson.fromJson(json, type);
                for (Map.Entry entry : simplifiedMap.entrySet()) {
                    class_2680 state = ((class_2248)class_7923.field_41175.method_10223(IdentifierUtil.ofId((String)entry.getKey()))).method_9564();
                    CustomBlockBlastResistanceCommandRegistry.CUSTOM_BLOCK_BLAST_RESISTANCE_MAP.put(state, (Float)entry.getValue());
                }
            }
            catch (IOException e) {
                AmsServer.LOGGER.warn("Failed to load config", (Throwable)e);
            }
        }
    }

    public static void saveToJson(Map<class_2680, Float> customBlockMap, String configFilePath) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        HashMap<String, Float> simplifiedMap = new HashMap<String, Float>();
        for (Map.Entry<class_2680, Float> entry : customBlockMap.entrySet()) {
            class_2680 state = entry.getKey().method_26204().method_9564();
            String blockName = RegexTools.getBlockRegisterName(state.method_26204().toString());
            simplifiedMap.put(blockName, entry.getValue());
        }
        String json = gson.toJson(simplifiedMap);
        try {
            Path path = Paths.get(configFilePath, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            AmsServer.LOGGER.warn("Failed to save config", (Throwable)e);
        }
    }

    public static String getPath(MinecraftServer server) {
        return server.method_27050(class_5218.field_24188).resolve("carpetamsaddition/custom_block_Blast_Resistance.json").toString();
    }
}

