/*
 * Decompiled with CFR 0.152.
 */
package club.mcams.carpet.helpers.rule.sendPlayerDeathLocation;

import club.mcams.carpet.helpers.FakePlayerHelper;
import club.mcams.carpet.translations.Translator;
import club.mcams.carpet.utils.MessageTextEventUtils.ClickEventUtil;
import club.mcams.carpet.utils.MessageTextEventUtils.HoverEventUtil;
import club.mcams.carpet.utils.Messenger;
import club.mcams.carpet.utils.compat.DimensionWrapper;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class PlayerDeathLocationContext {
    private static final Translator translator = new Translator("rule.sendPlayerDeathLocation");

    public static void sendMessage(MinecraftServer server, class_3222 player, class_1937 world) {
        class_2561 copyButton = PlayerDeathLocationContext.copyButton(player);
        String message = PlayerDeathLocationContext.formatMessage(player, world);
        Messenger.sendServerMessage(server, (class_2561)Messenger.s(message).method_27692(class_124.field_1061).method_10852(copyButton));
    }

    public static void realPlayerSendMessage(MinecraftServer server, class_3222 player, class_1937 world) {
        if (!FakePlayerHelper.isFakePlayer((class_1657)player)) {
            PlayerDeathLocationContext.sendMessage(server, player, world);
        }
    }

    public static void fakePlayerSendMessage(MinecraftServer server, class_3222 player, class_1937 world) {
        if (FakePlayerHelper.isFakePlayer((class_1657)player)) {
            PlayerDeathLocationContext.sendMessage(server, player, world);
        }
    }

    private static String getPlayerName(class_3222 player) {
        return player.method_5477().getString();
    }

    private static DimensionWrapper getDimension(class_1937 world) {
        return DimensionWrapper.of(world);
    }

    private static String getPlayerPos(class_3222 player) {
        return player.method_24515().method_10263() + ", " + player.method_24515().method_10264() + ", " + player.method_24515().method_10260();
    }

    private static class_2561 copyButton(class_3222 player) {
        class_5250 hoverText = Messenger.s((Object)translator.tr("copy", new Object[0]).getString(), "y");
        String copyCoordText = PlayerDeathLocationContext.getPlayerPos(player).replace(",", "");
        return Messenger.s(" [C] ").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true)).method_10958(ClickEventUtil.event(ClickEventUtil.COPY_TO_CLIPBOARD, copyCoordText)).method_10949(HoverEventUtil.event(HoverEventUtil.SHOW_TEXT, hoverText)));
    }

    private static String formatMessage(class_3222 player, class_1937 world) {
        String playerName = PlayerDeathLocationContext.getPlayerName(player);
        DimensionWrapper dimension = PlayerDeathLocationContext.getDimension(world);
        return String.format("%s %s @ %s -> [ %s ]", playerName, translator.tr("location", new Object[0]).getString(), dimension, PlayerDeathLocationContext.getPlayerPos(player));
    }
}

