/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class SpriteRenderer {
    private final Matrix4f transform;
    private final class_4588 builder;
    private final int light;
    private final int z;
    private final int r;
    private final int g;
    private final int b;

    public SpriteRenderer(Matrix4f transform, class_4588 builder, int z, int light, int r, int g, int b) {
        this.transform = transform;
        this.builder = builder;
        this.z = z;
        this.light = light;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public static SpriteRenderer createForGui(class_332 graphics, class_1921 renderType) {
        return new SpriteRenderer(graphics.method_51448().method_23760().method_23761(), graphics.method_51450().getBuffer(renderType), 0, 0xF000F0, 255, 255, 255);
    }

    public void blit(class_1058 sprite, int x, int y, int width, int height) {
        this.blit(x, y, width, height, sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4575());
    }

    public void blitHorizontalSliced(class_1058 sprite, int x, int y, int width, int height, int leftBorder, int rightBorder, int textureWidth) {
        if (width < leftBorder + rightBorder) {
            throw new IllegalArgumentException("width is less than two borders");
        }
        float centerStart = SpriteRenderer.u(sprite, leftBorder, textureWidth);
        float centerEnd = SpriteRenderer.u(sprite, textureWidth - rightBorder, textureWidth);
        this.blit(x, y, leftBorder, height, sprite.method_4594(), sprite.method_4593(), centerStart, sprite.method_4575());
        this.blit(x + leftBorder, y, width - leftBorder - rightBorder, height, centerStart, sprite.method_4593(), centerEnd, sprite.method_4575());
        this.blit(x + width - rightBorder, y, rightBorder, height, centerEnd, sprite.method_4593(), sprite.method_4577(), sprite.method_4575());
    }

    public void blitVerticalSliced(class_1058 sprite, int x, int y, int width, int height, int topBorder, int bottomBorder, int textureHeight) {
        if (width < topBorder + bottomBorder) {
            throw new IllegalArgumentException("height is less than two borders");
        }
        float centerStart = SpriteRenderer.v(sprite, topBorder, textureHeight);
        float centerEnd = SpriteRenderer.v(sprite, textureHeight - bottomBorder, textureHeight);
        this.blit(x, y, width, topBorder, sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), centerStart);
        this.blit(x, y + topBorder, width, height - topBorder - bottomBorder, sprite.method_4594(), centerStart, sprite.method_4577(), centerEnd);
        this.blit(x, y + height - bottomBorder, width, bottomBorder, sprite.method_4594(), centerEnd, sprite.method_4577(), sprite.method_4575());
    }

    public void blit(int x, int y, int width, int height, float u0, float v0, float u1, float v1) {
        this.builder.method_22918(this.transform, (float)x, (float)(y + height), (float)this.z).method_1336(this.r, this.g, this.b, 255).method_22913(u0, v1).method_60803(this.light);
        this.builder.method_22918(this.transform, (float)(x + width), (float)(y + height), (float)this.z).method_1336(this.r, this.g, this.b, 255).method_22913(u1, v1).method_60803(this.light);
        this.builder.method_22918(this.transform, (float)(x + width), (float)y, (float)this.z).method_1336(this.r, this.g, this.b, 255).method_22913(u1, v0).method_60803(this.light);
        this.builder.method_22918(this.transform, (float)x, (float)y, (float)this.z).method_1336(this.r, this.g, this.b, 255).method_22913(u0, v0).method_60803(this.light);
    }

    public static float u(class_1058 sprite, int x, int width) {
        return sprite.method_4580((float)x / (float)width);
    }

    public static float v(class_1058 sprite, int y, int height) {
        return sprite.method_4570((float)y / (float)height);
    }
}

