/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.monitor;

import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Palette;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.core.util.Colour;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_284;
import net.minecraft.class_293;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import org.lwjgl.opengl.GL31;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class MonitorTextureBufferShader
extends class_5944 {
    private static final Logger LOG = LoggerFactory.getLogger(MonitorTextureBufferShader.class);
    public static final int UNIFORM_SIZE = 276;
    static final int TEXTURE_INDEX = 33987;
    private final int monitorData = GL31.glGetUniformBlockIndex((int)this.method_1270(), (CharSequence)"MonitorData");
    private int uniformBuffer = 0;
    @Nullable
    private final class_284 cursorBlink;

    public MonitorTextureBufferShader(class_5912 provider, String location, class_293 format) throws IOException {
        super(provider, location, format);
        if (this.monitorData == -1) {
            throw new IllegalStateException("Could not find MonitorData uniform.");
        }
        this.cursorBlink = this.getUniformChecked("CursorBlink");
        class_284 tbo = this.getUniformChecked("Tbo");
        if (tbo != null) {
            tbo.method_35649(3);
        }
    }

    public void setupUniform(int buffer) {
        int cursorAlpha;
        this.uniformBuffer = buffer;
        int n = cursorAlpha = FrameInfo.getGlobalCursorBlink() ? 1 : 0;
        if (this.cursorBlink != null && this.cursorBlink.method_35663().get(0) != cursorAlpha) {
            this.cursorBlink.method_35649(cursorAlpha);
        }
    }

    public void method_34586() {
        super.method_34586();
        GL31.glBindBufferBase((int)35345, (int)this.monitorData, (int)this.uniformBuffer);
    }

    @Nullable
    private class_284 getUniformChecked(String name) {
        class_284 uniform = this.method_34582(name);
        if (uniform == null) {
            LOG.warn("Monitor shader {} should have uniform {}, but it was not present.", (Object)this.method_35787(), (Object)name);
        }
        return uniform;
    }

    public static void setTerminalData(ByteBuffer buffer, Terminal terminal) {
        int width = terminal.getWidth();
        int height = terminal.getHeight();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            TextBuffer text = terminal.getLine(y);
            TextBuffer textColour = terminal.getTextColourLine(y);
            TextBuffer background = terminal.getBackgroundColourLine(y);
            for (int x = 0; x < width; ++x) {
                buffer.put(pos, (byte)(text.charAt(x) & 0xFF));
                buffer.put(pos + 1, (byte)FixedWidthFontRenderer.getColour(textColour.charAt(x), Colour.WHITE));
                buffer.put(pos + 2, (byte)FixedWidthFontRenderer.getColour(background.charAt(x), Colour.BLACK));
                pos += 3;
            }
        }
        buffer.limit(pos);
    }

    public static void setUniformData(ByteBuffer buffer, Terminal terminal) {
        int pos = 0;
        Palette palette = terminal.getPalette();
        for (int i = 0; i < 16; ++i) {
            double[] colour = palette.getColour(i);
            if (!terminal.isColour()) {
                float f = FixedWidthFontRenderer.toGreyscale(colour);
                buffer.putFloat(pos, f).putFloat(pos + 4, f).putFloat(pos + 8, f);
            } else {
                buffer.putFloat(pos, (float)colour[0]).putFloat(pos + 4, (float)colour[1]).putFloat(pos + 8, (float)colour[2]);
            }
            pos += 16;
        }
        boolean showCursor = FixedWidthFontRenderer.isCursorVisible(terminal);
        buffer.putInt(pos, terminal.getWidth()).putInt(pos + 4, terminal.getHeight()).putInt(pos + 8, showCursor ? terminal.getCursorX() : -2).putInt(pos + 12, showCursor ? terminal.getCursorY() : -2).putInt(pos + 16, 15 - terminal.getTextColour());
        buffer.limit(276);
    }
}

