/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.WorkMonitor;
import dan200.computercraft.core.computer.ComputerEnvironment;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.computer.GlobalEnvironment;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.metrics.Metric;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.core.metrics.OperationTimer;
import dan200.computercraft.core.terminal.Terminal;
import javax.annotation.Nullable;

public interface IAPIEnvironment {
    public static final String TIMER_EVENT = "timer";

    public int getComputerID();

    public ComputerEnvironment getComputerEnvironment();

    public GlobalEnvironment getGlobalEnvironment();

    public WorkMonitor getMainThreadMonitor();

    public Terminal getTerminal();

    public FileSystem getFileSystem();

    public void shutdown();

    public void reboot();

    public void queueEvent(String var1, Object ... var2);

    public void setOutput(ComputerSide var1, int var2);

    public int getOutput(ComputerSide var1);

    public int getInput(ComputerSide var1);

    public void setBundledOutput(ComputerSide var1, int var2);

    public int getBundledOutput(ComputerSide var1);

    public int getBundledInput(ComputerSide var1);

    public void setPeripheralChangeListener(@Nullable IPeripheralChangeListener var1);

    @Nullable
    public IPeripheral getPeripheral(ComputerSide var1);

    @Nullable
    public String getLabel();

    public void setLabel(@Nullable String var1);

    public int startTimer(long var1);

    public void cancelTimer(int var1);

    public MetricsObserver metrics();

    default public void observe(Metric.Event event, long change) {
        this.metrics().observe(event, change);
    }

    default public void observe(Metric.Counter counter) {
        this.metrics().observe(counter);
    }

    default public OperationTimer time(Metric.Event event) {
        return OperationTimer.start(this.metrics(), event);
    }

    @FunctionalInterface
    public static interface IPeripheralChangeListener {
        public void onPeripheralChanged(ComputerSide var1, @Nullable IPeripheral var2);
    }
}

