/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.options;

import com.google.common.net.InetAddresses;
import dan200.computercraft.core.apis.http.options.InvalidRuleException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

interface AddressPredicate {
    default public boolean matches(String domain) {
        return false;
    }

    default public boolean matches(InetAddress socketAddress) {
        return false;
    }

    public static final class PrivatePattern
    implements AddressPredicate {
        static final PrivatePattern INSTANCE = new PrivatePattern();
        private static final Set<InetAddress> additionalAddresses = Arrays.stream(new String[]{"192.0.0.192"}).map(InetAddresses::forString).collect(Collectors.toUnmodifiableSet());

        @Override
        public boolean matches(InetAddress socketAddress) {
            return socketAddress.isAnyLocalAddress() || socketAddress.isLoopbackAddress() || socketAddress.isLinkLocalAddress() || socketAddress.isSiteLocalAddress() || socketAddress.isMulticastAddress() || this.isUniqueLocalAddress(socketAddress) || this.isCarrierGradeNatAddress(socketAddress) || additionalAddresses.contains(socketAddress);
        }

        private boolean isUniqueLocalAddress(InetAddress address) {
            return address instanceof Inet6Address && (address.getAddress()[0] & 0xFF) == 253;
        }

        private boolean isCarrierGradeNatAddress(InetAddress address) {
            if (!(address instanceof Inet4Address)) {
                return false;
            }
            byte[] bytes = address.getAddress();
            return bytes[0] == 100 && (bytes[1] & 0xFF) >= 64 && (bytes[1] & 0xFF) <= 127;
        }
    }

    public static final class DomainPattern
    implements AddressPredicate {
        private final Pattern pattern;

        DomainPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String domain) {
            return this.pattern.matcher(domain).matches();
        }

        @Override
        public boolean matches(InetAddress socketAddress) {
            return this.pattern.matcher(socketAddress.getHostAddress()).matches();
        }
    }

    public static final class HostRange
    implements AddressPredicate {
        private final byte[] min;
        private final byte[] max;

        HostRange(byte[] min, byte[] max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean matches(InetAddress address) {
            byte[] entry = address.getAddress();
            if (entry.length != this.min.length) {
                return false;
            }
            for (int i = 0; i < entry.length; ++i) {
                int value = 0xFF & entry[i];
                if (value >= (0xFF & this.min[i]) && value <= (0xFF & this.max[i])) continue;
                return false;
            }
            return true;
        }

        public static HostRange parse(String addressStr, String prefixSizeStr) {
            InetAddress address;
            int prefixSize;
            try {
                prefixSize = Integer.parseInt(prefixSizeStr);
            }
            catch (NumberFormatException e) {
                throw new InvalidRuleException(String.format("Invalid host host '%s': Cannot extract size of CIDR mask from '%s'.", addressStr + "/" + prefixSizeStr, prefixSizeStr));
            }
            try {
                address = InetAddresses.forString((String)addressStr);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRuleException(String.format("Invalid host '%s': Cannot extract IP address from '%s'.", addressStr + "/" + prefixSizeStr, addressStr));
            }
            byte[] minBytes = address.getAddress();
            byte[] maxBytes = address.getAddress();
            int size = prefixSize;
            for (int i = 0; i < minBytes.length; ++i) {
                if (size <= 0) {
                    minBytes[i] = 0;
                    maxBytes[i] = -1;
                } else if (size < 8) {
                    minBytes[i] = (byte)(minBytes[i] & 255 << 8 - size);
                    maxBytes[i] = (byte)(maxBytes[i] | ~(255 << 8 - size));
                }
                size -= 8;
            }
            return new HostRange(minBytes, maxBytes);
        }
    }
}

