/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.component.AdminComputer;
import dan200.computercraft.api.component.ComputerComponents;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.api.upgrades.UpgradeType;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.command.UserLevel;
import dan200.computercraft.shared.command.arguments.ComputerArgumentType;
import dan200.computercraft.shared.command.arguments.RepeatArgumentType;
import dan200.computercraft.shared.command.arguments.TrackingFieldArgumentType;
import dan200.computercraft.shared.common.ClearColourRecipe;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import dan200.computercraft.shared.common.HeldItemMenu;
import dan200.computercraft.shared.computer.apis.CommandAPI;
import dan200.computercraft.shared.computer.blocks.CommandComputerBlock;
import dan200.computercraft.shared.computer.blocks.ComputerBlock;
import dan200.computercraft.shared.computer.blocks.ComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.items.CommandComputerItem;
import dan200.computercraft.shared.computer.items.ComputerItem;
import dan200.computercraft.shared.computer.items.ServerComputerReference;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.data.BlockNamedEntityLootCondition;
import dan200.computercraft.shared.data.HasComputerIdLootCondition;
import dan200.computercraft.shared.data.PlayerCreativeLootCondition;
import dan200.computercraft.shared.details.BlockDetails;
import dan200.computercraft.shared.details.ItemDetails;
import dan200.computercraft.shared.integration.PermissionRegistry;
import dan200.computercraft.shared.media.items.DiskItem;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.media.items.RecordMedia;
import dan200.computercraft.shared.media.items.TreasureDisk;
import dan200.computercraft.shared.media.items.TreasureDiskItem;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.network.container.HeldItemContainerData;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlock;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlockEntity;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveMenu;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockItem;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlock;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlock;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlockEntity;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.printer.PrinterBlock;
import dan200.computercraft.shared.peripheral.printer.PrinterBlockEntity;
import dan200.computercraft.shared.peripheral.printer.PrinterMenu;
import dan200.computercraft.shared.peripheral.speaker.SpeakerBlock;
import dan200.computercraft.shared.peripheral.speaker.SpeakerBlockEntity;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RegistrationHelper;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.pocket.apis.PocketAPI;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.pocket.peripherals.PocketModem;
import dan200.computercraft.shared.pocket.peripherals.PocketSpeaker;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.recipe.BasicRecipeSerialiser;
import dan200.computercraft.shared.recipe.CustomShapedRecipe;
import dan200.computercraft.shared.recipe.CustomShapelessRecipe;
import dan200.computercraft.shared.recipe.ImpostorShapedRecipe;
import dan200.computercraft.shared.recipe.ImpostorShapelessRecipe;
import dan200.computercraft.shared.recipe.TransformShapedRecipe;
import dan200.computercraft.shared.recipe.TransformShapelessRecipe;
import dan200.computercraft.shared.recipe.function.CopyComponents;
import dan200.computercraft.shared.recipe.function.RecipeFunction;
import dan200.computercraft.shared.turtle.FurnaceRefuelHandler;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.apis.TurtleAPI;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.turtle.core.TurtleAccessInternal;
import dan200.computercraft.shared.turtle.inventory.TurtleMenu;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.turtle.upgrades.TurtleCraftingTable;
import dan200.computercraft.shared.turtle.upgrades.TurtleModem;
import dan200.computercraft.shared.turtle.upgrades.TurtleSpeaker;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import dan200.computercraft.shared.util.ComponentMap;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.NonNegativeId;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_3620;
import net.minecraft.class_3917;
import net.minecraft.class_4970;
import net.minecraft.class_5342;
import net.minecraft.class_5620;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7701;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9282;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public final class ModRegistry {
    private ModRegistry() {
    }

    public static void register() {
        Blocks.REGISTRY.register();
        BlockEntities.REGISTRY.register();
        DataComponents.REGISTRY.register();
        Items.REGISTRY.register();
        TurtleUpgradeTypes.REGISTRY.register();
        PocketUpgradeTypes.REGISTRY.register();
        Menus.REGISTRY.register();
        ArgumentTypes.REGISTRY.register();
        LootItemConditionTypes.REGISTRY.register();
        RecipeSerializers.REGISTRY.register();
        RecipeFunctions.REGISTRY.register();
        Permissions.REGISTRY.register();
        CreativeTabs.REGISTRY.register();
        ComputerCraftAPI.registerBundledRedstoneProvider(new DefaultBundledRedstoneProvider());
        ComputerCraftAPI.registerRefuelHandler(new FurnaceRefuelHandler());
        ComputerCraftAPI.registerMediaProvider(stack -> {
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof IMedia) {
                IMedia media = (IMedia)patt0$temp;
                return media;
            }
            if (stack.method_57826(class_9334.field_52175)) {
                return RecordMedia.INSTANCE;
            }
            return null;
        });
        ComputerCraftAPI.registerAPIFactory(computer -> {
            ITurtleAccess turtle = computer.getComponent(ComputerComponents.TURTLE);
            MetricsObserver metrics = Objects.requireNonNull(computer.getComponent(ComponentMap.METRICS));
            return turtle == null ? null : new TurtleAPI(metrics, (TurtleAccessInternal)turtle);
        });
        ComputerCraftAPI.registerAPIFactory(computer -> {
            IPocketAccess pocket = computer.getComponent(ComputerComponents.POCKET);
            return pocket == null ? null : new PocketAPI(pocket);
        });
        ComputerCraftAPI.registerAPIFactory(computer -> {
            AdminComputer admin = computer.getComponent(ComputerComponents.ADMIN_COMPUTER);
            return admin == null ? null : new CommandAPI(computer, admin);
        });
        VanillaDetailRegistries.ITEM_STACK.addProvider(ItemDetails::fill);
        VanillaDetailRegistries.BLOCK_IN_WORLD.addProvider(BlockDetails::fill);
    }

    public static void registerMainThread() {
        class_5620.field_27776.comp_1982().put((class_1792)Items.TURTLE_NORMAL.get(), TurtleItem.CAULDRON_INTERACTION);
        class_5620.field_27776.comp_1982().put((class_1792)Items.TURTLE_ADVANCED.get(), TurtleItem.CAULDRON_INTERACTION);
    }

    private static void addTurtle(class_1761.class_7704 out, TurtleItem turtle, class_7225.class_7874 registries) {
        out.method_45420(new class_1799((class_1935)turtle));
        registries.method_46762(ITurtleUpgrade.REGISTRY).method_42017().filter(ModRegistry::isOurUpgrade).map(x -> DataComponentUtil.createStack((class_1935)turtle, (class_9331)DataComponents.RIGHT_TURTLE_UPGRADE.get(), UpgradeData.ofDefault(x))).forEach(arg_0 -> ((class_1761.class_7704)out).method_45420(arg_0));
    }

    private static void addPocket(class_1761.class_7704 out, PocketComputerItem pocket, class_7225.class_7874 registries) {
        out.method_45420(new class_1799((class_1935)pocket));
        registries.method_46762(IPocketUpgrade.REGISTRY).method_42017().filter(ModRegistry::isOurUpgrade).map(x -> DataComponentUtil.createStack((class_1935)pocket, (class_9331)DataComponents.POCKET_UPGRADE.get(), UpgradeData.ofDefault(x))).forEach(arg_0 -> ((class_1761.class_7704)out).method_45420(arg_0));
    }

    private static boolean isOurUpgrade(class_6880.class_6883<? extends UpgradeBase> upgrade) {
        String namespace = upgrade.method_40237().method_29177().method_12836();
        return namespace.equals("minecraft") || namespace.equals("computercraft");
    }

    public static final class Blocks {
        static final RegistrationHelper<class_2248> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41254);
        public static final RegistryEntry<ComputerBlock<ComputerBlockEntity>> COMPUTER_NORMAL = REGISTRY.register("computer_normal", () -> new ComputerBlock(Blocks.computerProperties().method_31710(class_3620.field_16023), BlockEntities.COMPUTER_NORMAL));
        public static final RegistryEntry<ComputerBlock<ComputerBlockEntity>> COMPUTER_ADVANCED = REGISTRY.register("computer_advanced", () -> new ComputerBlock(Blocks.computerProperties().method_31710(class_3620.field_15994), BlockEntities.COMPUTER_ADVANCED));
        public static final RegistryEntry<ComputerBlock<ComputerBlockEntity>> COMPUTER_COMMAND = REGISTRY.register("computer_command", () -> new CommandComputerBlock(Blocks.computerProperties().method_9629(-1.0f, 6000000.0f), BlockEntities.COMPUTER_COMMAND));
        public static final RegistryEntry<TurtleBlock> TURTLE_NORMAL = REGISTRY.register("turtle_normal", () -> new TurtleBlock(Blocks.turtleProperties().method_31710(class_3620.field_16023), BlockEntities.TURTLE_NORMAL));
        public static final RegistryEntry<TurtleBlock> TURTLE_ADVANCED = REGISTRY.register("turtle_advanced", () -> new TurtleBlock(Blocks.turtleProperties().method_31710(class_3620.field_15994).method_36558(2000.0f), BlockEntities.TURTLE_ADVANCED));
        public static final RegistryEntry<SpeakerBlock> SPEAKER = REGISTRY.register("speaker", () -> new SpeakerBlock(Blocks.properties().method_31710(class_3620.field_16023)));
        public static final RegistryEntry<DiskDriveBlock> DISK_DRIVE = REGISTRY.register("disk_drive", () -> new DiskDriveBlock(Blocks.properties().method_31710(class_3620.field_16023)));
        public static final RegistryEntry<PrinterBlock> PRINTER = REGISTRY.register("printer", () -> new PrinterBlock(Blocks.properties().method_31710(class_3620.field_16023)));
        public static final RegistryEntry<MonitorBlock> MONITOR_NORMAL = REGISTRY.register("monitor_normal", () -> new MonitorBlock(Blocks.properties().method_31710(class_3620.field_16023), BlockEntities.MONITOR_NORMAL));
        public static final RegistryEntry<MonitorBlock> MONITOR_ADVANCED = REGISTRY.register("monitor_advanced", () -> new MonitorBlock(Blocks.properties().method_31710(class_3620.field_15994), BlockEntities.MONITOR_ADVANCED));
        public static final RegistryEntry<WirelessModemBlock> WIRELESS_MODEM_NORMAL = REGISTRY.register("wireless_modem_normal", () -> new WirelessModemBlock(Blocks.properties().method_31710(class_3620.field_16023), BlockEntities.WIRELESS_MODEM_NORMAL));
        public static final RegistryEntry<WirelessModemBlock> WIRELESS_MODEM_ADVANCED = REGISTRY.register("wireless_modem_advanced", () -> new WirelessModemBlock(Blocks.properties().method_31710(class_3620.field_15994), BlockEntities.WIRELESS_MODEM_ADVANCED));
        public static final RegistryEntry<WiredModemFullBlock> WIRED_MODEM_FULL = REGISTRY.register("wired_modem_full", () -> new WiredModemFullBlock(Blocks.modemProperties().method_31710(class_3620.field_16023)));
        public static final RegistryEntry<CableBlock> CABLE = REGISTRY.register("cable", () -> new CableBlock(Blocks.modemProperties().method_31710(class_3620.field_16023)));

        private static class_4970.class_2251 properties() {
            return class_4970.class_2251.method_9637().method_9632(2.0f);
        }

        private static class_4970.class_2251 computerProperties() {
            return Blocks.properties().method_26236((block, level, blockPos) -> false);
        }

        private static class_4970.class_2251 turtleProperties() {
            return class_4970.class_2251.method_9637().method_9632(2.5f);
        }

        private static class_4970.class_2251 modemProperties() {
            return class_4970.class_2251.method_9637().method_9632(1.5f);
        }
    }

    public static class BlockEntities {
        static final RegistrationHelper<class_2591<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41255);
        public static final RegistryEntry<class_2591<MonitorBlockEntity>> MONITOR_NORMAL = BlockEntities.ofBlock(Blocks.MONITOR_NORMAL, (p, s) -> new MonitorBlockEntity((class_2591<? extends MonitorBlockEntity>)((class_2591)MONITOR_NORMAL.get()), p, s, false));
        public static final RegistryEntry<class_2591<MonitorBlockEntity>> MONITOR_ADVANCED = BlockEntities.ofBlock(Blocks.MONITOR_ADVANCED, (p, s) -> new MonitorBlockEntity((class_2591<? extends MonitorBlockEntity>)((class_2591)MONITOR_ADVANCED.get()), p, s, true));
        public static final RegistryEntry<class_2591<ComputerBlockEntity>> COMPUTER_NORMAL = BlockEntities.ofBlock(Blocks.COMPUTER_NORMAL, (p, s) -> new ComputerBlockEntity((class_2591<? extends ComputerBlockEntity>)((class_2591)COMPUTER_NORMAL.get()), p, s, ComputerFamily.NORMAL));
        public static final RegistryEntry<class_2591<ComputerBlockEntity>> COMPUTER_ADVANCED = BlockEntities.ofBlock(Blocks.COMPUTER_ADVANCED, (p, s) -> new ComputerBlockEntity((class_2591<? extends ComputerBlockEntity>)((class_2591)COMPUTER_ADVANCED.get()), p, s, ComputerFamily.ADVANCED));
        public static final RegistryEntry<class_2591<ComputerBlockEntity>> COMPUTER_COMMAND = BlockEntities.ofBlock(Blocks.COMPUTER_COMMAND, (p, s) -> new ComputerBlockEntity((class_2591<? extends ComputerBlockEntity>)((class_2591)COMPUTER_COMMAND.get()), p, s, ComputerFamily.COMMAND));
        public static final RegistryEntry<class_2591<TurtleBlockEntity>> TURTLE_NORMAL = BlockEntities.ofBlock(Blocks.TURTLE_NORMAL, (p, s) -> new TurtleBlockEntity((class_2591<? extends TurtleBlockEntity>)((class_2591)TURTLE_NORMAL.get()), p, s, () -> Config.turtleFuelLimit, ComputerFamily.NORMAL));
        public static final RegistryEntry<class_2591<TurtleBlockEntity>> TURTLE_ADVANCED = BlockEntities.ofBlock(Blocks.TURTLE_ADVANCED, (p, s) -> new TurtleBlockEntity((class_2591<? extends TurtleBlockEntity>)((class_2591)TURTLE_ADVANCED.get()), p, s, () -> Config.advancedTurtleFuelLimit, ComputerFamily.ADVANCED));
        public static final RegistryEntry<class_2591<SpeakerBlockEntity>> SPEAKER = BlockEntities.ofBlock(Blocks.SPEAKER, (p, s) -> new SpeakerBlockEntity((class_2591<SpeakerBlockEntity>)((class_2591)SPEAKER.get()), p, s));
        public static final RegistryEntry<class_2591<DiskDriveBlockEntity>> DISK_DRIVE = BlockEntities.ofBlock(Blocks.DISK_DRIVE, (p, s) -> new DiskDriveBlockEntity((class_2591<DiskDriveBlockEntity>)((class_2591)DISK_DRIVE.get()), p, s));
        public static final RegistryEntry<class_2591<PrinterBlockEntity>> PRINTER = BlockEntities.ofBlock(Blocks.PRINTER, (p, s) -> new PrinterBlockEntity((class_2591<PrinterBlockEntity>)((class_2591)PRINTER.get()), p, s));
        public static final RegistryEntry<class_2591<WiredModemFullBlockEntity>> WIRED_MODEM_FULL = BlockEntities.ofBlock(Blocks.WIRED_MODEM_FULL, (p, s) -> new WiredModemFullBlockEntity((class_2591<WiredModemFullBlockEntity>)((class_2591)WIRED_MODEM_FULL.get()), p, s));
        public static final RegistryEntry<class_2591<CableBlockEntity>> CABLE = BlockEntities.ofBlock(Blocks.CABLE, (p, s) -> new CableBlockEntity((class_2591<? extends CableBlockEntity>)((class_2591)CABLE.get()), p, s));
        public static final RegistryEntry<class_2591<WirelessModemBlockEntity>> WIRELESS_MODEM_NORMAL = BlockEntities.ofBlock(Blocks.WIRELESS_MODEM_NORMAL, (p, s) -> new WirelessModemBlockEntity((class_2591<? extends WirelessModemBlockEntity>)((class_2591)WIRELESS_MODEM_NORMAL.get()), p, s, false));
        public static final RegistryEntry<class_2591<WirelessModemBlockEntity>> WIRELESS_MODEM_ADVANCED = BlockEntities.ofBlock(Blocks.WIRELESS_MODEM_ADVANCED, (p, s) -> new WirelessModemBlockEntity((class_2591<? extends WirelessModemBlockEntity>)((class_2591)WIRELESS_MODEM_ADVANCED.get()), p, s, true));

        private static <T extends class_2586> RegistryEntry<class_2591<T>> ofBlock(RegistryEntry<? extends class_2248> block, class_2591.class_5559<T> factory) {
            return REGISTRY.register(block.id().method_12832(), () -> class_2591.class_2592.method_20528((class_2591.class_5559)factory, (class_2248[])new class_2248[]{(class_2248)block.get()}).method_11034(null));
        }
    }

    public static final class DataComponents {
        static final RegistrationHelper<class_9331<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_49659);
        public static final RegistryEntry<class_9331<NonNegativeId>> COMPUTER_ID = DataComponents.register("computer_id", b -> b.method_57881(NonNegativeId.CODEC).method_57882(NonNegativeId.STREAM_CODEC));
        public static final RegistryEntry<class_9331<UpgradeData<ITurtleUpgrade>>> LEFT_TURTLE_UPGRADE = DataComponents.register("left_turtle_upgrade", b -> b.method_57881(TurtleUpgrades.instance().upgradeDataCodec()).method_57882(TurtleUpgrades.instance().upgradeDataStreamCodec()));
        public static final RegistryEntry<class_9331<UpgradeData<ITurtleUpgrade>>> RIGHT_TURTLE_UPGRADE = DataComponents.register("right_turtle_upgrade", b -> b.method_57881(TurtleUpgrades.instance().upgradeDataCodec()).method_57882(TurtleUpgrades.instance().upgradeDataStreamCodec()));
        public static final RegistryEntry<class_9331<Integer>> FUEL = DataComponents.register("fuel", b -> b.method_57881((Codec)Codec.INT).method_57882(class_9135.field_48550));
        public static final RegistryEntry<class_9331<class_6880<TurtleOverlay>>> OVERLAY = DataComponents.register("overlay", b -> b.method_57881(TurtleOverlay.CODEC).method_57882(TurtleOverlay.STREAM_CODEC));
        public static final RegistryEntry<class_9331<UpgradeData<IPocketUpgrade>>> POCKET_UPGRADE = DataComponents.register("pocket_upgrade", b -> b.method_57881(PocketUpgrades.instance().upgradeDataCodec()).method_57882(PocketUpgrades.instance().upgradeDataStreamCodec()));
        public static final RegistryEntry<class_9331<ServerComputerReference>> COMPUTER = DataComponents.register("computer", b -> b.method_57881(ServerComputerReference.CODEC).method_57882(ServerComputerReference.STREAM_CODEC));
        public static final RegistryEntry<class_9331<Boolean>> ON = DataComponents.register("on", b -> b.method_57881((Codec)Codec.BOOL).method_57882(class_9135.field_48547));
        public static final RegistryEntry<class_9331<TreasureDisk>> TREASURE_DISK = DataComponents.register("treasure_disk", b -> b.method_57881(TreasureDisk.CODEC).method_57882(TreasureDisk.STREAM_CODEC));
        public static final RegistryEntry<class_9331<NonNegativeId>> DISK_ID = DataComponents.register("disk_id", b -> b.method_57881(NonNegativeId.CODEC).method_57882(NonNegativeId.STREAM_CODEC));
        public static final RegistryEntry<class_9331<PrintoutData>> PRINTOUT = DataComponents.register("printout", b -> b.method_57881(PrintoutData.CODEC).method_57882(PrintoutData.STREAM_CODEC));

        private static <T> RegistryEntry<class_9331<T>> register(String name, UnaryOperator<class_9331.class_9332<T>> unaryOperator) {
            return REGISTRY.register(name, () -> ((class_9331.class_9332)unaryOperator.apply(class_9331.method_57873())).method_57880());
        }
    }

    public static final class Items {
        static final RegistrationHelper<class_1792> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41197);
        public static final RegistryEntry<ComputerItem> COMPUTER_NORMAL = Items.ofBlock(Blocks.COMPUTER_NORMAL, ComputerItem::new);
        public static final RegistryEntry<ComputerItem> COMPUTER_ADVANCED = Items.ofBlock(Blocks.COMPUTER_ADVANCED, ComputerItem::new);
        public static final RegistryEntry<ComputerItem> COMPUTER_COMMAND = Items.ofBlock(Blocks.COMPUTER_COMMAND, CommandComputerItem::new);
        public static final RegistryEntry<PocketComputerItem> POCKET_COMPUTER_NORMAL = REGISTRY.register("pocket_computer_normal", () -> new PocketComputerItem(Items.properties().method_7889(1), ComputerFamily.NORMAL));
        public static final RegistryEntry<PocketComputerItem> POCKET_COMPUTER_ADVANCED = REGISTRY.register("pocket_computer_advanced", () -> new PocketComputerItem(Items.properties().method_7889(1), ComputerFamily.ADVANCED));
        public static final RegistryEntry<TurtleItem> TURTLE_NORMAL = Items.ofBlock(Blocks.TURTLE_NORMAL, TurtleItem::new);
        public static final RegistryEntry<TurtleItem> TURTLE_ADVANCED = Items.ofBlock(Blocks.TURTLE_ADVANCED, TurtleItem::new);
        public static final RegistryEntry<DiskItem> DISK = REGISTRY.register("disk", () -> new DiskItem(Items.properties().method_7889(1)));
        public static final RegistryEntry<TreasureDiskItem> TREASURE_DISK = REGISTRY.register("treasure_disk", () -> new TreasureDiskItem(Items.properties().method_7889(1)));
        public static final RegistryEntry<PrintoutItem> PRINTED_PAGE = REGISTRY.register("printed_page", () -> new PrintoutItem(Items.printoutProperties(), PrintoutItem.Type.PAGE));
        public static final RegistryEntry<PrintoutItem> PRINTED_PAGES = REGISTRY.register("printed_pages", () -> new PrintoutItem(Items.printoutProperties(), PrintoutItem.Type.PAGES));
        public static final RegistryEntry<PrintoutItem> PRINTED_BOOK = REGISTRY.register("printed_book", () -> new PrintoutItem(Items.printoutProperties(), PrintoutItem.Type.BOOK));
        public static final RegistryEntry<class_1747> SPEAKER = Items.ofBlock(Blocks.SPEAKER, class_1747::new);
        public static final RegistryEntry<class_1747> DISK_DRIVE = Items.ofBlock(Blocks.DISK_DRIVE, class_1747::new);
        public static final RegistryEntry<class_1747> PRINTER = Items.ofBlock(Blocks.PRINTER, class_1747::new);
        public static final RegistryEntry<class_1747> MONITOR_NORMAL = Items.ofBlock(Blocks.MONITOR_NORMAL, class_1747::new);
        public static final RegistryEntry<class_1747> MONITOR_ADVANCED = Items.ofBlock(Blocks.MONITOR_ADVANCED, class_1747::new);
        public static final RegistryEntry<class_1747> WIRELESS_MODEM_NORMAL = Items.ofBlock(Blocks.WIRELESS_MODEM_NORMAL, class_1747::new);
        public static final RegistryEntry<class_1747> WIRELESS_MODEM_ADVANCED = Items.ofBlock(Blocks.WIRELESS_MODEM_ADVANCED, class_1747::new);
        public static final RegistryEntry<class_1747> WIRED_MODEM_FULL = Items.ofBlock(Blocks.WIRED_MODEM_FULL, class_1747::new);
        public static final RegistryEntry<CableBlockItem.Cable> CABLE = REGISTRY.register("cable", () -> new CableBlockItem.Cable((CableBlock)((Object)((Object)Blocks.CABLE.get())), Items.properties()));
        public static final RegistryEntry<CableBlockItem.WiredModem> WIRED_MODEM = REGISTRY.register("wired_modem", () -> new CableBlockItem.WiredModem((CableBlock)((Object)((Object)Blocks.CABLE.get())), Items.properties()));

        private static class_1792.class_1793 properties() {
            return new class_1792.class_1793();
        }

        private static <B extends class_2248, I extends class_1792> RegistryEntry<I> ofBlock(RegistryEntry<B> parent, BiFunction<B, class_1792.class_1793, I> supplier) {
            return REGISTRY.register(parent.id().method_12832(), () -> (class_1792)supplier.apply((class_2248)parent.get(), Items.properties()));
        }

        private static class_1792.class_1793 printoutProperties() {
            return Items.properties().method_7889(1).method_57349((class_9331)DataComponents.PRINTOUT.get(), (Object)PrintoutData.EMPTY);
        }
    }

    public static class TurtleUpgradeTypes {
        static final RegistrationHelper<UpgradeType<? extends ITurtleUpgrade>> REGISTRY = PlatformHelper.get().createRegistrationHelper(ITurtleUpgrade.typeRegistry());
        public static final RegistryEntry<UpgradeType<TurtleSpeaker>> SPEAKER = REGISTRY.register("speaker", () -> UpgradeType.simpleWithCustomItem(TurtleSpeaker::new));
        public static final RegistryEntry<UpgradeType<TurtleCraftingTable>> WORKBENCH = REGISTRY.register("workbench", () -> UpgradeType.simpleWithCustomItem(TurtleCraftingTable::new));
        public static final RegistryEntry<UpgradeType<TurtleModem>> WIRELESS_MODEM = REGISTRY.register("wireless_modem", () -> UpgradeType.create(TurtleModem.CODEC));
        public static final RegistryEntry<UpgradeType<TurtleTool>> TOOL = REGISTRY.register("tool", () -> UpgradeType.create(TurtleTool.CODEC));
    }

    public static class PocketUpgradeTypes {
        static final RegistrationHelper<UpgradeType<? extends IPocketUpgrade>> REGISTRY = PlatformHelper.get().createRegistrationHelper(IPocketUpgrade.typeRegistry());
        public static final RegistryEntry<UpgradeType<PocketSpeaker>> SPEAKER = REGISTRY.register("speaker", () -> UpgradeType.simpleWithCustomItem(PocketSpeaker::new));
        public static final RegistryEntry<UpgradeType<PocketModem>> WIRELESS_MODEM = REGISTRY.register("wireless_modem", () -> UpgradeType.create(PocketModem.CODEC));
    }

    public static class Menus {
        static final RegistrationHelper<class_3917<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41207);
        public static final RegistryEntry<class_3917<ComputerMenuWithoutInventory>> COMPUTER = REGISTRY.register("computer", () -> ContainerData.toType(ComputerContainerData.STREAM_CODEC, (id, inv, data) -> new ComputerMenuWithoutInventory((class_3917<? extends AbstractComputerMenu>)((class_3917)COMPUTER.get()), id, inv, (ComputerContainerData)data)));
        public static final RegistryEntry<class_3917<ComputerMenuWithoutInventory>> POCKET_COMPUTER_NO_TERM = REGISTRY.register("pocket_computer_no_term", () -> ContainerData.toType(ComputerContainerData.STREAM_CODEC, (id, inv, data) -> new ComputerMenuWithoutInventory((class_3917<? extends AbstractComputerMenu>)((class_3917)POCKET_COMPUTER_NO_TERM.get()), id, inv, (ComputerContainerData)data)));
        public static final RegistryEntry<class_3917<TurtleMenu>> TURTLE = REGISTRY.register("turtle", () -> ContainerData.toType(ComputerContainerData.STREAM_CODEC, TurtleMenu::ofMenuData));
        public static final RegistryEntry<class_3917<DiskDriveMenu>> DISK_DRIVE = REGISTRY.register("disk_drive", () -> new class_3917(DiskDriveMenu::new, class_7701.field_40182));
        public static final RegistryEntry<class_3917<PrinterMenu>> PRINTER = REGISTRY.register("printer", () -> new class_3917(PrinterMenu::new, class_7701.field_40182));
        public static final RegistryEntry<class_3917<HeldItemMenu>> PRINTOUT = REGISTRY.register("printout", () -> ContainerData.toType(HeldItemContainerData.STREAM_CODEC, (id, inventory, data) -> new HeldItemMenu((class_3917<? extends HeldItemMenu>)((class_3917)PRINTOUT.get()), id, inventory.field_7546, data.hand())));
    }

    static class ArgumentTypes {
        static final RegistrationHelper<class_2314<?, ?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41262);

        ArgumentTypes() {
        }

        private static <T extends ArgumentType<?>> void registerUnsafe(String name, Class<T> type, class_2314<?, ?> serializer) {
            REGISTRY.register(name, () -> PlatformHelper.get().registerArgumentTypeInfo(type, serializer));
        }

        private static <T extends ArgumentType<?>> void register(String name, Class<T> type, class_2314<T, ?> serializer) {
            REGISTRY.register(name, () -> PlatformHelper.get().registerArgumentTypeInfo(type, serializer));
        }

        private static <T extends ArgumentType<?>> void register(String name, Class<T> type, T instance) {
            ArgumentTypes.register(name, type, class_2319.method_41999(() -> instance));
        }

        static {
            ArgumentTypes.register("tracking_field", TrackingFieldArgumentType.class, TrackingFieldArgumentType.metric());
            ArgumentTypes.register("computer", ComputerArgumentType.class, ComputerArgumentType.get());
            ArgumentTypes.registerUnsafe("repeat", RepeatArgumentType.class, new RepeatArgumentType.Info());
        }
    }

    public static class LootItemConditionTypes {
        static final RegistrationHelper<class_5342> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41198);
        public static final RegistryEntry<class_5342> BLOCK_NAMED = REGISTRY.register("block_named", () -> new class_5342(MapCodec.unit((Object)BlockNamedEntityLootCondition.INSTANCE)));
        public static final RegistryEntry<class_5342> PLAYER_CREATIVE = REGISTRY.register("player_creative", () -> new class_5342(MapCodec.unit((Object)PlayerCreativeLootCondition.INSTANCE)));
        public static final RegistryEntry<class_5342> HAS_ID = REGISTRY.register("has_id", () -> new class_5342(MapCodec.unit((Object)HasComputerIdLootCondition.INSTANCE)));
    }

    public static class RecipeSerializers {
        static final RegistrationHelper<class_1865<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41216);
        public static final RegistryEntry<class_1865<ImpostorShapedRecipe>> IMPOSTOR_SHAPED = REGISTRY.register("impostor_shaped", () -> CustomShapedRecipe.serialiser(ImpostorShapedRecipe::new));
        public static final RegistryEntry<class_1865<ImpostorShapelessRecipe>> IMPOSTOR_SHAPELESS = REGISTRY.register("impostor_shapeless", () -> CustomShapelessRecipe.serialiser(ImpostorShapelessRecipe::new));
        public static final RegistryEntry<class_1865<TransformShapedRecipe>> TRANSFORM_SHAPED = RecipeSerializers.register("transform_shaped", TransformShapedRecipe.CODEC, TransformShapedRecipe.STREAM_CODEC);
        public static final RegistryEntry<class_1865<TransformShapelessRecipe>> TRANSFORM_SHAPELESS = RecipeSerializers.register("transform_shapeless", TransformShapelessRecipe.CODEC, TransformShapelessRecipe.STREAM_CODEC);
        public static final RegistryEntry<class_1866<ColourableRecipe>> DYEABLE_ITEM = RecipeSerializers.simple("colour", ColourableRecipe::new);
        public static final RegistryEntry<class_1866<ClearColourRecipe>> DYEABLE_ITEM_CLEAR = RecipeSerializers.simple("clear_colour", ClearColourRecipe::new);
        public static final RegistryEntry<class_1866<TurtleUpgradeRecipe>> TURTLE_UPGRADE = RecipeSerializers.simple("turtle_upgrade", TurtleUpgradeRecipe::new);
        public static final RegistryEntry<class_1866<PocketComputerUpgradeRecipe>> POCKET_COMPUTER_UPGRADE = RecipeSerializers.simple("pocket_computer_upgrade", PocketComputerUpgradeRecipe::new);
        public static final RegistryEntry<class_1865<PrintoutRecipe>> PRINTOUT = RecipeSerializers.register("printout", PrintoutRecipe.CODEC, PrintoutRecipe.STREAM_CODEC);
        public static final RegistryEntry<class_1866<DiskRecipe>> DISK = RecipeSerializers.simple("disk", DiskRecipe::new);

        private static <T extends class_1852> RegistryEntry<class_1866<T>> simple(String name, class_1866.class_7711<T> factory) {
            return REGISTRY.register(name, () -> new class_1866(factory));
        }

        private static <T extends class_1860<?>> RegistryEntry<class_1865<T>> register(String name, MapCodec<T> codec, class_9139<class_9129, T> streamCodec) {
            return REGISTRY.register(name, () -> new BasicRecipeSerialiser(codec, streamCodec));
        }
    }

    public static class RecipeFunctions {
        static final RegistrationHelper<RecipeFunction.Type<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(RecipeFunction.REGISTRY);
        public static final RegistryEntry<RecipeFunction.Type<CopyComponents>> COPY_COMPONENTS = RecipeFunctions.register("copy_components", CopyComponents.CODEC, CopyComponents.STREAM_CODEC);

        private static <T extends RecipeFunction> RegistryEntry<RecipeFunction.Type<T>> register(String name, MapCodec<T> codec, class_9139<class_9129, T> streamCodec) {
            return REGISTRY.register(name, () -> new RecipeFunction.Type(codec, streamCodec));
        }
    }

    public static class Permissions {
        static final PermissionRegistry REGISTRY = PermissionRegistry.create();
        public static final Predicate<class_2168> PERMISSION_DUMP = REGISTRY.registerCommand("dump", UserLevel.OWNER_OP);
        public static final Predicate<class_2168> PERMISSION_SHUTDOWN = REGISTRY.registerCommand("shutdown", UserLevel.OWNER_OP);
        public static final Predicate<class_2168> PERMISSION_TURN_ON = REGISTRY.registerCommand("turn_on", UserLevel.OWNER_OP);
        public static final Predicate<class_2168> PERMISSION_TP = REGISTRY.registerCommand("tp", UserLevel.OP);
        public static final Predicate<class_2168> PERMISSION_TRACK = REGISTRY.registerCommand("track", UserLevel.OWNER_OP);
        public static final Predicate<class_2168> PERMISSION_QUEUE = REGISTRY.registerCommand("queue", UserLevel.ANYONE);
        public static final Predicate<class_2168> PERMISSION_VIEW = REGISTRY.registerCommand("view", UserLevel.OP);
    }

    static class CreativeTabs {
        static final RegistrationHelper<class_1761> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_44688);
        private static final RegistryEntry<class_1761> TAB = REGISTRY.register("tab", () -> PlatformHelper.get().newCreativeModeTab().method_47320(() -> new class_1799((class_1935)Items.COMPUTER_NORMAL.get())).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.computercraft")).method_47317((context, out) -> {
            out.method_45420(new class_1799((class_1935)Items.COMPUTER_NORMAL.get()));
            out.method_45420(new class_1799((class_1935)Items.COMPUTER_ADVANCED.get()));
            if (context.comp_1252()) {
                out.method_45420(new class_1799((class_1935)Items.COMPUTER_COMMAND.get()));
            }
            ModRegistry.addTurtle(out, (TurtleItem)Items.TURTLE_NORMAL.get(), context.comp_1253());
            ModRegistry.addTurtle(out, (TurtleItem)Items.TURTLE_ADVANCED.get(), context.comp_1253());
            ModRegistry.addPocket(out, (PocketComputerItem)Items.POCKET_COMPUTER_NORMAL.get(), context.comp_1253());
            ModRegistry.addPocket(out, (PocketComputerItem)Items.POCKET_COMPUTER_ADVANCED.get(), context.comp_1253());
            out.method_45421((class_1935)Items.WIRELESS_MODEM_NORMAL.get());
            out.method_45421((class_1935)Items.WIRELESS_MODEM_ADVANCED.get());
            out.method_45421((class_1935)Items.CABLE.get());
            out.method_45421((class_1935)Items.WIRED_MODEM.get());
            out.method_45421((class_1935)Items.WIRED_MODEM_FULL.get());
            out.method_45421((class_1935)Items.MONITOR_NORMAL.get());
            out.method_45421((class_1935)Items.MONITOR_ADVANCED.get());
            out.method_45421((class_1935)Items.SPEAKER.get());
            out.method_45421((class_1935)Items.PRINTER.get());
            out.method_45421((class_1935)Items.PRINTED_PAGE.get());
            out.method_45421((class_1935)Items.PRINTED_PAGES.get());
            out.method_45421((class_1935)Items.PRINTED_BOOK.get());
            out.method_45421((class_1935)Items.DISK_DRIVE.get());
            for (int colour = 0; colour < 16; ++colour) {
                out.method_45420(DataComponentUtil.createStack((class_1935)Items.DISK.get(), class_9334.field_49644, new class_9282(Colour.VALUES[colour].getHex(), false)));
            }
        }).method_47324());

        CreativeTabs() {
        }
    }
}

