/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import com.google.common.annotations.VisibleForTesting;
import dan200.computercraft.api.filesystem.FileOperationException;
import dan200.computercraft.core.filesystem.AbstractInMemoryMount;
import dan200.computercraft.core.filesystem.ArchiveMount;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceMount
extends ArchiveMount<FileEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceMount.class);
    private static final Map<class_2960, ResourceMount> MOUNT_CACHE = new HashMap<class_2960, ResourceMount>(2);
    private final String namespace;
    private final String subPath;
    private class_3300 manager;
    public static final class_4080<Void> RELOAD_LISTENER = new class_4080<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void prepare(class_3300 manager, class_3695 profiler) {
            profiler.method_15396("Reloading ComputerCraft mounts");
            try {
                for (ResourceMount mount : MOUNT_CACHE.values()) {
                    mount.load(manager);
                }
            }
            finally {
                profiler.method_15407();
            }
            return null;
        }

        protected void apply(Void result, class_3300 manager, class_3695 profiler) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceMount get(String namespace, String subPath, class_3300 manager) {
        class_2960 path = class_2960.method_60655((String)namespace, (String)subPath);
        Map<class_2960, ResourceMount> map = MOUNT_CACHE;
        synchronized (map) {
            ResourceMount mount = MOUNT_CACHE.get(path);
            if (mount == null) {
                mount = new ResourceMount(namespace, subPath, manager);
                MOUNT_CACHE.put(path, mount);
            }
            return mount;
        }
    }

    @VisibleForTesting
    ResourceMount(String namespace, String subPath, class_3300 manager) {
        this.namespace = namespace;
        this.subPath = subPath;
        this.load(manager);
    }

    private void load(class_3300 manager) {
        boolean hasAny = false;
        String existingNamespace = null;
        FileEntry newRoot = new FileEntry(class_2960.method_60655((String)this.namespace, (String)this.subPath));
        for (class_2960 file : manager.method_14488(this.subPath, s -> true).keySet()) {
            String localPath;
            existingNamespace = file.method_12836();
            if (!file.method_12836().equals(this.namespace) || (localPath = ResourceMount.getLocalPath(file.method_12832(), this.subPath)) == null) continue;
            try {
                this.getOrCreateChild(newRoot, localPath, this::createEntry);
            }
            catch (class_151 e) {
                LOG.warn("Cannot create resource location for {} ({})", (Object)localPath, (Object)e.getMessage());
            }
            hasAny = true;
        }
        this.manager = manager;
        AbstractInMemoryMount.FileEntry fileEntry = this.root = hasAny ? newRoot : null;
        if (!hasAny) {
            LOG.warn("Cannot find any files under /data/{}/{} for resource mount.", (Object)this.namespace, (Object)this.subPath);
            if (existingNamespace != null) {
                LOG.warn("There are files under /data/{}/{} though. Did you get the wrong namespace?", (Object)existingNamespace, (Object)this.subPath);
            }
        }
    }

    private FileEntry createEntry(String path) {
        return new FileEntry(class_2960.method_60655((String)this.namespace, (String)(this.subPath + "/" + path)));
    }

    @Override
    protected byte[] getFileContents(String path, FileEntry file) throws IOException {
        class_3298 resource = this.manager.method_14486(file.identifier).orElse(null);
        if (resource == null) {
            throw new FileOperationException(path, "No such file");
        }
        try (InputStream stream = resource.method_14482();){
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
    }

    protected static final class FileEntry
    extends ArchiveMount.FileEntry<FileEntry> {
        final class_2960 identifier;

        FileEntry(class_2960 identifier) {
            this.identifier = identifier;
        }
    }
}

