/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.details;

import com.mojang.serialization.DynamicOps;
import dan200.computercraft.shared.details.DetailHelpers;
import dan200.computercraft.shared.util.NBTUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9300;
import net.minecraft.class_9304;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

public class ItemDetails {
    public static void fillBasic(Map<? super String, Object> data, class_1799 stack) {
        String hash;
        data.put("name", DetailHelpers.getId(class_7923.field_41178, stack.method_7909()));
        data.put("count", stack.method_7947());
        class_9326 components = stack.method_57380();
        String string = hash = components.method_57848() ? null : NBTUtil.getNBTHash(class_9326.field_49589.encodeStart((DynamicOps)class_2509.field_11560, (Object)components).result().orElse(null));
        if (hash != null) {
            data.put("nbt", hash);
        }
    }

    public static void fill(Map<? super String, Object> data, class_1799 stack) {
        class_9300 unbreakable;
        List<Map<String, Object>> enchants;
        data.put("displayName", stack.method_7964().getString());
        data.put("maxCount", stack.method_7914());
        if (stack.method_7963()) {
            data.put("damage", stack.method_7919());
            data.put("maxDamage", stack.method_7936());
        }
        if (stack.method_7909().method_31567(stack)) {
            data.put("durability", (double)stack.method_7909().method_31569(stack) / 13.0);
        }
        data.put("tags", DetailHelpers.getTags(stack.method_40133()));
        data.put("itemGroups", ItemDetails.getItemGroups(stack));
        class_9290 lore = (class_9290)stack.method_57824(class_9334.field_49632);
        if (lore != null) {
            data.put("lore", lore.comp_2400().stream().map(class_2561::getString).toList());
        }
        if (!(enchants = ItemDetails.getAllEnchants(stack)).isEmpty()) {
            data.put("enchantments", enchants);
        }
        if ((unbreakable = (class_9300)stack.method_57824(class_9334.field_49630)) != null && unbreakable.comp_2417()) {
            data.put("unbreakable", true);
        }
    }

    private static List<Map<String, Object>> getItemGroups(class_1799 stack) {
        return class_7706.method_47341().stream().filter(x -> x.method_47311() && x.method_47312() == class_1761.class_7916.field_41052 && x.method_45412(stack)).map(group -> {
            HashMap<String, String> groupData = new HashMap<String, String>(2);
            class_2960 id = class_7923.field_44687.method_10221(group);
            if (id != null) {
                groupData.put("id", id.toString());
            }
            groupData.put("displayName", group.method_7737().getString());
            return groupData;
        }).toList();
    }

    private static List<Map<String, Object>> getAllEnchants(class_1799 stack) {
        ArrayList<Map<String, Object>> enchants = new ArrayList<Map<String, Object>>(0);
        ItemDetails.addEnchantments((class_9304)stack.method_57824(class_9334.field_49643), enchants);
        ItemDetails.addEnchantments((class_9304)stack.method_57824(class_9334.field_49633), enchants);
        return enchants;
    }

    private static void addEnchantments(@Nullable class_9304 rawEnchants, ArrayList<Map<String, Object>> enchants) {
        if (rawEnchants == null || rawEnchants.method_57543()) {
            return;
        }
        enchants.ensureCapacity(enchants.size() + rawEnchants.method_57541());
        for (Object2IntMap.Entry entry : rawEnchants.method_57539()) {
            class_6880 enchantment = (class_6880)entry.getKey();
            int level = entry.getIntValue();
            HashMap<String, Object> enchant = new HashMap<String, Object>(3);
            enchant.put("name", enchantment.method_55840());
            enchant.put("level", level);
            enchant.put("displayName", class_1887.method_8179((class_6880)enchantment, (int)level).getString());
            enchants.add(enchant);
        }
    }
}

