/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.DataComponentUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9331;

public final class RecipeModHelpers {
    static final List<Supplier<TurtleItem>> TURTLES = List.of(ModRegistry.Items.TURTLE_NORMAL, ModRegistry.Items.TURTLE_ADVANCED);
    static final List<Supplier<PocketComputerItem>> POCKET_COMPUTERS = List.of(ModRegistry.Items.POCKET_COMPUTER_NORMAL, ModRegistry.Items.POCKET_COMPUTER_ADVANCED);

    private RecipeModHelpers() {
    }

    public static boolean shouldRemoveRecipe(class_2960 id) {
        if (!id.method_12836().equals("computercraft")) {
            return false;
        }
        String path = id.method_12832();
        return path.startsWith("turtle_normal/") || path.startsWith("turtle_advanced/") || path.startsWith("pocket_normal/") || path.startsWith("pocket_advanced/");
    }

    public static List<class_1799> getExtraStacks(class_7225.class_7874 registries) {
        ArrayList<class_1799> upgradeItems = new ArrayList<class_1799>();
        for (Supplier<TurtleItem> supplier : TURTLES) {
            TurtleItem turtle = supplier.get();
            RecipeModHelpers.forEachRegistry(registries, ITurtleUpgrade.REGISTRY, upgrade -> upgradeItems.add(DataComponentUtil.createStack((class_1935)turtle, (class_9331)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), UpgradeData.ofDefault(upgrade))));
        }
        for (Supplier<IMedia> supplier : POCKET_COMPUTERS) {
            PocketComputerItem pocket = (PocketComputerItem)supplier.get();
            RecipeModHelpers.forEachRegistry(registries, IPocketUpgrade.REGISTRY, upgrade -> upgradeItems.add(DataComponentUtil.createStack((class_1935)pocket, (class_9331)ModRegistry.DataComponents.POCKET_UPGRADE.get(), UpgradeData.ofDefault(upgrade))));
        }
        return upgradeItems;
    }

    static <T> void forEachRegistry(class_7225.class_7874 registries, class_5321<class_2378<T>> registry, Consumer<class_6880.class_6883<T>> consumer) {
        registries.method_46759(registry).map(class_7225::method_42017).orElse(Stream.empty()).forEach(consumer);
    }
}

