/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network;

import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ChatTableClientMessage;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.network.client.PlayRecordClientMessage;
import dan200.computercraft.shared.network.client.PocketComputerDataMessage;
import dan200.computercraft.shared.network.client.PocketComputerDeletedClientMessage;
import dan200.computercraft.shared.network.client.SpeakerAudioClientMessage;
import dan200.computercraft.shared.network.client.SpeakerMoveClientMessage;
import dan200.computercraft.shared.network.client.SpeakerPlayClientMessage;
import dan200.computercraft.shared.network.client.SpeakerStopClientMessage;
import dan200.computercraft.shared.network.client.UploadResultMessage;
import dan200.computercraft.shared.network.server.ComputerActionServerMessage;
import dan200.computercraft.shared.network.server.KeyEventServerMessage;
import dan200.computercraft.shared.network.server.MouseEventServerMessage;
import dan200.computercraft.shared.network.server.QueueEventServerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import dan200.computercraft.shared.network.server.UploadFileMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public final class NetworkMessages {
    private static final Set<String> seenChannel = new HashSet<String>();
    private static final List<class_8710.class_9155<class_9129, ? extends NetworkMessage<ServerNetworkContext>>> serverMessages = new ArrayList<class_8710.class_9155<class_9129, ? extends NetworkMessage<ServerNetworkContext>>>();
    private static final List<class_8710.class_9155<class_9129, ? extends NetworkMessage<ClientNetworkContext>>> clientMessages = new ArrayList<class_8710.class_9155<class_9129, ? extends NetworkMessage<ClientNetworkContext>>>();
    public static final class_8710.class_9154<ComputerActionServerMessage> COMPUTER_ACTION = NetworkMessages.registerServerbound("computer_action", ComputerActionServerMessage.STREAM_CODEC);
    public static final class_8710.class_9154<QueueEventServerMessage> QUEUE_EVENT = NetworkMessages.register(serverMessages, "queue_event", QueueEventServerMessage.STREAM_CODEC);
    public static final class_8710.class_9154<KeyEventServerMessage> KEY_EVENT = NetworkMessages.registerServerbound("key_event", KeyEventServerMessage.STREAM_CODEC);
    public static final class_8710.class_9154<MouseEventServerMessage> MOUSE_EVENT = NetworkMessages.registerServerbound("mouse_event", MouseEventServerMessage.STREAM_CODEC);
    public static final class_8710.class_9154<UploadFileMessage> UPLOAD_FILE = NetworkMessages.register(serverMessages, "upload_file", UploadFileMessage.STREAM_CODEC);
    public static final class_8710.class_9154<ChatTableClientMessage> CHAT_TABLE = NetworkMessages.registerClientbound("chat_table", ChatTableClientMessage.STREAM_CODEC);
    public static final class_8710.class_9154<PocketComputerDataMessage> POCKET_COMPUTER_DATA = NetworkMessages.registerClientbound("pocket_computer_data", PocketComputerDataMessage.STREAM_CODEC);
    public static final class_8710.class_9154<PocketComputerDeletedClientMessage> POCKET_COMPUTER_DELETED = NetworkMessages.registerClientbound("pocket_computer_deleted", PocketComputerDeletedClientMessage.STREAM_CODEC);
    public static final class_8710.class_9154<ComputerTerminalClientMessage> COMPUTER_TERMINAL = NetworkMessages.registerClientbound("computer_terminal", ComputerTerminalClientMessage.STREAM_CODEC);
    public static final class_8710.class_9154<PlayRecordClientMessage> PLAY_RECORD = NetworkMessages.registerClientbound("play_record", PlayRecordClientMessage.STREAM_CODEC);
    public static final class_8710.class_9154<MonitorClientMessage> MONITOR_CLIENT = NetworkMessages.registerClientbound("monitor_client", MonitorClientMessage.STREAM_CODEC);
    public static final class_8710.class_9154<SpeakerAudioClientMessage> SPEAKER_AUDIO = NetworkMessages.registerClientbound("speaker_audio", SpeakerAudioClientMessage.STREAM_CODEC);
    public static final class_8710.class_9154<SpeakerMoveClientMessage> SPEAKER_MOVE = NetworkMessages.registerClientbound("speaker_move", SpeakerMoveClientMessage.STREAM_CODEC);
    public static final class_8710.class_9154<SpeakerPlayClientMessage> SPEAKER_PLAY = NetworkMessages.registerClientbound("speaker_play", SpeakerPlayClientMessage.STREAM_CODEC);
    public static final class_8710.class_9154<SpeakerStopClientMessage> SPEAKER_STOP = NetworkMessages.registerClientbound("speaker_stop", SpeakerStopClientMessage.STREAM_CODEC);
    public static final class_8710.class_9154<UploadResultMessage> UPLOAD_RESULT = NetworkMessages.registerClientbound("upload_result", UploadResultMessage.STREAM_CODEC);

    private NetworkMessages() {
    }

    private static <C, T extends NetworkMessage<C>> class_8710.class_9154<T> register(List<class_8710.class_9155<class_9129, ? extends NetworkMessage<C>>> messages, String channel, class_9139<class_9129, T> codec) {
        if (!seenChannel.add(channel)) {
            throw new IllegalArgumentException("Duplicate channel " + channel);
        }
        class_8710.class_9154 type = new class_8710.class_9154(class_2960.method_60655((String)"computercraft", (String)channel));
        messages.add(new class_8710.class_9155(type, codec));
        return type;
    }

    private static <T extends NetworkMessage<ServerNetworkContext>> class_8710.class_9154<T> registerServerbound(String id, class_9139<class_9129, T> codec) {
        return NetworkMessages.register(serverMessages, id, codec);
    }

    private static <T extends NetworkMessage<ClientNetworkContext>> class_8710.class_9154<T> registerClientbound(String id, class_9139<class_9129, T> codec) {
        return NetworkMessages.register(clientMessages, id, codec);
    }

    public static Collection<class_8710.class_9155<class_9129, ? extends NetworkMessage<ServerNetworkContext>>> getServerbound() {
        return Collections.unmodifiableCollection(serverMessages);
    }

    public static Collection<class_8710.class_9155<class_9129, ? extends NetworkMessage<ClientNetworkContext>>> getClientbound() {
        return Collections.unmodifiableCollection(clientMessages);
    }
}

