/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.items.ServerComputerReference;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.pocket.core.PocketBrain;
import dan200.computercraft.shared.pocket.core.PocketHolder;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.inventory.PocketComputerMenuProvider;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.NonNegativeId;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9322;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;

public class PocketComputerItem
extends class_1792
implements IMedia {
    private final ComputerFamily family;

    public PocketComputerItem(class_1792.class_1793 settings, ComputerFamily family) {
        super(settings);
        this.family = family;
    }

    private void tick(class_1799 stack, PocketHolder holder, PocketBrain brain) {
        brain.updateHolder(holder);
        UpgradeData<IPocketUpgrade> upgrade = brain.getUpgrade();
        if (upgrade != null) {
            upgrade.upgrade().update(brain, brain.computer().getPeripheral(ComputerSide.BACK));
        }
        if (this.updateItem(stack, brain)) {
            holder.setChanged();
        }
    }

    private boolean updateItem(class_1799 stack, PocketBrain brain) {
        boolean on;
        boolean changed = brain.updateItem(stack);
        PocketServerComputer computer = brain.computer();
        String label = computer.getLabel();
        if (!Objects.equals(label, this.getLabel(stack))) {
            changed = true;
            this.setLabel(stack, label);
        }
        if ((on = computer.isOn()) != PocketComputerItem.isMarkedOn(stack)) {
            changed = true;
            stack.method_57379((class_9331)ModRegistry.DataComponents.ON.get(), (Object)on);
        }
        return changed;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slotNum, boolean selected) {
        if (world.field_9236 || !(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        PocketHolder.PlayerHolder holder = new PocketHolder.PlayerHolder(player, slotNum);
        PocketBrain brain = this.getOrCreateBrain((class_3218)world, holder, stack);
        brain.computer().keepAlive();
        this.tick(stack, holder, brain);
    }

    public boolean onEntityItemUpdate(class_1799 stack, class_1542 entity) {
        class_1937 level = entity.method_37908();
        if (level.field_9236 || level.method_8503() == null) {
            return false;
        }
        PocketServerComputer computer = PocketComputerItem.getServerComputer(level.method_8503(), stack);
        if (computer != null) {
            this.tick(stack, new PocketHolder.ItemEntityHolder(entity), computer.getBrain());
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236) {
            PocketHolder.PlayerHolder holder = new PocketHolder.PlayerHolder((class_3222)player, InventoryUtil.getHandSlot(player, hand));
            PocketBrain brain = this.getOrCreateBrain((class_3218)world, holder, stack);
            PocketServerComputer computer = brain.computer();
            computer.turnOn();
            boolean stop = false;
            IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
            if (upgrade != null) {
                brain.updateHolder(holder);
                stop = upgrade.onRightClick(world, brain, computer.getPeripheral(ComputerSide.BACK));
                this.updateItem(stack, brain);
            }
            if (!stop) {
                boolean isTypingOnly = hand == class_1268.field_5810;
                new ComputerContainerData(computer, stack).open(player, new PocketComputerMenuProvider(computer, stack, this, hand, isTypingOnly));
            }
        }
        return new class_1271(class_1269.method_29236((boolean)world.field_9236), (Object)stack);
    }

    public class_2561 method_7864(class_1799 stack) {
        String baseString = this.method_7866(stack);
        IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
        if (upgrade != null) {
            return class_2561.method_43469((String)(baseString + ".upgraded"), (Object[])new Object[]{upgrade.getAdjective()});
        }
        return super.method_7864(stack);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> list, class_1836 flag) {
        NonNegativeId id;
        if ((flag.method_8035() || this.getLabel(stack) == null) && (id = (NonNegativeId)stack.method_57824((class_9331)ModRegistry.DataComponents.COMPUTER_ID.get())) != null) {
            list.add((class_2561)class_2561.method_43469((String)"gui.computercraft.tooltip.computer_id", (Object[])new Object[]{id.id()}).method_27692(class_124.field_1080));
        }
    }

    @Nullable
    public String getCreatorModId(class_1799 stack) {
        UpgradeData<IPocketUpgrade> upgrade = PocketComputerItem.getUpgradeWithData(stack);
        return upgrade != null ? PocketUpgrades.instance().getOwner(upgrade.holder()) : "computercraft";
    }

    private PocketBrain getOrCreateBrain(class_3218 level, PocketHolder holder, class_1799 stack) {
        ServerComputerRegistry registry = ServerContext.get(level.method_8503()).registry();
        PocketServerComputer computer = PocketComputerItem.getServerComputer(registry, stack);
        if (computer != null) {
            return computer.getBrain();
        }
        int computerID = NonNegativeId.getOrCreate(level.method_8503(), stack, (class_9331<NonNegativeId>)((class_9331)ModRegistry.DataComponents.COMPUTER_ID.get()), "computer");
        PocketBrain brain = new PocketBrain(holder, computerID, this.getLabel(stack), this.getFamily(), PocketComputerItem.getUpgradeWithData(stack));
        PocketServerComputer computer2 = brain.computer();
        stack.method_57379((class_9331)ModRegistry.DataComponents.COMPUTER.get(), (Object)new ServerComputerReference(registry.getSessionID(), computer2.register()));
        if (PocketComputerItem.isMarkedOn(stack) && holder instanceof PocketHolder.PlayerHolder) {
            computer2.turnOn();
        }
        this.updateItem(stack, brain);
        holder.setChanged();
        return brain;
    }

    public static boolean isServerComputer(ServerComputer computer, class_1799 stack) {
        return stack.method_7909() instanceof PocketComputerItem && PocketComputerItem.getServerComputer(computer.getLevel().method_8503(), stack) == computer;
    }

    @Nullable
    public static PocketServerComputer getServerComputer(ServerComputerRegistry registry, class_1799 stack) {
        return (PocketServerComputer)ServerComputerReference.get((class_9322)stack, registry);
    }

    @Nullable
    public static PocketServerComputer getServerComputer(MinecraftServer server, class_1799 stack) {
        return PocketComputerItem.getServerComputer(ServerContext.get(server).registry(), stack);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    @Nullable
    private String getLabel(class_1799 stack) {
        return DataComponentUtil.getCustomName((class_9322)stack);
    }

    @Override
    @Nullable
    public String getLabel(class_7225.class_7874 registries, class_1799 stack) {
        return this.getLabel(stack);
    }

    @Override
    public boolean setLabel(class_1799 stack, @Nullable String label) {
        DataComponentUtil.setCustomName(stack, label);
        return true;
    }

    @Override
    @Nullable
    public Mount createDataMount(class_1799 stack, class_3218 level) {
        NonNegativeId id = (NonNegativeId)stack.method_57824((class_9331)ModRegistry.DataComponents.COMPUTER_ID.get());
        if (id != null) {
            return ComputerCraftAPI.createSaveDirMount(level.method_8503(), "computer/" + id.id(), Config.computerSpaceLimit);
        }
        return null;
    }

    private static boolean isMarkedOn(class_1799 stack) {
        return (Boolean)stack.method_57825((class_9331)ModRegistry.DataComponents.ON.get(), (Object)false);
    }

    @Nullable
    public static IPocketUpgrade getUpgrade(class_1799 stack) {
        UpgradeData<IPocketUpgrade> upgrade = PocketComputerItem.getUpgradeWithData(stack);
        return upgrade == null ? null : upgrade.upgrade();
    }

    @Nullable
    public static UpgradeData<IPocketUpgrade> getUpgradeWithData(class_1799 stack) {
        return (UpgradeData)stack.method_57824((class_9331)ModRegistry.DataComponents.POCKET_UPGRADE.get());
    }

    public static void setUpgrade(class_1799 stack, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        stack.method_57379((class_9331)ModRegistry.DataComponents.POCKET_UPGRADE.get(), upgrade);
    }
}

