/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import com.mojang.serialization.MapCodec;
import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleToolDurability;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.api.upgrades.UpgradeType;
import dan200.computercraft.impl.upgrades.TurtleToolSpec;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.TurtlePlaceCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3483;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5552;
import net.minecraft.class_6862;
import net.minecraft.class_9109;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

public class TurtleTool
extends AbstractTurtleUpgrade {
    public static final MapCodec<TurtleTool> CODEC = TurtleToolSpec.CODEC.xmap(TurtleTool::new, x -> x.spec);
    private static final TurtleCommandResult UNBREAKABLE = TurtleCommandResult.failure("Cannot break unbreakable block");
    private static final TurtleCommandResult INEFFECTIVE = TurtleCommandResult.failure("Cannot break block with this tool");
    final TurtleToolSpec spec;
    @Nullable
    final class_6862<class_2248> breakable;

    public TurtleTool(TurtleToolSpec spec) {
        super(TurtleUpgradeType.TOOL, spec.adjective(), new class_1799((class_1935)spec.item()));
        this.spec = spec;
        this.breakable = spec.breakable().orElse(null);
    }

    @Override
    public boolean isItemSuitable(class_1799 stack) {
        if (this.spec.consumeDurability() == TurtleToolDurability.NEVER && stack.method_7986()) {
            return false;
        }
        return this.spec.allowEnchantments() || !TurtleTool.isEnchanted(stack);
    }

    private static boolean isEnchanted(class_1799 stack) {
        class_9326 patch = stack.method_57380();
        return DataComponentUtil.isPresent(patch, class_9334.field_49633, x -> !x.method_57543()) || DataComponentUtil.isPresent(patch, class_9334.field_49636, x -> !x.comp_2393().isEmpty());
    }

    @Override
    public class_9326 getUpgradeData(class_1799 stack) {
        return stack.method_57380();
    }

    @Override
    public class_1799 getUpgradeItem(class_9326 upgradeData) {
        class_1799 item = super.getUpgradeItem(upgradeData).method_7972();
        item.method_57366(upgradeData);
        return item;
    }

    private class_1799 getToolStack(ITurtleAccess turtle, TurtleSide side) {
        return this.getUpgradeItem(turtle.getUpgradeData(side));
    }

    private void setToolStack(ITurtleAccess turtle, TurtleSide side, class_1799 oldStack, class_1799 stack) {
        boolean useDurability;
        switch (this.spec.consumeDurability()) {
            default: {
                throw new MatchException(null, null);
            }
            case NEVER: {
                boolean bl = false;
                break;
            }
            case WHEN_ENCHANTED: {
                boolean bl = TurtleTool.isEnchanted(oldStack);
                break;
            }
            case ALWAYS: {
                boolean bl = useDurability = true;
            }
        }
        if (!useDurability) {
            return;
        }
        if (stack.method_7960()) {
            turtle.setUpgrade(side, null);
            return;
        }
        if (stack.method_7909() != this.spec.item()) {
            return;
        }
        turtle.setUpgradeData(side, stack.method_57380());
    }

    private <T> T withEquippedItem(ITurtleAccess turtle, TurtleSide side, class_2350 direction, Function<TurtlePlayer, T> action) {
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, turtle.getPosition(), direction);
        class_1799 stack = this.getToolStack(turtle, side);
        turtlePlayer.loadInventory(stack.method_7972());
        T result = action.apply(turtlePlayer);
        this.setToolStack(turtle, side, stack, turtlePlayer.player().method_5998(class_1268.field_5808));
        turtlePlayer.player().method_31548().method_5448();
        return result;
    }

    @Override
    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, class_2350 direction) {
        return switch (verb) {
            default -> throw new MatchException(null, null);
            case TurtleVerb.ATTACK -> this.attack(turtle, side, direction);
            case TurtleVerb.DIG -> this.dig(turtle, side, direction);
        };
    }

    protected TurtleCommandResult checkBlockBreakable(class_1937 world, class_2338 pos, TurtlePlayer player) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26215() || state.method_26204() instanceof class_5552 || state.method_26165((class_1657)player.player(), (class_1922)world, pos) <= 0.0f) {
            return UNBREAKABLE;
        }
        return this.breakable == null || state.method_26164(this.breakable) || TurtleTool.isTriviallyBreakable((class_1922)world, pos, state) ? TurtleCommandResult.success() : INEFFECTIVE;
    }

    private TurtleCommandResult attack(ITurtleAccess turtle, TurtleSide side, class_2350 direction) {
        class_1937 world = turtle.getLevel();
        class_2338 position = turtle.getPosition();
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, position, direction);
        class_3222 player = turtlePlayer.player();
        class_243 turtlePos = player.method_19538();
        class_243 rayDir = player.method_5828(1.0f);
        class_239 hit = WorldUtil.clip(world, turtlePos, rayDir, 1.5, null);
        boolean attacked = false;
        if (hit instanceof class_3966) {
            class_3966 entityHit = (class_3966)hit;
            class_1799 stack = this.getToolStack(turtle, side);
            turtlePlayer.loadInventory(stack.method_7972());
            class_1297 hitEntity = entityHit.method_17782();
            DropConsumer.set(hitEntity, TurtleUtil.dropConsumer(turtle));
            class_1269 result = PlatformHelper.get().canAttackEntity(player, hitEntity);
            if (result.method_23665()) {
                attacked = true;
            } else if (result == class_1269.field_5811 && hitEntity.method_5732() && !hitEntity.method_5698((class_1297)player)) {
                attacked = this.attack(player, direction, hitEntity);
            }
            TurtleUtil.stopConsuming(turtle);
            this.setToolStack(turtle, side, stack, player.method_5998(class_1268.field_5808));
            player.method_31548().method_5448();
        }
        return attacked ? TurtleCommandResult.success() : TurtleCommandResult.failure("Nothing to attack here");
    }

    private boolean attack(class_3222 player, class_2350 direction, class_1297 entity) {
        class_1309 target;
        float knockBack;
        class_1676 projectile;
        float baseDamage = (float)player.method_45325(class_5134.field_23721) * this.spec.damageMultiplier();
        class_1799 tool = player.method_59958();
        class_1282 source = player.method_48923().method_48802((class_1657)player);
        float bonusDamage = class_1890.method_60120((class_3218)player.method_51469(), (class_1799)tool, (class_1297)entity, (class_1282)source, (float)baseDamage) - baseDamage;
        if (entity.method_5864().method_20210(class_3483.field_51503) && entity instanceof class_1676 && (projectile = (class_1676)entity).method_59859(class_9109.field_51509, (class_1297)player, (class_1297)player, true)) {
            return true;
        }
        if (baseDamage <= 0.0f && bonusDamage <= 0.0f) {
            return false;
        }
        class_243 entityVelocity = entity.method_18798();
        float damage = baseDamage + bonusDamage + tool.method_7909().method_58403(entity, baseDamage, source);
        if (!entity.method_5643(source, damage)) {
            return false;
        }
        if (entity.method_5805() && entity instanceof class_1531) {
            entity.method_5643(source, damage);
        }
        if ((knockBack = class_1890.method_60175((class_3218)player.method_51469(), (class_1799)tool, (class_1297)entity, (class_1282)source, (float)((float)player.method_45325(class_5134.field_23722)))) > 0.0f) {
            if (entity instanceof class_1309) {
                class_1309 target2 = (class_1309)entity;
                target2.method_6005((double)knockBack * 0.5, (double)(-direction.method_10148()), (double)(-direction.method_10165()));
            } else {
                entity.method_5762((double)((float)direction.method_10148() * knockBack) * 0.5, 0.1, (double)((float)direction.method_10165() * knockBack) * 0.5);
            }
        }
        if (entity instanceof class_3222) {
            class_3222 otherPlayer = (class_3222)entity;
            if (entity.field_6037) {
                otherPlayer.field_13987.method_14364((class_2596)new class_2743(entity));
                entity.field_6037 = false;
                entity.method_18799(entityVelocity);
            }
        }
        boolean didHurt = entity instanceof class_1309 && tool.method_7979(target = (class_1309)entity, (class_1657)player);
        class_1890.method_60107((class_3218)player.method_51469(), (class_1297)entity, (class_1282)source);
        if (!tool.method_7960() && entity instanceof class_1309 && didHurt) {
            tool.method_59979((class_1309)entity, (class_1657)player);
        }
        return true;
    }

    private TurtleCommandResult dig(ITurtleAccess turtle, TurtleSide side, class_2350 direction) {
        class_3218 level = (class_3218)turtle.getLevel();
        return this.withEquippedItem(turtle, side, direction, turtlePlayer -> {
            class_1799 stack = turtlePlayer.player().method_5998(class_1268.field_5808);
            if (PlatformHelper.get().hasToolUsage(stack) && this.useTool(level, turtle, (TurtlePlayer)turtlePlayer, stack, direction)) {
                return TurtleCommandResult.success();
            }
            class_2338 blockPosition = turtle.getPosition().method_10093(direction);
            if (level.method_22347(blockPosition) || WorldUtil.isLiquidBlock((class_1937)level, blockPosition)) {
                return TurtleCommandResult.failure("Nothing to dig here");
            }
            TurtleCommandResult breakable = this.checkBlockBreakable((class_1937)level, blockPosition, (TurtlePlayer)turtlePlayer);
            if (!breakable.isSuccess()) {
                return breakable;
            }
            DropConsumer.set((class_1937)level, blockPosition, TurtleUtil.dropConsumer(turtle));
            boolean broken = !turtlePlayer.isBlockProtected(level, blockPosition) && turtlePlayer.player().field_13974.method_14266(blockPosition);
            TurtleUtil.stopConsuming(turtle);
            return broken ? TurtleCommandResult.success() : TurtleCommandResult.failure("Cannot break protected block");
        });
    }

    private boolean useTool(class_3218 level, ITurtleAccess turtle, TurtlePlayer turtlePlayer, class_1799 stack, class_2350 direction) {
        class_2338 position = turtle.getPosition().method_10093(direction);
        if (direction == class_2350.field_11033 && level.method_22347(position)) {
            position = position.method_10093(direction);
        }
        if (!level.method_24794(position) || level.method_22347(position) || turtlePlayer.isBlockProtected(level, position)) {
            return false;
        }
        class_3965 hit = TurtlePlaceCommand.getHitResult(position, direction.method_10153());
        class_1269 result = PlatformHelper.get().useOn(turtlePlayer.player(), stack, hit, x -> false);
        return result.method_23665();
    }

    private static boolean isTriviallyBreakable(class_1922 reader, class_2338 pos, class_2680 state) {
        return state.method_26164(ComputerCraftTags.Blocks.TURTLE_ALWAYS_BREAKABLE) || state.method_26214(reader, pos) == 0.0f;
    }

    public UpgradeType<TurtleTool> getType() {
        return (UpgradeType)ModRegistry.TurtleUpgradeTypes.TOOL.get();
    }
}

