/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.mixin.text;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import io.wispforest.owo.text.CustomTextRegistry;
import java.util.stream.Stream;
import net.minecraft.class_3542;
import net.minecraft.class_7417;
import net.minecraft.class_8824;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_8824.class})
public abstract class TextCodecsMixin {
    @ModifyVariable(method={"dispatchingCodec"}, at=@At(value="STORE", ordinal=0))
    private static <T extends class_3542> Codec<T> injectCustomTextTypesExplicit(final Codec<T> codec, T[] types) {
        if (!types.getClass().getComponentType().isAssignableFrom(class_7417.class_8823.class)) {
            return codec;
        }
        final Codec customTextTypeCodec = Codec.stringResolver(class_3542::method_15434, s -> CustomTextRegistry.typesMap().get(s).type());
        return new Codec<T>(){

            public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
                DataResult vanillaResult = codec.decode(ops, input);
                if (vanillaResult.result().isPresent()) {
                    return vanillaResult;
                }
                return customTextTypeCodec.decode(ops, input);
            }

            public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
                DataResult vanillaResult = codec.encode(input, ops, prefix);
                if (vanillaResult.result().isPresent()) {
                    return vanillaResult;
                }
                return customTextTypeCodec.encode(input, ops, prefix);
            }
        };
    }

    @ModifyVariable(method={"dispatchingCodec"}, at=@At(value="STORE", ordinal=0))
    private static <T extends class_3542, E> MapCodec<E> injectCustomTextTypesFuzzy(final MapCodec<E> codec, T[] types) {
        if (!types.getClass().getComponentType().isAssignableFrom(class_7417.class_8823.class)) {
            return codec;
        }
        return new MapCodec<E>(){

            public <T1> DataResult<E> decode(DynamicOps<T1> ops, MapLike<T1> input) {
                DataResult vanillaResult = codec.decode(ops, input);
                if (vanillaResult.result().isPresent()) {
                    return vanillaResult;
                }
                for (CustomTextRegistry.Entry<?> entry : CustomTextRegistry.typesMap().values()) {
                    if (input.get(entry.triggerField()) == null) continue;
                    return entry.type().comp_1983().decode(ops, input);
                }
                return vanillaResult;
            }

            public <T1> RecordBuilder<T1> encode(E input, DynamicOps<T1> ops, RecordBuilder<T1> prefix) {
                return codec.encode(input, ops, prefix);
            }

            public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
                return Stream.concat(codec.keys(ops), CustomTextRegistry.typesMap().values().stream().flatMap(entry -> entry.type().comp_1983().keys(ops)));
            }
        };
    }
}

