/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.parsing;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonGrammar;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import blue.endless.jankson.api.SyntaxError;
import io.wispforest.owo.Owo;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.parsing.UIModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class UIModelLoader
implements class_4013,
IdentifiableResourceReloadListener {
    private static final Map<class_2960, UIModel> LOADED_MODELS = new HashMap<class_2960, UIModel>();
    private static final Jankson JANKSON = Jankson.builder().registerSerializer(Path.class, (path, marshaller) -> JsonPrimitive.of((String)path.toString())).registerSerializer(class_2960.class, (identifier, marshaller) -> new JsonPrimitive((Object)identifier.toString())).build();
    private static final Path HOT_RELOAD_LOCATIONS_PATH = FabricLoader.getInstance().getConfigDir().resolve("owo_ui_hot_reload_locations.json5");
    private static final Map<class_2960, Path> HOT_RELOAD_LOCATIONS = new HashMap<class_2960, Path>();
    private static boolean loadedOnce = false;

    @Nullable
    public static UIModel get(class_2960 id) {
        if (Owo.DEBUG && HOT_RELOAD_LOCATIONS.containsKey(id)) {
            UIModel uIModel;
            block9: {
                InputStream stream = Files.newInputStream(HOT_RELOAD_LOCATIONS.get(id), new OpenOption[0]);
                try {
                    uIModel = UIModel.load(stream);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        class_310.method_1551().field_1724.method_43496((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)TextOps.withFormatting("hot ui model reload failed, check the log for details", class_124.field_1061)));
                        Owo.LOGGER.error("Hot UI model reload failed", (Throwable)e);
                    }
                }
                stream.close();
            }
            return uIModel;
        }
        return UIModelLoader.getPreloaded(id);
    }

    @Nullable
    public static UIModel getPreloaded(class_2960 id) {
        return LOADED_MODELS.getOrDefault(id, null);
    }

    public static void setHotReloadPath(class_2960 modelId, @Nullable Path reloadPath) {
        if (reloadPath != null) {
            HOT_RELOAD_LOCATIONS.put(modelId, reloadPath);
        } else {
            HOT_RELOAD_LOCATIONS.remove(modelId);
        }
        try {
            Files.writeString(HOT_RELOAD_LOCATIONS_PATH, (CharSequence)JANKSON.toJson(HOT_RELOAD_LOCATIONS).toJson(JsonGrammar.JSON5), new OpenOption[0]);
        }
        catch (IOException e) {
            Owo.LOGGER.warn("Could not save hot reload locations", (Throwable)e);
        }
    }

    @Nullable
    public static Path getHotReloadPath(class_2960 modelId) {
        return HOT_RELOAD_LOCATIONS.get(modelId);
    }

    public static Set<class_2960> allLoadedModels() {
        return Collections.unmodifiableSet(LOADED_MODELS.keySet());
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"owo", (String)"ui-model-loader");
    }

    public void method_14491(class_3300 manager) {
        LOADED_MODELS.clear();
        manager.method_14488("owo_ui", identifier -> identifier.method_12832().endsWith(".xml")).forEach((resourceId, resource) -> {
            try {
                class_2960 modelId = class_2960.method_60655((String)resourceId.method_12836(), (String)resourceId.method_12832().substring(7, resourceId.method_12832().length() - 4));
                LOADED_MODELS.put(modelId, UIModel.load(resource.method_14482()));
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                Owo.LOGGER.error("Could not parse UI model {}", resourceId, (Object)e);
            }
        });
        loadedOnce = true;
    }

    @ApiStatus.Internal
    public static boolean hasCompletedInitialLoad() {
        return loadedOnce;
    }

    static {
        if (Owo.DEBUG && Files.exists(HOT_RELOAD_LOCATIONS_PATH, new LinkOption[0])) {
            try (InputStream stream = Files.newInputStream(HOT_RELOAD_LOCATIONS_PATH, new OpenOption[0]);){
                JsonObject associations = JANKSON.load(stream);
                associations.forEach((key, value) -> {
                    if (!(value instanceof JsonPrimitive)) {
                        return;
                    }
                    JsonPrimitive primitive = (JsonPrimitive)value;
                    HOT_RELOAD_LOCATIONS.put(class_2960.method_60654((String)key), Path.of(primitive.asString(), new String[0]));
                });
            }
            catch (SyntaxError | IOException throwable) {
                // empty catch block
            }
        }
    }
}

