/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.thedustbuster.CarpetExtraExtrasSettings;
import net.thedustbuster.rules.CarpetExtraExtrasRule;
import net.thedustbuster.rules.bots.CarpetBotRules;
import net.thedustbuster.rules.bpcl.BetterPearlChunkLoading;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CarpetExtraExtrasServer
implements CarpetExtension,
ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"carpet-extra-extras");
    private static final List<CarpetExtraExtrasRule> rules = new ArrayList<CarpetExtraExtrasRule>();

    public static void registerRule(CarpetExtraExtrasRule c) {
        rules.add(c);
    }

    public String version() {
        return "carpet-extra-extras";
    }

    public void onInitialize() {
        CarpetServer.manageExtension((CarpetExtension)this);
        CarpetExtraExtrasServer.registerRule(CarpetBotRules.INSTANCE);
        CarpetExtraExtrasServer.registerRule(BetterPearlChunkLoading.INSTANCE);
    }

    public void onTick(MinecraftServer server) {
        rules.forEach(CarpetExtraExtrasRule::onTick);
    }

    public void onPlayerLoggedIn(class_3222 player) {
        rules.forEach(rule -> rule.onPlayerLoggedIn(player));
    }

    public void onPlayerLoggedOut(class_3222 player) {
        rules.forEach(rule -> rule.onPlayerLoggedOut(player));
    }

    public void onGameStarted() {
        CarpetServer.settingsManager.parseSettingsClass(CarpetExtraExtrasSettings.class);
        rules.forEach(CarpetExtraExtrasRule::onGameStarted);
    }

    public Map<String, String> canHasTranslations(String lang) {
        String jsonData;
        InputStream langFile = CarpetExtraExtrasServer.class.getClassLoader().getResourceAsStream("assets/carpet-extra-extras/lang/%s.json".formatted(lang));
        if (langFile == null) {
            return Collections.emptyMap();
        }
        try {
            jsonData = IOUtils.toString((InputStream)langFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        Gson gson = new GsonBuilder().setLenient().create();
        return (Map)gson.fromJson(jsonData, new TypeToken<Map<String, String>>(){}.getType());
    }
}

