/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster.adaptors.carpet;

import java.lang.reflect.Field;
import net.thedustbuster.CarpetExtraExtrasServer;
import org.jetbrains.annotations.Nullable;

public final class FieldHelper {
    @Nullable
    public static Field getField(Class<?> c, String name) {
        return FieldHelper.readField(c, name);
    }

    @Nullable
    public static Field getField(Class<?> c, String n, boolean fa) {
        return FieldHelper.getField(c, n, fa, false);
    }

    @Nullable
    public static Field getField(Class<?> c, String name, boolean forceAccessible, boolean log) {
        Field f = FieldHelper.readField(c, name, log);
        if (f == null) {
            return null;
        }
        if (!forceAccessible) {
            return f;
        }
        f.setAccessible(true);
        return f;
    }

    @Nullable
    private static Field readField(Class<?> c, String n) {
        return FieldHelper.readField(c, n, false);
    }

    @Nullable
    private static Field readField(Class<?> c, String name, boolean log) {
        try {
            if (c == null) {
                CarpetExtraExtrasServer.LOGGER.error("Object cannot be null");
                return null;
            }
            return c.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            if (log) {
                CarpetExtraExtrasServer.LOGGER.error("Field '{}' does not exist in object: {}", (Object)name, c);
            }
            return null;
        }
    }
}

