/*
 * Decompiled with CFR 0.152.
 */
package net.thedustbuster.rules.bpcl;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.thedustbuster.adaptors.minecraft.worldgen.ChunkHelper;

public final class PearlManager {
    public static final class_3230<class_1923> ENDER_PEARL_TICKET = class_3230.method_14291((String)"ender_pearl", Comparator.comparingLong(class_1923::method_8324));
    private static final Map<UUID, EnderPearlData> enderPearlCache = new HashMap<UUID, EnderPearlData>();

    public static Map<UUID, EnderPearlData> getEnderPearlCache() {
        return Collections.unmodifiableMap(enderPearlCache);
    }

    public static void tick() {
        Iterator<Map.Entry<UUID, EnderPearlData>> it = enderPearlCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, EnderPearlData> entry = it.next();
            EnderPearlData pearl = entry.getValue();
            if (!pearl.getEntity().method_5805()) {
                pearl.dropAllChunks();
                it.remove();
                continue;
            }
            class_1937 class_19372 = pearl.getEntity().method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 serverLevel = (class_3218)class_19372;
            PearlManager.checkPearl(serverLevel, pearl);
        }
    }

    public static void checkPearl(class_3218 level, EnderPearlData pearl) {
        List<class_1923> toRemove = pearl.loadedChunks.stream().filter(c -> c != null && !c.equals((Object)pearl.getChunkPos()) && !c.equals((Object)pearl.getNextChunkPos())).toList();
        toRemove.forEach(pearl::removeLoadedChunk);
        if (!PearlManager.isEntityTickingChunk(level, pearl.getNextChunkPos())) {
            pearl.addLoadedChunk(pearl.getNextChunkPos());
        }
    }

    public static boolean isEntityTickingChunk(class_3218 level, class_1923 chunkPos) {
        return level.method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false) instanceof class_2818;
    }

    public static EnderPearlData updatePearl(class_1297 entity, class_243 position, class_243 velocity) {
        EnderPearlData pearl = enderPearlCache.computeIfAbsent(entity.method_5667(), id -> new EnderPearlData(entity, position, velocity));
        pearl.updatePositionAndVelocity(position, velocity);
        pearl.loadNextChunk();
        return pearl;
    }

    public static class EnderPearlData {
        private final class_1297 entity;
        private class_243 position;
        private class_243 velocity;
        private final Set<class_1923> loadedChunks = new HashSet<class_1923>();

        protected EnderPearlData(class_1297 entity, class_243 position, class_243 velocity) {
            this.entity = entity;
            this.position = position;
            this.velocity = velocity;
        }

        public class_1297 getEntity() {
            return this.entity;
        }

        public class_243 getPosition() {
            return this.position;
        }

        public class_243 getVelocity() {
            return this.velocity;
        }

        public class_2382 getIPosition() {
            return new class_2382(class_3532.method_15357((double)this.position.field_1352), class_3532.method_15357((double)this.position.field_1351), class_3532.method_15357((double)this.position.field_1350));
        }

        public class_2382 getIVelocity() {
            return new class_2382(class_3532.method_15357((double)this.velocity.field_1352), class_3532.method_15357((double)this.velocity.field_1351), class_3532.method_15357((double)this.velocity.field_1350));
        }

        protected void updatePositionAndVelocity(class_243 position, class_243 velocity) {
            this.position = position;
            this.velocity = velocity;
        }

        protected void loadNextChunk() {
            this.addLoadedChunk(this.getNextChunkPos());
        }

        protected void addLoadedChunk(class_1923 chunkPos) {
            if (this.loadedChunks.add(chunkPos)) {
                ChunkHelper.loadChunk(ENDER_PEARL_TICKET, chunkPos, 2, this.entity.method_37908());
            }
        }

        protected void removeLoadedChunk(class_1923 chunkPos) {
            if (this.loadedChunks.remove(chunkPos)) {
                ChunkHelper.unloadChunk(ENDER_PEARL_TICKET, chunkPos, 2, this.entity.method_37908());
            }
        }

        protected class_1923 getChunkPos() {
            return ChunkHelper.calculateChunkPos(this.position);
        }

        public class_1923 getNextChunkPos() {
            return ChunkHelper.calculateChunkPos(this.position.method_1019(this.velocity));
        }

        protected void dropAllChunks() {
            new HashSet<class_1923>(this.loadedChunks).forEach(this::removeLoadedChunk);
        }

        public String toString() {
            return "Entity: " + this.entity.method_5845() + "\nPosition: " + String.valueOf(this.getPosition()) + "\nVelocity: " + String.valueOf(this.getVelocity()) + "\nChunk Position: " + String.valueOf(this.getChunkPos());
        }
    }
}

