/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.optifine;

import java.util.List;
import java.util.Random;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;

public class RandomMethod
extends MathMethod {
    private final boolean hasSeed;

    public RandomMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        this.hasSeed = args.size() == 1 && !args.get(0).isBlank();
        Random rand = new Random();
        if (this.hasSeed) {
            MathComponent arg = RandomMethod.parseArg(args.get(0), calculationInstance);
            this.setSupplierAndOptimize(() -> this.nextValue(rand, arg.getResult()), arg);
        } else {
            this.setSupplierAndOptimize(() -> this.nextValue(rand));
        }
    }

    protected float nextValue(Random rand, float seed) {
        rand.setSeed((long)seed);
        return rand.nextFloat();
    }

    protected float nextValue(Random rand) {
        return rand.nextFloat();
    }

    @Override
    protected boolean canOptimizeForConstantArgs() {
        return this.hasSeed;
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount == 1 || argCount == 0;
    }
}

