/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.SinglePoolElementAccessor;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureConditionType;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.PieceEntry;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element.YungJigsawSinglePoolElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3781;
import net.minecraft.class_3790;

public class PieceInRangeCondition
extends StructureCondition {
    private static final class_2960 ALL = class_2960.method_60655((String)"yungsapi", (String)"all");
    public static final MapCodec<PieceInRangeCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_2960.field_25139.listOf().optionalFieldOf("pieces", new ArrayList()).forGetter(conditon -> conditon.matchPieces), (App)Codec.INT.optionalFieldOf("above_range", (Object)0).forGetter(conditon -> conditon.aboveRange), (App)Codec.INT.optionalFieldOf("horizontal_range", (Object)0).forGetter(conditon -> conditon.horizontalRange), (App)Codec.INT.optionalFieldOf("below_range", (Object)0).forGetter(conditon -> conditon.belowRange)).apply((Applicative)builder, PieceInRangeCondition::new));
    private final List<class_2960> matchPieces;
    private final Integer aboveRange;
    private final Integer horizontalRange;
    private final Integer belowRange;

    public PieceInRangeCondition(List<class_2960> pieces, int aboveRange, int horizontalRange, int belowRange) {
        this.matchPieces = pieces;
        this.aboveRange = aboveRange;
        this.horizontalRange = horizontalRange;
        this.belowRange = belowRange;
        if (this.matchPieces.isEmpty()) {
            this.matchPieces.add(ALL);
        }
    }

    @Override
    public StructureConditionType<?> type() {
        return StructureConditionType.PIECE_IN_RANGE;
    }

    @Override
    public boolean passes(StructureContext ctx) {
        class_3485 templateManager = ctx.structureTemplateManager();
        List<PieceEntry> pieces = ctx.pieces();
        PieceEntry pieceEntry = ctx.pieceEntry();
        if (templateManager == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'structureTemplateManager' for piece_in_range condition!");
        }
        if (pieces == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'pieces' for piece_in_range condition!");
        }
        if (pieceEntry == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'pieceEntry' for piece_in_horizontal_direction condition!");
        }
        if (templateManager == null || pieces == null || pieceEntry == null) {
            return false;
        }
        class_3790 piece = pieceEntry.getPiece();
        class_3341 searchBox = new class_3341(piece.method_14935().method_35415() - this.horizontalRange, piece.method_14935().method_35416() - this.belowRange, piece.method_14935().method_35417() - this.horizontalRange, piece.method_14935().method_35418() + this.horizontalRange, piece.method_14935().method_35419() + this.aboveRange, piece.method_14935().method_35420() + this.horizontalRange);
        for (PieceEntry otherPieceEntry : pieces) {
            class_3790 otherPiece = otherPieceEntry.getPiece();
            if (!(otherPiece.method_16644() instanceof class_3781) && !(otherPiece.method_16644() instanceof YungJigsawSinglePoolElement) || otherPiece.method_14935().equals((Object)piece.method_14935())) continue;
            class_3499 otherStructureTemplate = otherPiece.method_16644() instanceof class_3781 ? ((SinglePoolElementAccessor)otherPiece.method_16644()).callGetTemplate(templateManager) : ((YungJigsawSinglePoolElement)otherPiece.method_16644()).getTemplate(templateManager);
            for (class_2960 matchPieceId : this.matchPieces) {
                class_3499 structureTemplate = templateManager.method_15091(matchPieceId);
                if (otherStructureTemplate != structureTemplate && !matchPieceId.equals((Object)ALL) || !otherPiece.method_14935().method_14657(searchBox) || otherPiece.method_14935().method_14657(piece.method_14935())) continue;
                return true;
            }
        }
        return false;
    }
}

