/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.core.v1;

import fuzs.puzzleslib.api.client.core.v1.context.AdditionalModelsContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.BuiltinModelItemRendererContext;
import fuzs.puzzleslib.api.client.core.v1.context.ClientTooltipComponentsContext;
import fuzs.puzzleslib.api.client.core.v1.context.ColorProvidersContext;
import fuzs.puzzleslib.api.client.core.v1.context.CoreShadersContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.EntitySpectatorShaderContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemDecorationContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelPropertiesContext;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LivingEntityRenderLayersContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.core.v1.context.ParticleProvidersContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderBuffersContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderTypesContext;
import fuzs.puzzleslib.api.client.core.v1.context.SkullRenderersContext;
import fuzs.puzzleslib.api.core.v1.BaseModConstructor;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.context.AddReloadListenersContext;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.client.core.ClientFactories;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3611;
import org.apache.logging.log4j.util.Strings;

public interface ClientModConstructor
extends BaseModConstructor {
    public static void construct(String modId, Supplier<ClientModConstructor> modConstructor) {
        if (Strings.isBlank((String)modId)) {
            throw new IllegalArgumentException("mod id is empty");
        }
        ClientModConstructor instance = modConstructor.get();
        ModContext modContext = ModContext.get(modId);
        class_2960 identifier = ModContext.getPairingIdentifier(modId, instance);
        modContext.scheduleClientModConstruction(identifier, () -> {
            PuzzlesLib.LOGGER.info("Constructing client components for {}", (Object)identifier);
            Set<ContentRegistrationFlags> availableFlags = Set.of(instance.getContentRegistrationFlags());
            Set<ContentRegistrationFlags> flagsToHandle = modContext.getFlagsToHandle(availableFlags);
            ClientFactories.INSTANCE.constructClientMod(modId, instance, availableFlags, flagsToHandle);
        });
    }

    default public void onConstructMod() {
    }

    default public void onClientSetup() {
    }

    default public void onRegisterEntityRenderers(EntityRenderersContext context) {
    }

    default public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
    }

    default public void onRegisterClientTooltipComponents(ClientTooltipComponentsContext context) {
    }

    default public void onRegisterParticleProviders(ParticleProvidersContext context) {
    }

    default public void onRegisterMenuScreens(MenuScreensContext context) {
    }

    default public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
    }

    default public void onRegisterAdditionalModels(AdditionalModelsContext context) {
    }

    default public void onRegisterItemModelProperties(ItemModelPropertiesContext context) {
    }

    default public void onRegisterBuiltinModelItemRenderers(BuiltinModelItemRendererContext context) {
    }

    default public void onRegisterItemDecorations(ItemDecorationContext context) {
    }

    default public void onRegisterEntitySpectatorShaders(EntitySpectatorShaderContext context) {
    }

    default public void onRegisterSkullRenderers(SkullRenderersContext context) {
    }

    @Deprecated(forRemoval=true)
    default public void onRegisterResourcePackReloadListeners(AddReloadListenersContext context) {
    }

    default public void onRegisterLivingEntityRenderLayers(LivingEntityRenderLayersContext context) {
    }

    default public void onRegisterKeyMappings(KeyMappingsContext context) {
    }

    default public void onRegisterBlockRenderTypes(RenderTypesContext<class_2248> context) {
    }

    default public void onRegisterFluidRenderTypes(RenderTypesContext<class_3611> context) {
    }

    default public void onRegisterBlockColorProviders(ColorProvidersContext<class_2248, class_322> context) {
    }

    default public void onRegisterItemColorProviders(ColorProvidersContext<class_1792, class_326> context) {
    }

    default public void onAddResourcePackFinders(PackRepositorySourcesContext context) {
    }

    default public void onRegisterCoreShaders(CoreShadersContext context) {
    }

    default public void onRegisterRenderBuffers(RenderBuffersContext context) {
    }
}

