/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.base.CaseFormat;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5475;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7877;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.class_8107;
import net.minecraft.class_8110;
import net.minecraft.class_8931;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRegistriesDatapackGenerator<T>
extends class_5475 {
    private final class_5321<? extends class_2378<T>> registryKey;
    private class_7891<T> bootstrapContext;

    public AbstractRegistriesDatapackGenerator(class_5321<? extends class_2378<T>> registryKey, DataProviderContext context) {
        this(registryKey, context.getPackOutput(), context.getRegistries());
    }

    public AbstractRegistriesDatapackGenerator(class_5321<? extends class_2378<T>> registryKey, class_7784 output, CompletableFuture<class_7225.class_7874> registries) {
        super(output, registries);
        this.registryKey = registryKey;
    }

    protected final void add(class_5321<T> resourceKey, T value) {
        this.bootstrapContext.method_46838(resourceKey, value);
    }

    protected abstract void addBootstrap(class_7891<T> var1);

    public CompletableFuture<?> method_10319(class_7403 output) {
        CompletableFuture registries = this.field_40952;
        return ((CompletableFuture)CompletableFuture.runAsync(() -> {
            this.field_40952 = class_8931.method_54840((CompletableFuture)registries, (class_7877)new class_7877().method_46777(this.registryKey, context -> {
                this.bootstrapContext = context;
                this.addBootstrap(context);
            })).thenApply(class_7877.class_8993::comp_2114);
        }).thenCompose($ -> super.method_10319(output))).thenRun(() -> {
            this.field_40952 = registries;
        });
    }

    public String method_10321() {
        return AbstractRegistriesDatapackGenerator.getNameFromRegistryPath(this.registryKey.method_29177().method_12832()) + " Registry";
    }

    static String getNameFromRegistryPath(String registryPath) {
        String registryName = registryPath.replaceAll("\\W", "_");
        registryName = (String)CaseFormat.LOWER_UNDERSCORE.converterTo(CaseFormat.UPPER_CAMEL).convert((Object)registryName);
        return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)registryName), (char)' ');
    }

    public static abstract class TrimMaterials
    extends AbstractRegistriesDatapackGenerator<class_8054> {
        public TrimMaterials(DataProviderContext context) {
            super(class_7924.field_42083, context);
        }

        public TrimMaterials(class_7784 output, CompletableFuture<class_7225.class_7874> registries) {
            super(class_7924.field_42083, output, registries);
        }

        protected void add(class_5321<class_8054> resourceKey, class_1792 ingredient, int descriptionColor, float itemModelIndex) {
            this.add(resourceKey, ingredient, descriptionColor, itemModelIndex, Collections.emptyMap());
        }

        protected void add(class_5321<class_8054> resourceKey, class_1792 ingredient, int descriptionColor, float itemModelIndex, Map<class_6880<class_1741>, String> overrideArmorMaterials) {
            class_5250 description = class_2561.method_43471((String)class_156.method_646((String)"trim_material", (class_2960)resourceKey.method_29177())).method_27696(class_2583.field_24360.method_36139(descriptionColor));
            class_8054 trimMaterial = class_8054.method_48438((String)resourceKey.method_29177().method_12832(), (class_1792)ingredient, (float)itemModelIndex, (class_2561)description, overrideArmorMaterials);
            this.add(resourceKey, trimMaterial);
        }
    }

    public static abstract class DamageTypes
    extends AbstractRegistriesDatapackGenerator<class_8110> {
        public DamageTypes(DataProviderContext context) {
            super(class_7924.field_42534, context);
        }

        public DamageTypes(class_7784 output, CompletableFuture<class_7225.class_7874> registries) {
            super(class_7924.field_42534, output, registries);
        }

        protected void add(class_5321<class_8110> resourceKey) {
            this.add(resourceKey, new class_8110(resourceKey.method_29177().method_12832(), 0.1f));
        }

        @Override
        protected void add(class_5321<class_8110> resourceKey, class_8107 damageEffects) {
            this.add(resourceKey, new class_8110(resourceKey.method_29177().method_12832(), 0.1f, damageEffects));
        }
    }

    public static abstract class Enchantments
    extends AbstractRegistriesDatapackGenerator<class_1887> {
        public Enchantments(DataProviderContext context) {
            super(class_7924.field_41265, context);
        }

        public Enchantments(class_7784 output, CompletableFuture<class_7225.class_7874> registries) {
            super(class_7924.field_41265, output, registries);
        }

        @Override
        protected void add(class_5321<class_1887> resourceKey, class_1887.class_9700 builder) {
            this.add(resourceKey, builder.method_60060(resourceKey.method_29177()));
        }
    }
}

