/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v3;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.core.v1.utility.Buildable;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.api.network.v3.ClientboundMessage;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.api.network.v3.ServerboundMessage;
import fuzs.puzzleslib.api.network.v3.codec.StreamCodecRegistry;
import fuzs.puzzleslib.impl.core.ModContext;
import fuzs.puzzleslib.impl.network.NetworkHandlerRegistry;
import fuzs.puzzleslib.impl.network.codec.StreamCodecRegistryImpl;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import net.minecraft.class_8705;
import net.minecraft.class_8706;
import net.minecraft.class_9139;
import net.minecraft.class_9141;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public interface NetworkHandler {
    public static Builder builder(String modId) {
        return NetworkHandler.builder(ResourceLocationHelper.fromNamespaceAndPath(modId, "play"));
    }

    public static Builder builder(class_2960 channelName) {
        return ModContext.get(channelName.method_12836()).getNetworkHandler(channelName);
    }

    public <T> class_2596<class_8705> toClientboundPacket(ClientboundMessage<T> var1);

    public <T> class_2596<class_8706> toServerboundPacket(ServerboundMessage<T> var1);

    default public <T> void sendMessage(PlayerSet playerSet, ClientboundMessage<T> message) {
        playerSet.notify(this.toClientboundPacket(message));
    }

    default public <T> void sendMessage(ServerboundMessage<T> message) {
        class_634 clientPacketListener = Proxy.INSTANCE.getClientPacketListener();
        Objects.requireNonNull(clientPacketListener, "client packet listener is null");
        clientPacketListener.method_52787(this.toServerboundPacket(message));
    }

    default public <T> void sendToServer(ServerboundMessage<T> message) {
        this.sendMessage(message);
    }

    default public <T> void sendTo(class_3222 player, ClientboundMessage<T> message) {
        Objects.requireNonNull(player, "player is null");
        player.field_13987.method_14364(this.toClientboundPacket(message));
    }

    default public <T> void sendToAll(MinecraftServer server, ClientboundMessage<T> message) {
        this.sendToAll(server, null, message);
    }

    default public <T> void sendToAll(MinecraftServer server, @Nullable class_3222 exclude, ClientboundMessage<T> message) {
        Objects.requireNonNull(server, "server is null");
        this.sendToAll(server.method_3760().method_14571(), exclude, message);
    }

    default public <T> void sendToAll(Collection<class_3222> playerList, @Nullable class_3222 exclude, ClientboundMessage<T> message) {
        Objects.requireNonNull(playerList, "player list is null");
        for (class_3222 player : playerList) {
            if (player == exclude) continue;
            this.sendTo(player, message);
        }
    }

    default public <T> void sendToAll(class_3218 level, ClientboundMessage<T> message) {
        Objects.requireNonNull(level, "level is null");
        for (class_3222 player : level.method_18456()) {
            this.sendTo(player, message);
        }
    }

    default public <T> void sendToAllNear(class_2382 pos, class_3218 level, ClientboundMessage<T> message) {
        Objects.requireNonNull(pos, "pos is null");
        this.sendToAllNear(pos.method_10263(), pos.method_10264(), pos.method_10260(), level, message);
    }

    default public <T> void sendToAllNear(double posX, double posY, double posZ, class_3218 level, ClientboundMessage<T> message) {
        this.sendToAllNear(null, posX, posY, posZ, 64.0, level, message);
    }

    default public <T> void sendToAllNear(@Nullable class_3222 exclude, double posX, double posY, double posZ, double distance, class_3218 level, ClientboundMessage<T> message) {
        Objects.requireNonNull(level, "level is null");
        level.method_8503().method_3760().method_14605((class_1657)exclude, posX, posY, posZ, distance, level.method_27983(), this.toClientboundPacket(message));
    }

    default public <T> void sendToAllTracking(class_2586 blockEntity, ClientboundMessage<T> message) {
        Objects.requireNonNull(blockEntity, "block entity is null");
        class_1937 level = blockEntity.method_10997();
        Objects.requireNonNull(level, "block entity level is null");
        Preconditions.checkState((!level.field_9236 ? 1 : 0) != 0, (Object)"block entity level is client level");
        this.sendToAllNear((class_2382)blockEntity.method_11016(), (class_3218)level, message);
    }

    default public <T> void sendToAllTracking(class_2818 chunk, ClientboundMessage<T> message) {
        Objects.requireNonNull(chunk, "chunk is null");
        Preconditions.checkState((!chunk.method_12200().field_9236 ? 1 : 0) != 0, (Object)"chunk level is client level");
        this.sendToAllTracking((class_3218)chunk.method_12200(), chunk.method_12004(), message);
    }

    default public <T> void sendToAllTracking(class_3218 level, class_1923 chunkPos, ClientboundMessage<T> message) {
        Objects.requireNonNull(level, "level is null");
        Objects.requireNonNull(chunkPos, "chunk pos is null");
        List players = level.method_14178().field_17254.method_17210(chunkPos, false);
        this.sendToAll(players, null, message);
    }

    default public <T> void sendToAllTracking(class_1297 entity, ClientboundMessage<T> message, boolean includeSelf) {
        Objects.requireNonNull(entity, "entity is null");
        Preconditions.checkState((!entity.method_5770().field_9236 ? 1 : 0) != 0, (Object)"entity level is client level");
        class_3215 chunkSource = ((class_3218)entity.method_5770()).method_14178();
        if (includeSelf) {
            chunkSource.method_18751(entity, this.toClientboundPacket(message));
        } else {
            chunkSource.method_18754(entity, this.toClientboundPacket(message));
        }
    }

    public static interface Builder
    extends NetworkHandlerRegistry,
    StreamCodecRegistry<Builder>,
    Buildable {
        @Override
        default public <B extends ByteBuf, V> Builder registerSerializer(Class<V> type, class_9139<? super B, V> streamCodec) {
            StreamCodecRegistryImpl.INSTANCE.registerSerializer(type, streamCodec);
            return this;
        }

        @Override
        default public <B extends ByteBuf, V> Builder registerContainerProvider(Class<V> type, Function<Type[], class_9139<? super B, ? extends V>> factory) {
            StreamCodecRegistryImpl.INSTANCE.registerContainerProvider(type, factory);
            return this;
        }

        public <T extends Record> Builder registerClientbound(Class<T> var1);

        public <T extends Record> Builder registerServerbound(Class<T> var1);

        default public <T extends MessageV2<T>> Builder registerLegacyClientbound(Class<T> clazz, Supplier<T> factory) {
            return this.registerLegacyClientbound(clazz, friendlyByteBuf -> {
                MessageV2 message = (MessageV2)factory.get();
                message.read((class_2540)friendlyByteBuf);
                return message;
            });
        }

        default public <T extends MessageV2<T>> Builder registerLegacyServerbound(Class<T> clazz, Supplier<T> factory) {
            return this.registerLegacyServerbound(clazz, friendlyByteBuf -> {
                MessageV2 message = (MessageV2)factory.get();
                message.read((class_2540)friendlyByteBuf);
                return message;
            });
        }

        public <T extends MessageV2<T>> Builder registerLegacyClientbound(Class<T> var1, class_9141<class_2540, T> var2);

        public <T extends MessageV2<T>> Builder registerLegacyServerbound(Class<T> var1, class_9141<class_2540, T> var2);

        public Builder optional();
    }
}

