/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.core;

import com.google.common.base.Suppliers;
import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.core.v1.ModLoader;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.ObjectShareAccess;
import fuzs.puzzleslib.fabric.impl.core.FabricModContainer;
import fuzs.puzzleslib.fabric.impl.core.FabricObjectShareAccess;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;

public final class FabricEnvironment
implements ModLoaderEnvironment {
    private final Supplier<Map<String, ModContainer>> modList = Suppliers.memoize(() -> ModContainer.toModList(this::getFabricModContainers));

    private Stream<? extends ModContainer> getFabricModContainers() {
        Map allMods = FabricLoader.getInstance().getAllMods().stream().map(FabricModContainer::new).collect(Collectors.toMap(FabricModContainer::getFabricModContainer, Function.identity(), (o1, o2) -> {
            o2.setParent((FabricModContainer)o1);
            return o1;
        }));
        for (FabricModContainer modContainer : allMods.values()) {
            modContainer.getFabricModContainer().getContainedMods().stream().map(allMods::get).forEach(childModContainer -> childModContainer.setParent(modContainer));
        }
        return allMods.values().stream();
    }

    @Override
    public ModLoader getModLoader() {
        return FabricLoader.getInstance().isModLoaded("quilt_loader") ? ModLoader.QUILT : ModLoader.FABRIC;
    }

    @Override
    public boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public boolean isServer() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    @Override
    public Path getGameDirectory() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public Path getModsDirectory() {
        return FabricLoader.getInstance().getGameDir().resolve("mods");
    }

    @Override
    public Path getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public String getCurrentMappingsNamespace() {
        return FabricLoader.getInstance().getMappingResolver().getCurrentRuntimeNamespace();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public boolean isDataGeneration() {
        return System.getProperty("fabric-api.datagen") != null;
    }

    @Override
    public Map<String, ModContainer> getModList() {
        return this.modList.get();
    }

    @Override
    public ObjectShareAccess getObjectShareAccess() {
        return FabricObjectShareAccess.INSTANCE;
    }
}

