/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.core;

import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.fabric.impl.core.context.AddReloadListenersContextFabricImpl;
import fuzs.puzzleslib.fabric.impl.core.context.BiomeModificationsContextFabricImpl;
import fuzs.puzzleslib.fabric.impl.core.context.BlockInteractionsContextFabricImpl;
import fuzs.puzzleslib.fabric.impl.core.context.CreativeModeTabContextFabricImpl;
import fuzs.puzzleslib.fabric.impl.core.context.CreativeTabContentsContextFabricImpl;
import fuzs.puzzleslib.fabric.impl.core.context.DataPackSourcesContextFabricImpl;
import fuzs.puzzleslib.fabric.impl.core.context.EntityAttributesCreateContextFabricImpl;
import fuzs.puzzleslib.fabric.impl.core.context.EntityAttributesModifyContextFabricImpl;
import fuzs.puzzleslib.fabric.impl.core.context.FlammableBlocksContextFabricImpl;
import fuzs.puzzleslib.fabric.impl.core.context.FuelBurnTimesContextFabricImpl;
import fuzs.puzzleslib.fabric.impl.core.context.SpawnPlacementsContextFabricImpl;
import fuzs.puzzleslib.impl.item.CopyComponentsRecipe;
import java.util.Set;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7923;

public final class FabricModConstructor {
    private FabricModConstructor() {
    }

    public static void construct(ModConstructor constructor, String modId, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        FabricModConstructor.registerContent(modId, flagsToHandle);
        FabricModConstructor.registerHandlers(constructor, modId, availableFlags);
    }

    private static void registerContent(String modId, Set<ContentRegistrationFlags> flagsToHandle) {
        if (flagsToHandle.contains((Object)ContentRegistrationFlags.COPY_RECIPES)) {
            CopyComponentsRecipe.registerSerializers((s, supplier) -> class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)ResourceLocationHelper.fromNamespaceAndPath(modId, s), (Object)((class_1865)supplier.get())));
        }
    }

    private static void registerHandlers(ModConstructor constructor, String modId, Set<ContentRegistrationFlags> availableFlags) {
        constructor.onConstructMod();
        constructor.onRegisterCreativeModeTabs(new CreativeModeTabContextFabricImpl());
        constructor.onBuildCreativeModeTabContents(new CreativeTabContentsContextFabricImpl());
        constructor.onCommonSetup();
        constructor.onEntityAttributeCreation(new EntityAttributesCreateContextFabricImpl());
        constructor.onEntityAttributeModification(new EntityAttributesModifyContextFabricImpl());
        constructor.onRegisterSpawnPlacements(new SpawnPlacementsContextFabricImpl());
        constructor.onRegisterFuelBurnTimes(new FuelBurnTimesContextFabricImpl());
        constructor.onRegisterFlammableBlocks(new FlammableBlocksContextFabricImpl());
        constructor.onRegisterBlockInteractions(new BlockInteractionsContextFabricImpl());
        constructor.onRegisterBiomeModifications(new BiomeModificationsContextFabricImpl(modId, availableFlags));
        constructor.onAddDataPackFinders(new DataPackSourcesContextFabricImpl());
        constructor.onRegisterDataPackReloadListeners(new AddReloadListenersContextFabricImpl(class_3264.field_14190, modId));
    }
}

