/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.gui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.api.client.gui.v2.components.tooltip.ClientComponentSplitter;
import fuzs.puzzleslib.api.client.gui.v2.components.tooltip.TooltipBuilder;
import fuzs.puzzleslib.api.client.gui.v2.components.tooltip.TooltipComponentImpl;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_339;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8000;
import org.jetbrains.annotations.Nullable;

public final class TooltipBuilderImpl
implements TooltipBuilder {
    private final List<class_5348> lines = new ArrayList<class_5348>();
    @Nullable
    private Duration delay;
    private int maxLineWidth;
    @Nullable
    private Function<class_339, class_8000> tooltipPositionerFactory;
    @Nullable
    private Supplier<List<? extends class_5348>> linesSupplier;

    @Override
    public TooltipBuilder addLines(class_5348 ... lines) {
        Objects.requireNonNull(lines, "lines is null");
        return this.addLines(Arrays.asList(lines));
    }

    @Override
    public TooltipBuilder addLines(List<? extends class_5348> lines) {
        Objects.requireNonNull(lines, "lines is null");
        this.lines.addAll(lines);
        return this;
    }

    @Override
    public TooltipBuilder setLines(Supplier<List<? extends class_5348>> supplier) {
        Objects.requireNonNull(supplier, "lines supplier is null");
        this.linesSupplier = supplier;
        return this;
    }

    @Override
    public TooltipBuilder setDelay(Duration delay) {
        Objects.requireNonNull(delay, "delay is null");
        this.delay = delay;
        return this;
    }

    @Override
    public TooltipBuilder setTooltipPositionerFactory(Function<class_339, class_8000> factory) {
        Objects.requireNonNull(factory, "tooltip positioner factory is null");
        this.tooltipPositionerFactory = factory;
        return this;
    }

    @Override
    public TooltipBuilder splitLines() {
        return this.splitLines(175);
    }

    @Override
    public TooltipBuilder splitLines(int maxWidth) {
        this.maxLineWidth = maxWidth;
        return this;
    }

    @Override
    public void build(class_339 abstractWidget) {
        Preconditions.checkState((!this.lines.isEmpty() || this.linesSupplier != null ? 1 : 0) != 0, (Object)"lines is empty");
        new TooltipComponentImpl(abstractWidget, (List)ImmutableList.copyOf(this.lines)){
            {
                if (TooltipBuilderImpl.this.delay != null) {
                    this.setTooltipDelay(TooltipBuilderImpl.this.delay);
                }
            }

            @Override
            public List<class_5481> processTooltipLines(List<? extends class_5348> tooltipLines) {
                if (TooltipBuilderImpl.this.maxLineWidth != 0) {
                    return ClientComponentSplitter.splitTooltipLines(TooltipBuilderImpl.this.maxLineWidth, tooltipLines).toList();
                }
                return ClientComponentSplitter.processTooltipLines(tooltipLines).toList();
            }

            @Override
            public List<? extends class_5348> getLinesForNextRenderPass() {
                if (TooltipBuilderImpl.this.linesSupplier != null) {
                    return TooltipBuilderImpl.this.linesSupplier.get();
                }
                return Collections.emptyList();
            }

            @Override
            public class_8000 createTooltipPositioner(class_339 abstractWidget) {
                if (TooltipBuilderImpl.this.tooltipPositionerFactory != null) {
                    return TooltipBuilderImpl.this.tooltipPositionerFactory.apply(abstractWidget);
                }
                return super.createTooltipPositioner(abstractWidget);
            }
        };
    }
}

