/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.config;

import fuzs.puzzleslib.impl.PuzzlesLibMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import net.minecraft.class_1078;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_3302;
import net.minecraft.class_4013;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class ConfigTranslationsManager {
    public static final Map<String, String> TRANSLATIONS = new HashMap<String, String>();

    private ConfigTranslationsManager() {
    }

    public static void onAddResourcePackReloadListeners(BiConsumer<class_2960, class_3302> consumer) {
        consumer.accept(PuzzlesLibMod.id("config_translations"), (class_3302)((class_4013)resourceManager -> {
            class_2477 patt0$temp = class_2477.method_10517();
            if (patt0$temp instanceof class_1078) {
                class_1078 clientLanguage = (class_1078)patt0$temp;
                if (!(clientLanguage.field_5330 instanceof HashMap)) {
                    clientLanguage.field_5330 = new HashMap(clientLanguage.field_5330);
                }
                TRANSLATIONS.forEach(clientLanguage.field_5330::putIfAbsent);
            }
        }));
    }

    public static void addConfigTitle(String modId) {
        TRANSLATIONS.put(modId + ".configuration.title", "%s Configuration");
    }

    public static void addConfig(String modId, String fileName, String configType) {
        configType = ConfigTranslationsManager.getCapitalizedString(configType);
        fileName = fileName.replaceAll("[^a-zA-Z0-9]+", ".").replaceFirst("^\\.", "").replaceFirst("\\.$", "").toLowerCase();
        TRANSLATIONS.put(modId + ".configuration.section." + fileName, configType + " Settings");
        TRANSLATIONS.put(modId + ".configuration.section." + fileName + ".title", "%s " + configType + " Configuration");
    }

    public static void addConfigValue(String modId, String valueName) {
        Objects.requireNonNull(valueName, "value name is null");
        ConfigTranslationsManager.addConfigValue(modId, Collections.singletonList(valueName));
    }

    public static void addConfigValue(String modId, List<String> valuePath) {
        TRANSLATIONS.put(modId + ".configuration." + valuePath.getLast(), ConfigTranslationsManager.getCapitalizedString(valuePath.getLast()));
    }

    public static void addConfigValueComment(String modId, String valueName, @Nullable String comment) {
        Objects.requireNonNull(valueName, "value name is null");
        ConfigTranslationsManager.addConfigValueComment(modId, Collections.singletonList(valueName), comment != null ? Arrays.asList(comment.split("\\r?\\n")) : Collections.emptyList());
    }

    public static void addConfigValueComment(String modId, List<String> valuePath, List<String> comments) {
        String value = String.join((CharSequence)System.lineSeparator(), ConfigTranslationsManager.getStylizedStrings(comments));
        if (!value.isEmpty()) {
            TRANSLATIONS.put(modId + ".configuration." + valuePath.getLast() + ".tooltip", value);
        }
    }

    static String getCapitalizedString(String s) {
        String[] strings = s.toLowerCase().split("[\\s_]+");
        StringJoiner joiner = new StringJoiner(" ");
        for (String string : strings) {
            joiner.add(StringUtils.capitalize((String)string));
        }
        return joiner.toString();
    }

    static List<String> getStylizedStrings(List<String> strings) {
        strings = new ArrayList<String>(strings);
        for (int i = 0; i < strings.size(); ++i) {
            class_124 chatFormatting = i % 2 == 0 ? class_124.field_1054 : class_124.field_1065;
            strings.set(i, String.valueOf(chatFormatting) + strings.get(i) + String.valueOf(class_124.field_1070));
        }
        return strings;
    }
}

