/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1293;
import net.minecraft.class_1761;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class CreativeModeTabConfiguratorImpl
implements CreativeModeTabConfigurator {
    private static final class_1792[] POTION_ITEMS = new class_1792[]{class_1802.field_8574, class_1802.field_8436, class_1802.field_8150, class_1802.field_8087};
    private final class_2960 identifier;
    @Nullable
    private Supplier<class_1799> icon;
    @Nullable
    private Supplier<class_1799[]> icons;
    private class_1761.class_7914 displayItemsGenerator = (itemDisplayParameters, output) -> {};
    private boolean hasSearchBar;
    private boolean appendEnchantmentsAndPotions;

    public CreativeModeTabConfiguratorImpl(class_2960 identifier) {
        this.identifier = identifier;
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public Supplier<class_1799[]> getIcons() {
        return this.icons;
    }

    public boolean isHasSearchBar() {
        return this.hasSearchBar;
    }

    @Override
    public CreativeModeTabConfigurator icon(Supplier<class_1799> icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator icons(Supplier<class_1799[]> icons) {
        this.icons = icons;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator displayItems(class_1761.class_7914 displayItemsGenerator) {
        this.displayItemsGenerator = displayItemsGenerator;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator withSearchBar() {
        this.hasSearchBar = true;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator appendEnchantmentsAndPotions() {
        this.appendEnchantmentsAndPotions = true;
        return this;
    }

    public void configure(class_1761.class_7913 builder) {
        String translationKey = "itemGroup.%s.%s".formatted(this.identifier.method_12836(), this.identifier.method_12832());
        builder.method_47321((class_2561)class_2561.method_43471((String)translationKey));
        if (this.icon != null) {
            builder.method_47320(this.icon);
        } else {
            Objects.requireNonNull(this.icons, "both icon suppliers are null");
            if (ModLoaderEnvironment.INSTANCE.getModLoader().isFabricLike()) {
                builder.method_47320(() -> {
                    class_1799[] icons = this.icons.get();
                    Preconditions.checkState((icons.length > 0 ? 1 : 0) != 0, (Object)"icons is empty");
                    return icons[0];
                });
            }
        }
        if (this.appendEnchantmentsAndPotions) {
            builder.method_47317((itemDisplayParameters, output) -> {
                this.displayItemsGenerator.accept(itemDisplayParameters, output);
                CreativeModeTabConfiguratorImpl.appendAllEnchantments(this.identifier.method_12836(), itemDisplayParameters.comp_1253(), arg_0 -> ((class_1761.class_7704)output).method_45420(arg_0));
                CreativeModeTabConfiguratorImpl.appendAllPotions(this.identifier.method_12836(), itemDisplayParameters.comp_1253(), arg_0 -> ((class_1761.class_7704)output).method_45420(arg_0));
            });
        } else {
            builder.method_47317(this.displayItemsGenerator);
        }
    }

    private static void appendAllEnchantments(String namespace, class_7225.class_7874 holders, Consumer<class_1799> itemStacks) {
        Comparator<class_6880.class_6883> comparator = Comparator.comparing(entry -> entry.method_40237().method_29177().method_12832());
        holders.method_46759(class_7924.field_41265).stream().flatMap(class_7225::method_42017).filter(entry -> entry.method_40237().method_29177().method_12836().equals(namespace)).sorted(comparator).forEach(holder -> itemStacks.accept(class_1772.method_7808((class_1889)new class_1889((class_6880)holder, ((class_1887)holder.comp_349()).method_8183()))));
    }

    private static void appendAllPotions(String namespace, class_7225.class_7874 holders, Consumer<class_1799> itemStacks) {
        List<class_6880.class_6883> potions = holders.method_46759(class_7924.field_41215).stream().flatMap(class_7225::method_42017).filter(entry -> entry.method_40237().method_29177().method_12836().equals(namespace)).filter(holder -> !((class_1842)holder.comp_349()).method_8049().isEmpty()).sorted(Comparator.comparing(holder -> (class_1293)((class_1842)holder.comp_349()).method_8049().get(0))).toList();
        for (class_1792 item : POTION_ITEMS) {
            for (class_6880.class_6883 potion : potions) {
                itemStacks.accept(class_1844.method_57400((class_1792)item, (class_6880)potion));
            }
        }
    }
}

