/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.network;

import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.api.network.v3.MessageV3;
import fuzs.puzzleslib.api.network.v3.NetworkHandler;
import fuzs.puzzleslib.impl.network.CustomPacketPayloadAdapterImpl;
import fuzs.puzzleslib.impl.network.codec.CustomPacketPayloadAdapter;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9141;
import org.jetbrains.annotations.Nullable;

public abstract class NetworkHandlerRegistryImpl
implements NetworkHandler.Builder {
    private final Map<Class<?>, class_8710.class_9154<CustomPacketPayloadAdapter<?>>> messageNames = new IdentityHashMap();
    private final Map<Class<?>, class_9141<class_2540, ?>> clientboundMessages = new LinkedHashMap();
    private final Map<Class<?>, class_9141<class_2540, ?>> serverboundMessages = new LinkedHashMap();
    protected final AtomicInteger discriminator = new AtomicInteger();
    protected final class_2960 channelName;
    protected boolean optional;

    protected NetworkHandlerRegistryImpl(class_2960 channelName) {
        this.channelName = channelName;
    }

    @Override
    public <T extends Record> NetworkHandler.Builder registerClientbound(Class<T> clazz) {
        this.registerMessage(this.clientboundMessages, clazz, null);
        return this;
    }

    @Override
    public <T extends Record> NetworkHandler.Builder registerServerbound(Class<T> clazz) {
        this.registerMessage(this.serverboundMessages, clazz, null);
        return this;
    }

    @Override
    public <T extends MessageV2<T>> NetworkHandler.Builder registerLegacyClientbound(Class<T> clazz, class_9141<class_2540, T> factory) {
        this.registerMessage(this.clientboundMessages, clazz, factory);
        return this;
    }

    @Override
    public <T extends MessageV2<T>> NetworkHandler.Builder registerLegacyServerbound(Class<T> clazz, class_9141<class_2540, T> factory) {
        this.registerMessage(this.serverboundMessages, clazz, factory);
        return this;
    }

    private void registerMessage(Map<Class<?>, class_9141<class_2540, ?>> messages, Class<?> clazz, @Nullable class_9141<class_2540, ?> factory) {
        if (messages.containsKey(clazz)) {
            throw new IllegalStateException("Duplicate message of type " + String.valueOf(clazz));
        }
        messages.put(clazz, factory);
    }

    @Override
    public NetworkHandler.Builder optional() {
        this.optional = true;
        return this;
    }

    @Override
    public void build() {
        for (Map.Entry<Class<?>, class_9141<class_2540, ?>> entry : this.clientboundMessages.entrySet()) {
            if (entry.getValue() != null) {
                this.registerLegacyClientbound$Internal(entry.getKey(), entry.getValue());
                continue;
            }
            this.registerClientbound$Internal(entry.getKey());
        }
        for (Map.Entry<Class<?>, class_9141<class_2540, ?>> entry : this.serverboundMessages.entrySet()) {
            if (entry.getValue() != null) {
                this.registerLegacyServerbound$Internal(entry.getKey(), entry.getValue());
                continue;
            }
            this.registerServerbound$Internal(entry.getKey());
        }
        this.clientboundMessages.clear();
        this.serverboundMessages.clear();
    }

    protected BiConsumer<Throwable, Consumer<class_2561>> disconnectExceptionally(Class<?> clazz) {
        return (throwable, consumer) -> {
            String modName = ModContainer.getDisplayName(this.channelName.method_12836());
            consumer.accept(class_2561.method_43470((String)"Receiving %s from %s failed: %s".formatted(clazz.getSimpleName(), modName, throwable.getMessage())));
        };
    }

    protected Consumer<Consumer<class_2561>> disconnectWrongSide(Class<?> clazz) {
        return consumer -> {
            String modName = ModContainer.getDisplayName(this.channelName.method_12836());
            consumer.accept(class_2561.method_43470((String)"Receiving %s from %s on wrong side!".formatted(clazz.getSimpleName(), modName)));
        };
    }

    protected <T> class_8710.class_9154<CustomPacketPayloadAdapter<T>> registerMessageType(Class<T> clazz) {
        class_2960 resourceLocation = this.channelName.method_45134(path -> path + "/" + this.discriminator.getAndIncrement());
        class_8710.class_9154 type = new class_8710.class_9154(resourceLocation);
        this.messageNames.put(clazz, type);
        return type;
    }

    protected <T1 extends MessageV3<T2, ?>, T2, L extends class_2547> class_2596<L> toPacket(Function<class_8710, class_2596<L>> packetFactory, T1 message) {
        Class<?> clazz = message.unwrap().getClass();
        class_8710.class_9154<CustomPacketPayloadAdapter<?>> type = this.messageNames.get(clazz);
        Objects.requireNonNull(type, "Unknown message of type " + String.valueOf(clazz));
        return packetFactory.apply(new CustomPacketPayloadAdapterImpl(type, message.unwrap()));
    }

    protected abstract <T extends Record> void registerClientbound$Internal(Class<?> var1);

    protected abstract <T extends Record> void registerServerbound$Internal(Class<?> var1);

    protected abstract <T extends MessageV2<T>> void registerLegacyClientbound$Internal(Class<?> var1, class_9141<class_2540, ?> var2);

    protected abstract <T extends MessageV2<T>> void registerLegacyServerbound$Internal(Class<?> var1, class_9141<class_2540, ?> var2);
}

