/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_7225;
import net.minecraft.class_757;
import net.minecraft.class_777;
import net.minecraft.class_9209;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class RenderUtils {
    public static final class_2960 TEXTURE_MAP_BACKGROUND = class_2960.method_60656((String)"textures/map/map_background.png");
    public static final class_2960 TEXTURE_MAP_BACKGROUND_CHECKERBOARD = class_2960.method_60656((String)"textures/map/map_background_checkerboard.png");
    private static final class_6575 RAND = new class_6575(0L);

    public static void setupBlend() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
    }

    public static void setupBlendSimple() {
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }

    public static void bindTexture(class_2960 texture) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    public static void forceDraw(class_332 drawContext) {
        drawContext.method_51452();
    }

    public static void color(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void disableDiffuseLighting() {
        class_308.method_24210();
    }

    public static void enableDiffuseLightingForLevel() {
        class_308.method_1452();
    }

    public static void enableDiffuseLightingGui3D() {
        class_308.method_24211();
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder) {
        RenderUtils.drawOutlinedBox(x, y, width, height, colorBg, colorBorder, 0.0f);
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, width, height, colorBg, zLevel);
        RenderUtils.drawOutline(x - 1, y - 1, width + 2, height + 2, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - 1, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y, width - 2, 1, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y + height - 1, width - 2, 1, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, borderWidth, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - borderWidth, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        RenderUtils.drawTexturedRect(x, y, u, v, width, height, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color, float zLevel) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.applyModelViewMatrix();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderUtils.setupBlend();
        buffer.method_22912((float)x, (float)y, zLevel).method_22915(r, g, b, a);
        buffer.method_22912((float)x, (float)(y + height), zLevel).method_22915(r, g, b, a);
        buffer.method_22912((float)(x + width), (float)(y + height), zLevel).method_22915(r, g, b, a);
        buffer.method_22912((float)(x + width), (float)y, zLevel).method_22915(r, g, b, a);
        try {
            class_9801 builtBuffer = buffer.method_60800();
            class_286.method_43433((class_9801)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void drawScreenBlur(class_310 mc) {
        mc.field_1773.method_57796((float)mc.field_1690.method_57703());
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float pixelWidth = 0.00390625f;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.applyModelViewMatrix();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        RenderUtils.setupBlend();
        buffer.method_22912((float)x, (float)(y + height), zLevel).method_22913((float)u * pixelWidth, (float)(v + height) * pixelWidth);
        buffer.method_22912((float)(x + width), (float)(y + height), zLevel).method_22913((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth);
        buffer.method_22912((float)(x + width), (float)y, zLevel).method_22913((float)(u + width) * pixelWidth, (float)v * pixelWidth);
        buffer.method_22912((float)x, (float)y, zLevel).method_22913((float)u * pixelWidth, (float)v * pixelWidth);
        try {
            class_9801 builtBuffer = buffer.method_60800();
            class_286.method_43433((class_9801)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, class_287 buffer) {
        RenderUtils.drawTexturedRectBatched(x, y, u, v, width, height, 0.0f, buffer);
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, float zLevel, class_287 buffer) {
        float pixelWidth = 0.00390625f;
        buffer.method_22912((float)x, (float)(y + height), zLevel).method_22913((float)u * pixelWidth, (float)(v + height) * pixelWidth);
        buffer.method_22912((float)(x + width), (float)(y + height), zLevel).method_22913((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth);
        buffer.method_22912((float)(x + width), (float)y, zLevel).method_22913((float)(u + width) * pixelWidth, (float)v * pixelWidth);
        buffer.method_22912((float)x, (float)y, zLevel).method_22913((float)u * pixelWidth, (float)v * pixelWidth);
    }

    public static void drawHoverText(int x, int y, List<String> textLines, class_332 drawContext) {
        class_310 mc = RenderUtils.mc();
        if (!textLines.isEmpty() && GuiUtils.getCurrentScreen() != null) {
            RenderSystem.enableDepthTest();
            class_327 font = mc.field_1772;
            int maxLineLength = 0;
            int maxWidth = GuiUtils.getCurrentScreen().field_22789;
            ArrayList<String> linesNew = new ArrayList<String>();
            for (String lineOrig : textLines) {
                String[] lines;
                for (String line : lines = lineOrig.split("\\n")) {
                    int length = font.method_1727(line);
                    if (length > maxLineLength) {
                        maxLineLength = length;
                    }
                    linesNew.add(line);
                }
            }
            textLines = linesNew;
            Objects.requireNonNull(font);
            int lineHeight = 9 + 1;
            int textHeight = textLines.size() * lineHeight - 2;
            int textStartX = x + 4;
            int textStartY = Math.max(8, y - textHeight - 6);
            if (textStartX + maxLineLength + 6 > maxWidth) {
                textStartX = Math.max(2, maxWidth - maxLineLength - 8);
            }
            class_4587 matrixStack = drawContext.method_51448();
            matrixStack.method_22903();
            matrixStack.method_46416(0.0f, 0.0f, 300.0f);
            RenderSystem.applyModelViewMatrix();
            float zLevel = 300.0f;
            int borderColor = -267386864;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 4, textStartX + maxLineLength + 3, textStartY - 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 3, textStartX + maxLineLength + 3, textStartY + textHeight + 4, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 4, textStartY - 3, textStartX - 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 3, textStartY - 3, textStartX + maxLineLength + 4, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            int fillColor1 = 0x505000FF;
            int fillColor2 = 1344798847;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3 + 1, textStartX - 3 + 1, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 2, textStartY - 3 + 1, textStartX + maxLineLength + 3, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY - 3 + 1, zLevel, fillColor1, fillColor1);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 2, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, fillColor2, fillColor2);
            for (int i = 0; i < textLines.size(); ++i) {
                String str = textLines.get(i);
                drawContext.method_51433(font, str, textStartX, textStartY, -1, false);
                textStartY += lineHeight;
            }
            matrixStack.method_22909();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void drawGradientRect(float left, float top, float right, float bottom, float zLevel, int startColor, int endColor) {
        int sa = startColor >> 24 & 0xFF;
        int sr = startColor >> 16 & 0xFF;
        int sg = startColor >> 8 & 0xFF;
        int sb = startColor & 0xFF;
        int ea = endColor >> 24 & 0xFF;
        int er = endColor >> 16 & 0xFF;
        int eg = endColor >> 8 & 0xFF;
        int eb = endColor & 0xFF;
        RenderUtils.setupBlend();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.applyModelViewMatrix();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22912(right, top, zLevel).method_1336(sr, sg, sb, sa);
        buffer.method_22912(left, top, zLevel).method_1336(sr, sg, sb, sa);
        buffer.method_22912(left, bottom, zLevel).method_1336(er, eg, eb, ea);
        buffer.method_22912(right, bottom, zLevel).method_1336(er, eg, eb, ea);
        try {
            class_9801 builtBuffer = buffer.method_60800();
            class_286.method_43433((class_9801)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RenderSystem.disableBlend();
    }

    public static void drawCenteredString(int x, int y, int color, String text, class_332 drawContext) {
        class_327 textRenderer = RenderUtils.mc().field_1772;
        drawContext.method_25300(textRenderer, text, x, y, color);
    }

    public static void drawHorizontalLine(int x, int y, int width, int color) {
        RenderUtils.drawRect(x, y, width, 1, color);
    }

    public static void drawVerticalLine(int x, int y, int height, int color) {
        RenderUtils.drawRect(x, y, 1, height, color);
    }

    public static void renderSprite(int x, int y, int width, int height, class_2960 atlas, class_2960 texture, class_332 drawContext) {
        if (texture != null) {
            class_1058 sprite = (class_1058)RenderUtils.mc().method_1549(atlas).apply(texture);
            drawContext.method_25298(x, y, 0, width, height, sprite);
        }
    }

    public static void renderText(int x, int y, int color, String text, class_332 drawContext) {
        String[] parts = text.split("\\\\n");
        class_327 textRenderer = RenderUtils.mc().field_1772;
        for (String line : parts) {
            drawContext.method_51433(textRenderer, line, x, y, color, true);
            Objects.requireNonNull(textRenderer);
            y += 9 + 1;
        }
    }

    public static void renderText(int x, int y, int color, List<String> lines, class_332 drawContext) {
        if (!lines.isEmpty()) {
            class_327 textRenderer = RenderUtils.mc().field_1772;
            for (String line : lines) {
                drawContext.method_51433(textRenderer, line, x, y, color, false);
                Objects.requireNonNull(textRenderer);
                y += 9 + 2;
            }
        }
    }

    public static int renderText(int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, List<String> lines, class_332 drawContext) {
        return RenderUtils.renderText(xOff, yOff, scale, textColor, bgColor, alignment, useBackground, useShadow, MaLiLibConfigs.Generic.ENABLE_STATUS_EFFECTS_SHIFT.getBooleanValue(), lines, drawContext);
    }

    public static int renderText(int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, boolean useStatusShift, List<String> lines, class_332 drawContext) {
        boolean scaled;
        class_327 fontRenderer = RenderUtils.mc().field_1772;
        int scaledWidth = GuiUtils.getScaledWindowWidth();
        Objects.requireNonNull(fontRenderer);
        int lineHeight = 9 + 2;
        int contentHeight = lines.size() * lineHeight - 2;
        int bgMargin = 2;
        if (scale < 0.0125) {
            return 0;
        }
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        boolean bl = scaled = scale != 1.0;
        if (scaled) {
            if (scale != 0.0) {
                xOff = (int)((double)xOff * scale);
                yOff = (int)((double)yOff * scale);
            }
            global4fStack.pushMatrix();
            global4fStack.scale((float)scale, (float)scale, 1.0f);
            RenderSystem.applyModelViewMatrix();
        }
        double posX = xOff + 2;
        double posY = yOff + 2;
        posY = RenderUtils.getHudPosY((int)posY, yOff, contentHeight, scale, alignment);
        if (useStatusShift) {
            posY += (double)RenderUtils.getHudOffsetForPotions(alignment, scale, (class_1657)RenderUtils.mc().field_1724);
        }
        for (String line : lines) {
            int width = fontRenderer.method_1727(line);
            switch (alignment) {
                case TOP_RIGHT: 
                case BOTTOM_RIGHT: {
                    posX = (double)scaledWidth / scale - (double)width - (double)xOff - 2.0;
                    break;
                }
                case CENTER: {
                    posX = (double)scaledWidth / scale / 2.0 - (double)width / 2.0 - (double)xOff;
                    break;
                }
            }
            int x = (int)posX;
            int y = (int)posY;
            posY += (double)lineHeight;
            if (useBackground) {
                Objects.requireNonNull(fontRenderer);
                RenderUtils.drawRect(x - 2, y - 2, width + 2, 2 + 9, bgColor);
            }
            drawContext.method_51433(fontRenderer, line, x, y, textColor, useShadow);
        }
        if (scaled) {
            global4fStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
        return contentHeight + 4;
    }

    public static int getHudOffsetForPotions(HudAlignment alignment, double scale, class_1657 player) {
        if (alignment == HudAlignment.TOP_RIGHT) {
            if (scale == 0.0) {
                return 0;
            }
            Collection effects = player.method_6026();
            boolean hasTurtleHelmet = EntityUtils.hasTurtleHelmetEquipped(player);
            if (!effects.isEmpty()) {
                int y1 = 0;
                int y2 = 0;
                for (class_1293 effectInstance : effects) {
                    class_1291 effect = (class_1291)effectInstance.method_5579().comp_349();
                    if (!effectInstance.method_5581() || !effectInstance.method_5592()) continue;
                    if (effect.method_5573()) {
                        y1 = 26;
                        continue;
                    }
                    y2 = 52;
                    break;
                }
                if (hasTurtleHelmet && y1 == 0) {
                    y1 = 26;
                }
                return (int)((double)Math.max(y1, y2) / scale);
            }
            if (hasTurtleHelmet) {
                return (int)(26.0 / scale);
            }
        }
        return 0;
    }

    public static int getHudPosY(int yOrig, int yOffset, int contentHeight, double scale, HudAlignment alignment) {
        int scaledHeight = GuiUtils.getScaledWindowHeight();
        int posY = yOrig;
        switch (alignment) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                posY = (int)((double)scaledHeight / scale - (double)contentHeight - (double)yOffset);
                break;
            }
            case CENTER: {
                posY = (int)((double)scaledHeight / scale / 2.0 - (double)contentHeight / 2.0 + (double)yOffset);
                break;
            }
        }
        return posY;
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(class_2338 pos, Color4f color, double expand, class_287 buffer) {
        float minX = (float)((double)pos.method_10263() - expand);
        float minY = (float)((double)pos.method_10264() - expand);
        float minZ = (float)((double)pos.method_10260() - expand);
        float maxX = (float)((double)pos.method_10263() + expand + 1.0);
        float maxY = (float)((double)pos.method_10264() + expand + 1.0);
        float maxZ = (float)((double)pos.method_10260() + expand + 1.0);
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(class_2338 pos, Color4f color, double expand, class_287 buffer) {
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(pos, class_243.field_1353, color, expand, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(class_2338 pos, class_243 cameraPos, Color4f color, double expand, class_287 buffer) {
        float minX = (float)((double)pos.method_10263() - expand - cameraPos.field_1352);
        float minY = (float)((double)pos.method_10264() - expand - cameraPos.field_1351);
        float minZ = (float)((double)pos.method_10260() - expand - cameraPos.field_1350);
        float maxX = (float)((double)pos.method_10263() + expand - cameraPos.field_1352 + 1.0);
        float maxY = (float)((double)pos.method_10264() + expand - cameraPos.field_1351 + 1.0);
        float maxZ = (float)((double)pos.method_10260() + expand - cameraPos.field_1350 + 1.0);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBoxAllSidesBatchedQuads(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, class_287 buffer) {
        RenderUtils.drawBoxHorizontalSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxTopBatchedQuads(minX, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxBottomBatchedQuads(minX, minY, minZ, maxX, maxZ, color, buffer);
    }

    public static void drawBoxWithEdgesBatched(class_2338 posMin, class_2338 posMax, Color4f colorLines, Color4f colorSides, class_287 bufferQuads, class_287 bufferLines) {
        RenderUtils.drawBoxWithEdgesBatched(posMin, posMax, class_243.field_1353, colorLines, colorSides, bufferQuads, bufferLines);
    }

    public static void drawBoxWithEdgesBatched(class_2338 posMin, class_2338 posMax, class_243 cameraPos, Color4f colorLines, Color4f colorSides, class_287 bufferQuads, class_287 bufferLines) {
        float x1 = (float)((double)posMin.method_10263() - cameraPos.field_1352);
        float y1 = (float)((double)posMin.method_10264() - cameraPos.field_1351);
        float z1 = (float)((double)posMin.method_10260() - cameraPos.field_1350);
        float x2 = (float)((double)(posMax.method_10263() + 1) - cameraPos.field_1352);
        float y2 = (float)((double)(posMax.method_10264() + 1) - cameraPos.field_1351);
        float z2 = (float)((double)(posMax.method_10260() + 1) - cameraPos.field_1350);
        RenderUtils.drawBoxAllSidesBatchedQuads(x1, y1, z1, x2, y2, z2, colorSides, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(x1, y1, z1, x2, y2, z2, colorLines, bufferLines);
    }

    public static void drawBoxHorizontalSidesBatchedQuads(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, class_287 buffer) {
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void drawBoxTopBatchedQuads(float minX, float minZ, float maxX, float maxY, float maxZ, Color4f color, class_287 buffer) {
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void drawBoxBottomBatchedQuads(float minX, float minY, float minZ, float maxX, float maxZ, Color4f color, class_287 buffer) {
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void drawBoxAllEdgesBatchedLines(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, class_287 buffer) {
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void drawBox(IntBoundingBox bb, class_243 cameraPos, Color4f color, class_287 bufferQuads, class_287 bufferLines) {
        float minX = (float)((double)bb.minX - cameraPos.field_1352);
        float minY = (float)((double)bb.minY - cameraPos.field_1351);
        float minZ = (float)((double)bb.minZ - cameraPos.field_1350);
        float maxX = (float)((double)(bb.maxX + 1) - cameraPos.field_1352);
        float maxY = (float)((double)(bb.maxY + 1) - cameraPos.field_1351);
        float maxZ = (float)((double)(bb.maxZ + 1) - cameraPos.field_1350);
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, bufferLines);
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float scale) {
        class_1297 entity = RenderUtils.mc().method_1560();
        if (entity != null) {
            RenderUtils.drawTextPlate(text, x, y, z, entity.method_36454(), entity.method_36455(), scale, -1, 0x40000000, true);
        }
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float yaw, float pitch, float scale, int textColor, int bgColor, boolean disableDepth) {
        class_243 cameraPos = RenderUtils.mc().field_1773.method_19418().method_19326();
        double cx = cameraPos.field_1352;
        double cy = cameraPos.field_1351;
        double cz = cameraPos.field_1350;
        class_327 textRenderer = RenderUtils.mc().field_1772;
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        global4fStack.pushMatrix();
        global4fStack.translate((float)(x - cx), (float)(y - cy), (float)(z - cz));
        global4fStack.rotateYXZ(-yaw * ((float)Math.PI / 180), pitch * ((float)Math.PI / 180), 0.0f);
        global4fStack.scale(-scale, -scale, scale);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableCull();
        RenderUtils.setupBlend();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        int maxLineLen = 0;
        for (String line : text) {
            maxLineLen = Math.max(maxLineLen, textRenderer.method_1727(line));
        }
        int strLenHalf = maxLineLen / 2;
        Objects.requireNonNull(textRenderer);
        int textHeight = 9 * text.size() - 1;
        int bga = bgColor >>> 24 & 0xFF;
        int bgr = bgColor >>> 16 & 0xFF;
        int bgg = bgColor >>> 8 & 0xFF;
        int bgb = bgColor & 0xFF;
        if (disableDepth) {
            RenderSystem.disableDepthTest();
        }
        buffer.method_22912((float)(-strLenHalf - 1), -1.0f, 0.0f).method_1336(bgr, bgg, bgb, bga);
        buffer.method_22912((float)(-strLenHalf - 1), (float)textHeight, 0.0f).method_1336(bgr, bgg, bgb, bga);
        buffer.method_22912((float)strLenHalf, (float)textHeight, 0.0f).method_1336(bgr, bgg, bgb, bga);
        buffer.method_22912((float)strLenHalf, -1.0f, 0.0f).method_1336(bgr, bgg, bgb, bga);
        try {
            class_9801 builtBuffer = buffer.method_60800();
            class_286.method_43433((class_9801)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int textY = 0;
        if (!disableDepth) {
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-0.6f, (float)-1.2f);
        }
        Matrix4f modelMatrix = new Matrix4f();
        modelMatrix.identity();
        class_9799 allocator = new class_9799(1536);
        for (String line : text) {
            class_4597.class_4598 immediate;
            if (disableDepth) {
                RenderSystem.disableDepthTest();
                immediate = class_4597.method_22991((class_9799)allocator);
                textRenderer.method_27521(line, (float)(-strLenHalf), (float)textY, 0x20000000 | textColor & 0xFFFFFF, false, modelMatrix, (class_4597)immediate, class_327.class_6415.field_33994, 0, 0xF000F0);
                immediate.method_22993();
                RenderSystem.enableDepthTest();
            }
            immediate = class_4597.method_22991((class_9799)allocator);
            textRenderer.method_27521(line, (float)(-strLenHalf), (float)textY, textColor, false, modelMatrix, (class_4597)immediate, class_327.class_6415.field_33994, 0, 0xF000F0);
            immediate.method_22993();
            Objects.requireNonNull(textRenderer);
            textY += 9;
        }
        allocator.close();
        if (!disableDepth) {
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableCull();
        global4fStack.popMatrix();
    }

    public static void renderBlockTargetingOverlay(class_1297 entity, class_2338 pos, class_2350 side, class_243 hitVec, Color4f color, Matrix4f posMatrix, class_310 mc) {
        class_9801 builtBuffer;
        class_2350 playerFacing = entity.method_5735();
        PositionUtils.HitPart part = PositionUtils.getHitPart(side, playerFacing, pos, hitVec);
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double x = (double)pos.method_10263() + 0.5 - cameraPos.field_1352;
        double y = (double)pos.method_10264() + 0.5 - cameraPos.field_1351;
        double z = (double)pos.method_10260() + 0.5 - cameraPos.field_1350;
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        global4fStack.pushMatrix();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, global4fStack);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        int quadAlpha = 45;
        int hr = (int)(color.r * 255.0f);
        int hg = (int)(color.g * 255.0f);
        int hb = (int)(color.b * 255.0f);
        int ha = (int)(color.a * 255.0f);
        int c = 255;
        buffer.method_22912((float)(x - 0.5), (float)(y - 0.5), (float)z).method_1336(c, c, c, quadAlpha);
        buffer.method_22912((float)(x + 0.5), (float)(y - 0.5), (float)z).method_1336(c, c, c, quadAlpha);
        buffer.method_22912((float)(x + 0.5), (float)(y + 0.5), (float)z).method_1336(c, c, c, quadAlpha);
        buffer.method_22912((float)(x - 0.5), (float)(y + 0.5), (float)z).method_1336(c, c, c, quadAlpha);
        switch (part) {
            case CENTER: {
                buffer.method_22912((float)(x - 0.25), (float)(y - 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.25), (float)(y - 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.25), (float)(y + 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x - 0.25), (float)(y + 0.25), (float)z).method_1336(hr, hg, hb, ha);
                break;
            }
            case LEFT: {
                buffer.method_22912((float)(x - 0.5), (float)(y - 0.5), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x - 0.25), (float)(y - 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x - 0.25), (float)(y + 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x - 0.5), (float)(y + 0.5), (float)z).method_1336(hr, hg, hb, ha);
                break;
            }
            case RIGHT: {
                buffer.method_22912((float)(x + 0.5), (float)(y - 0.5), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.25), (float)(y - 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.25), (float)(y + 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.5), (float)(y + 0.5), (float)z).method_1336(hr, hg, hb, ha);
                break;
            }
            case TOP: {
                buffer.method_22912((float)(x - 0.5), (float)(y + 0.5), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x - 0.25), (float)(y + 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.25), (float)(y + 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.5), (float)(y + 0.5), (float)z).method_1336(hr, hg, hb, ha);
                break;
            }
            case BOTTOM: {
                buffer.method_22912((float)(x - 0.5), (float)(y - 0.5), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x - 0.25), (float)(y - 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.25), (float)(y - 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.5), (float)(y - 0.5), (float)z).method_1336(hr, hg, hb, ha);
                break;
            }
        }
        try {
            builtBuffer = buffer.method_60800();
            class_286.method_43433((class_9801)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RenderSystem.lineWidth((float)1.6f);
        buffer = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1576);
        buffer.method_22912((float)(x - 0.25), (float)(y - 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.25), (float)(y - 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.25), (float)(y + 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x - 0.25), (float)(y + 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x - 0.25), (float)(y - 0.25), (float)z).method_1336(c, c, c, c);
        try {
            builtBuffer = buffer.method_60800();
            class_286.method_43433((class_9801)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        buffer.method_22912((float)(x - 0.5), (float)(y - 0.5), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x - 0.25), (float)(y - 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x - 0.5), (float)(y + 0.5), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x - 0.25), (float)(y + 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.5), (float)(y - 0.5), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.25), (float)(y - 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.5), (float)(y + 0.5), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.25), (float)(y + 0.25), (float)z).method_1336(c, c, c, c);
        try {
            builtBuffer = buffer.method_60800();
            class_286.method_43433((class_9801)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        global4fStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderBlockTargetingOverlaySimple(class_1297 entity, class_2338 pos, class_2350 side, Color4f color, Matrix4f posMatrix, class_310 mc) {
        class_9801 builtBuffer;
        class_2350 playerFacing = entity.method_5735();
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double x = (double)pos.method_10263() + 0.5 - cameraPos.field_1352;
        double y = (double)pos.method_10264() + 0.5 - cameraPos.field_1351;
        double z = (double)pos.method_10260() + 0.5 - cameraPos.field_1350;
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        global4fStack.pushMatrix();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, global4fStack);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        int a = (int)(color.a * 255.0f);
        int r = (int)(color.r * 255.0f);
        int g = (int)(color.g * 255.0f);
        int b = (int)(color.b * 255.0f);
        int c = 255;
        buffer.method_22912((float)(x - 0.5), (float)(y - 0.5), (float)z).method_1336(r, g, b, a);
        buffer.method_22912((float)(x + 0.5), (float)(y - 0.5), (float)z).method_1336(r, g, b, a);
        buffer.method_22912((float)(x + 0.5), (float)(y + 0.5), (float)z).method_1336(r, g, b, a);
        buffer.method_22912((float)(x - 0.5), (float)(y + 0.5), (float)z).method_1336(r, g, b, a);
        try {
            builtBuffer = buffer.method_60800();
            class_286.method_43433((class_9801)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RenderSystem.lineWidth((float)1.6f);
        buffer = tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1576);
        buffer.method_22912((float)(x - 0.375), (float)(y - 0.375), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.375), (float)(y - 0.375), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.375), (float)(y + 0.375), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x - 0.375), (float)(y + 0.375), (float)z).method_1336(c, c, c, c);
        try {
            builtBuffer = buffer.method_60800();
            class_286.method_43433((class_9801)builtBuffer);
            builtBuffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        global4fStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private static void blockTargetingOverlayTranslations(double x, double y, double z, class_2350 side, class_2350 playerFacing, Matrix4fStack matrix4fStack) {
        matrix4fStack.translate((float)x, (float)y, (float)z);
        switch (side) {
            case field_11033: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(180.0f - playerFacing.method_10144()));
                matrix4fStack.rotateX(RenderUtils.matrix4fRotateFix(90.0f));
                break;
            }
            case field_11036: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(180.0f - playerFacing.method_10144()));
                matrix4fStack.rotateX(RenderUtils.matrix4fRotateFix(-90.0f));
                break;
            }
            case field_11043: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(180.0f));
                break;
            }
            case field_11035: {
                break;
            }
            case field_11039: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(-90.0f));
                break;
            }
            case field_11034: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(90.0f));
            }
        }
        matrix4fStack.translate((float)(-x), (float)(-y), (float)(-z + 0.51));
    }

    public static void renderMapPreview(class_1799 stack, int x, int y, int dimensions) {
        RenderUtils.renderMapPreview(stack, x, y, dimensions, true);
    }

    public static void renderMapPreview(class_1799 stack, int x, int y, int dimensions, boolean requireShift) {
        if (stack.method_7909() instanceof class_1806 && (!requireShift || GuiBase.isShiftDown())) {
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            int y1 = y - dimensions - 20;
            int y2 = y1 + dimensions;
            int x1 = x + 8;
            int x2 = x1 + dimensions;
            int z = 300;
            class_22 mapState = class_1806.method_8001((class_1799)stack, (class_1937)RenderUtils.mc().field_1687);
            class_9323 data = stack.method_57353();
            class_9209 mapId = (class_9209)data.method_57829(class_9334.field_49646);
            class_2960 bgTexture = mapState == null ? TEXTURE_MAP_BACKGROUND : TEXTURE_MAP_BACKGROUND_CHECKERBOARD;
            RenderUtils.bindTexture(bgTexture);
            RenderUtils.setupBlend();
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.applyModelViewMatrix();
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
            buffer.method_22912((float)x1, (float)y2, (float)z).method_22913(0.0f, 1.0f);
            buffer.method_22912((float)x2, (float)y2, (float)z).method_22913(1.0f, 1.0f);
            buffer.method_22912((float)x2, (float)y1, (float)z).method_22913(1.0f, 0.0f);
            buffer.method_22912((float)x1, (float)y1, (float)z).method_22913(0.0f, 0.0f);
            try {
                class_9801 builtBuffer = buffer.method_60800();
                class_286.method_43433((class_9801)builtBuffer);
                builtBuffer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            RenderSystem.disableBlend();
            if (mapState != null) {
                x1 += 8;
                y1 += 8;
                z = 310;
                class_9799 allocator = new class_9799(1536);
                class_4597.class_4598 consumer = class_4597.method_22991((class_9799)allocator);
                double scale = (double)(dimensions - 16) / 128.0;
                class_4587 matrixStack = new class_4587();
                matrixStack.method_22903();
                matrixStack.method_46416((float)x1, (float)y1, (float)z);
                matrixStack.method_22905((float)scale, (float)scale, 0.0f);
                RenderUtils.mc().field_1773.method_3194().method_1773(matrixStack, (class_4597)consumer, mapId, mapState, false, 0xF000F0);
                consumer.method_22993();
                matrixStack.method_22909();
                allocator.close();
            }
        }
    }

    public static void renderShulkerBoxPreview(class_1799 stack, int baseX, int baseY, boolean useBgColors, class_332 drawContext) {
        if (stack.method_57353().method_57832(class_9334.field_49622)) {
            class_2371<class_1799> items = InventoryUtils.getStoredItems(stack, -1);
            if (items.isEmpty()) {
                return;
            }
            class_2487 nbt = InventoryUtils.getStoredBlockEntityNbt(stack);
            HashSet<Integer> lockedSlots = new HashSet();
            class_1263 inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = class_3532.method_15340((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = class_3532.method_15340((int)(baseY - height), (int)0, (int)(screenHeight - height));
            if (stack.method_7909() instanceof class_1747 && ((class_1747)stack.method_7909()).method_7711() instanceof class_2480) {
                RenderUtils.setShulkerboxBackgroundTintColor((class_2480)((class_1747)stack.method_7909()).method_7711(), useBgColors);
            } else {
                RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            }
            RenderUtils.disableDiffuseLighting();
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate(0.0f, 0.0f, 500.0f);
            RenderSystem.applyModelViewMatrix();
            InventoryOverlay.renderInventoryBackground(type, x, y, props.slotsPerRow, props.totalSlots, RenderUtils.mc());
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            RenderUtils.enableDiffuseLightingGui3D();
            if (type == InventoryOverlay.InventoryRenderType.CRAFTER && !nbt.method_33133()) {
                lockedSlots = NbtBlockUtils.getDisabledSlotsFromNbt(nbt);
                InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, lockedSlots, RenderUtils.mc(), drawContext);
            } else {
                InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc(), drawContext);
            }
            matrix4fStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void renderBundlePreview(class_1799 stack, int baseX, int baseY, boolean useBgColors, class_332 drawContext) {
        RenderUtils.renderBundlePreview(stack, baseX, baseY, 9, useBgColors, drawContext);
    }

    public static void renderBundlePreview(class_1799 stack, int baseX, int baseY, int slotsPerRow, boolean useBgColors, class_332 drawContext) {
        if (stack.method_57353().method_57832(class_9334.field_49650)) {
            int count = InventoryUtils.bundleCountItems(stack);
            class_2371<class_1799> items = InventoryUtils.getBundleItems(stack, count);
            int n = slotsPerRow = slotsPerRow != 9 ? MathUtils.clamp(slotsPerRow, 6, 9) : 9;
            if (items.isEmpty()) {
                return;
            }
            class_1263 inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, count, slotsPerRow);
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = class_3532.method_15340((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = class_3532.method_15340((int)(baseY - height), (int)0, (int)(screenHeight - height));
            RenderUtils.setBundleBackgroundTintColor(stack, useBgColors);
            RenderUtils.disableDiffuseLighting();
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate(0.0f, 0.0f, 500.0f);
            InventoryOverlay.renderInventoryBackground(type, x, y, props.slotsPerRow, props.totalSlots, RenderUtils.mc());
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            RenderUtils.enableDiffuseLightingGui3D();
            InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, count, RenderUtils.mc(), drawContext);
            matrix4fStack.popMatrix();
        }
    }

    public static void renderNbtItemsPreview(class_1799 stackIn, @Nonnull class_2487 itemsTag, int baseX, int baseY, boolean useBgColors, class_332 drawContext) {
        if (InventoryUtils.hasNbtItems(itemsTag)) {
            if (RenderUtils.mc().field_1687 == null) {
                return;
            }
            class_2371<class_1799> items = InventoryUtils.getNbtItems(itemsTag, -1, (class_7225.class_7874)RenderUtils.mc().field_1687.method_30349());
            if (items.size() == 0) {
                return;
            }
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stackIn);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = class_3532.method_15340((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = class_3532.method_15340((int)(baseY - height), (int)0, (int)(screenHeight - height));
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            RenderUtils.disableDiffuseLighting();
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate(0.0f, 0.0f, 500.0f);
            RenderSystem.applyModelViewMatrix();
            InventoryOverlay.renderInventoryBackground(type, x, y, props.slotsPerRow, items.size(), RenderUtils.mc());
            RenderUtils.enableDiffuseLightingGui3D();
            class_1263 inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc(), drawContext);
            matrix4fStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void setShulkerboxBackgroundTintColor(@Nullable class_2480 block, boolean useBgColors) {
        if (block != null && useBgColors) {
            class_1767 dye = block.method_10528() != null ? block.method_10528() : class_1767.field_7945;
            float[] colors = RenderUtils.getColorComponents(dye.method_7787());
            RenderUtils.color(colors[0], colors[1], colors[2], 1.0f);
        } else {
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static float[] getColorComponents(int color) {
        int j = (color & 0xFF0000) >> 16;
        int k = (color & 0xFF00) >> 8;
        int l = (color & 0xFF) >> 0;
        return new float[]{(float)j / 255.0f, (float)k / 255.0f, (float)l / 255.0f};
    }

    public static void setBundleBackgroundTintColor(class_1799 bundle, boolean useBgColors) {
        class_1767 dye;
        if (useBgColors && (dye = RenderUtils.getBundleColor(bundle)) != null) {
            float[] colors = RenderUtils.getColorComponents(dye.method_7787());
            RenderUtils.color(colors[0], colors[1], colors[2], 1.0f);
            return;
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static class_1767 getBundleColor(class_1799 bundle) {
        class_1792 item = bundle.method_7909();
        if (item == null) {
            return null;
        }
        return class_1767.field_7957;
    }

    public static void setVillagerBackgroundTintColor(class_3850 data, boolean useBgColors) {
        class_3852 profession = data != null ? data.method_16924() : null;
        RenderUtils.setVillagerBackgroundTintColor(profession, useBgColors);
    }

    public static void setVillagerBackgroundTintColor(class_3852 profession, boolean useBgColors) {
        class_1767 dye;
        if (useBgColors && (dye = RenderUtils.getVillagerColor(profession)) != null) {
            float[] colors = RenderUtils.getColorComponents(dye.method_7787());
            RenderUtils.color(colors[0], colors[1], colors[2], 1.0f);
            return;
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static class_1767 getVillagerColor(class_3852 profession) {
        if (profession.equals((Object)class_3852.field_17051)) {
            return class_1767.field_7966;
        }
        if (profession.equals((Object)class_3852.field_17052)) {
            return class_1767.field_7944;
        }
        if (profession.equals((Object)class_3852.field_17053)) {
            return class_1767.field_7954;
        }
        if (profession.equals((Object)class_3852.field_17054)) {
            return class_1767.field_7951;
        }
        if (profession.equals((Object)class_3852.field_17055)) {
            return class_1767.field_7945;
        }
        if (profession.equals((Object)class_3852.field_17056)) {
            return class_1767.field_7947;
        }
        if (profession.equals((Object)class_3852.field_17057)) {
            return class_1767.field_7955;
        }
        if (profession.equals((Object)class_3852.field_17058)) {
            return class_1767.field_7946;
        }
        if (profession.equals((Object)class_3852.field_17059)) {
            return class_1767.field_7957;
        }
        if (profession.equals((Object)class_3852.field_17060)) {
            return class_1767.field_7964;
        }
        if (profession.equals((Object)class_3852.field_17061)) {
            return class_1767.field_7958;
        }
        if (profession.equals((Object)class_3852.field_17062)) {
            return class_1767.field_7942;
        }
        if (profession.equals((Object)class_3852.field_17063)) {
            return class_1767.field_7952;
        }
        if (profession.equals((Object)class_3852.field_17064)) {
            return class_1767.field_7967;
        }
        if (profession.equals((Object)class_3852.field_17065)) {
            return class_1767.field_7963;
        }
        return class_1767.field_7961;
    }

    public static void renderModelInGui(int x, int y, class_1087 model, class_2680 state, float zLevel) {
        if (state.method_26204() == class_2246.field_10124) {
            return;
        }
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        RenderUtils.bindTexture(class_1723.field_21668);
        RenderUtils.mc().method_1531().method_4619(class_1723.field_21668).method_4527(false, false);
        RenderSystem.enableBlend();
        RenderUtils.setupBlendSimple();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderUtils.setupGuiTransform(x, y, model.method_4712(), zLevel);
        matrix4fStack.rotateX(RenderUtils.matrix4fRotateFix(30.0f));
        matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(225.0f));
        matrix4fStack.scale(0.625f, 0.625f, 0.625f);
        RenderUtils.renderModel(model, state);
        matrix4fStack.popMatrix();
    }

    public static void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d, float zLevel) {
        RenderUtils.setupGuiTransform(RenderSystem.getModelViewStack(), xPosition, yPosition, zLevel);
    }

    public static void setupGuiTransform(Matrix4fStack matrix4fStack, int xPosition, int yPosition, float zLevel) {
        matrix4fStack.translate((float)((double)xPosition + 8.0), (float)((double)yPosition + 8.0), (float)((double)zLevel + 100.0));
        matrix4fStack.scale(16.0f, -16.0f, 16.0f);
    }

    private static void renderModel(class_1087 model, class_2680 state) {
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        matrix4fStack.translate(-0.5f, -0.5f, -0.5f);
        int color = -1;
        if (!model.method_4713()) {
            RenderSystem.setShader(class_757::method_34495);
            RenderSystem.applyModelViewMatrix();
            class_289 tessellator = class_289.method_1348();
            class_287 bufferbuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1590);
            for (class_2350 face : class_2350.values()) {
                RAND.method_43052(0L);
                RenderUtils.renderQuads(bufferbuilder, model.method_4707(state, face, (class_5819)RAND), state, color);
            }
            RAND.method_43052(0L);
            RenderUtils.renderQuads(bufferbuilder, model.method_4707(state, null, (class_5819)RAND), state, color);
            try {
                class_9801 builtBuffer = bufferbuilder.method_60800();
                class_286.method_43433((class_9801)builtBuffer);
                builtBuffer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        matrix4fStack.popMatrix();
    }

    private static void renderQuads(class_287 renderer, List<class_777> quads, class_2680 state, int color) {
        int quadCount = quads.size();
        for (int i = 0; i < quadCount; ++i) {
            class_777 quad = quads.get(i);
            RenderUtils.renderQuad(renderer, quad, state, -1);
        }
    }

    private static void renderQuad(class_287 buffer, class_777 quad, class_2680 state, int color) {
    }

    private static class_310 mc() {
        return class_310.method_1551();
    }

    public static float matrix4fRotateFix(float ang) {
        return ang * ((float)Math.PI / 180);
    }
}

