/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.game.wrap.NbtWrap;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;

public class NbtUtils {
    @Nullable
    public static UUID readUUID(@Nonnull class_2487 tag) {
        return NbtUtils.readUUID(tag, "UUIDM", "UUIDL");
    }

    @Nullable
    public static UUID readUUID(@Nonnull class_2487 tag, String keyM, String keyL) {
        if (NbtWrap.containsLong(tag, keyM) && NbtWrap.containsLong(tag, keyL)) {
            return new UUID(NbtWrap.getLong(tag, keyM), NbtWrap.getLong(tag, keyL));
        }
        return null;
    }

    public static void writeUUID(@Nonnull class_2487 tag, UUID uuid) {
        NbtUtils.writeUUID(tag, uuid, "UUIDM", "UUIDL");
    }

    public static void writeUUID(@Nonnull class_2487 tag, UUID uuid, String keyM, String keyL) {
        NbtWrap.putLong(tag, keyM, uuid.getMostSignificantBits());
        NbtWrap.putLong(tag, keyL, uuid.getLeastSignificantBits());
    }

    public static class_2487 getOrCreateCompound(@Nonnull class_2487 tagIn, String tagName) {
        class_2487 nbt;
        if (NbtWrap.containsCompound(tagIn, tagName)) {
            nbt = NbtWrap.getCompound(tagIn, tagName);
        } else {
            nbt = new class_2487();
            NbtWrap.putTag(tagIn, tagName, (class_2520)nbt);
        }
        return nbt;
    }

    public static <T> class_2499 asListTag(Collection<T> values, Function<T, class_2520> tagFactory) {
        class_2499 list = new class_2499();
        for (T val : values) {
            NbtWrap.addTag(list, tagFactory.apply(val));
        }
        return list;
    }

    @Nonnull
    public static class_2487 createBlockPos(@Nonnull class_2338 pos) {
        return NbtUtils.writeBlockPos(pos, new class_2487());
    }

    @Nonnull
    public static class_2487 createBlockPosTag(@Nonnull class_2338 pos) {
        return NbtUtils.writeBlockPos(pos, new class_2487());
    }

    @Nonnull
    public static class_2487 createBlockPosTag(@Nonnull class_2382 pos) {
        return NbtUtils.putVec3i(new class_2487(), pos);
    }

    @Nonnull
    public static class_2487 createVec3iTag(@Nonnull class_2382 pos) {
        return NbtUtils.putVec3i(new class_2487(), pos);
    }

    @Nonnull
    public static class_2487 createVec3iToArray(@Nonnull class_2382 pos, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, new class_2487(), tagName);
    }

    @Nonnull
    public static class_2487 createVec3iToArrayTag(@Nonnull class_2382 pos, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, new class_2487(), tagName);
    }

    @Nonnull
    public static class_2487 createEntityPosition(@Nonnull class_243 pos) {
        return NbtUtils.createEntityPositionToTag(pos);
    }

    @Nonnull
    public static class_2487 createEntityPositionToTag(@Nonnull class_243 pos) {
        return NbtUtils.writeVec3dToListTag(pos, new class_2487(), "Pos");
    }

    @Nonnull
    public static class_2487 putVec3i(@Nonnull class_2487 tag, @Nonnull class_2382 pos) {
        NbtWrap.putInt(tag, "x", pos.method_10263());
        NbtWrap.putInt(tag, "y", pos.method_10264());
        NbtWrap.putInt(tag, "z", pos.method_10260());
        return tag;
    }

    @Nonnull
    public static class_2487 writeBlockPosToTag(@Nonnull class_2338 pos, @Nonnull class_2487 tag) {
        return NbtUtils.writeBlockPos(pos, tag);
    }

    @Nonnull
    public static class_2487 writeBlockPos(@Nonnull class_2338 pos, @Nonnull class_2487 tag) {
        NbtWrap.putInt(tag, "x", pos.method_10263());
        NbtWrap.putInt(tag, "y", pos.method_10264());
        NbtWrap.putInt(tag, "z", pos.method_10260());
        return tag;
    }

    @Nonnull
    public static class_2487 writeBlockPosToListTag(@Nonnull class_2382 pos, @Nonnull class_2487 tag, String tagName) {
        class_2499 tagList = new class_2499();
        NbtWrap.addTag(tagList, (class_2520)NbtWrap.asIntTag(pos.method_10263()));
        NbtWrap.addTag(tagList, (class_2520)NbtWrap.asIntTag(pos.method_10264()));
        NbtWrap.addTag(tagList, (class_2520)NbtWrap.asIntTag(pos.method_10260()));
        NbtWrap.putTag(tag, tagName, (class_2520)tagList);
        return tag;
    }

    @Nonnull
    public static class_2487 writeVec3iToArray(@Nonnull class_2382 pos, @Nonnull class_2487 tag, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, tag, tagName);
    }

    @Nonnull
    public static class_2487 writeVec3iToArrayTag(@Nonnull class_2382 pos, @Nonnull class_2487 tag, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, tag, tagName);
    }

    @Nonnull
    public static class_2487 writeBlockPosToArrayTag(@Nonnull class_2382 pos, @Nonnull class_2487 tag, String tagName) {
        int[] arr = new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()};
        NbtWrap.putIntArray(tag, tagName, arr);
        return tag;
    }

    @Nullable
    public static class_2338 readBlockPos(@Nullable class_2487 tag) {
        if (tag != null && NbtWrap.containsInt(tag, "x") && NbtWrap.containsInt(tag, "y") && NbtWrap.containsInt(tag, "z")) {
            return new class_2338(NbtWrap.getInt(tag, "x"), NbtWrap.getInt(tag, "y"), NbtWrap.getInt(tag, "z"));
        }
        return null;
    }

    @Nullable
    public static class_2382 readVec3i(@Nullable class_2487 tag) {
        return NbtUtils.readVec3iFromTag(tag);
    }

    @Nullable
    public static class_2382 readVec3iFromTag(@Nullable class_2487 tag) {
        if (tag != null && NbtWrap.containsInt(tag, "x") && NbtWrap.containsInt(tag, "y") && NbtWrap.containsInt(tag, "z")) {
            return new class_2382(NbtWrap.getInt(tag, "x"), NbtWrap.getInt(tag, "y"), NbtWrap.getInt(tag, "z"));
        }
        return null;
    }

    @Nullable
    public static class_2338 readBlockPosFromListTag(@Nonnull class_2487 tag, String tagName) {
        class_2499 tagList;
        if (NbtWrap.containsList(tag, tagName) && NbtWrap.getListSize(tagList = NbtWrap.getList(tag, tagName, 3)) == 3) {
            return new class_2338(NbtWrap.getIntAt(tagList, 0), NbtWrap.getIntAt(tagList, 1), NbtWrap.getIntAt(tagList, 2));
        }
        return null;
    }

    @Nullable
    public static class_2338 readBlockPosFromIntArray(@Nonnull class_2487 nbt, String key) {
        return NbtUtils.readBlockPosFromArrayTag(nbt, key);
    }

    @Nullable
    public static class_2338 readBlockPosFromArrayTag(@Nonnull class_2487 tag, String tagName) {
        int[] pos;
        if (NbtWrap.containsIntArray(tag, tagName) && (pos = NbtWrap.getIntArray(tag, tagName)).length == 3) {
            return new class_2338(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Nullable
    public static class_2382 readVec3iFromIntArray(@Nonnull class_2487 nbt, String key) {
        return NbtUtils.readVec3iFromIntArrayTag(nbt, key);
    }

    @Nullable
    public static class_2382 readVec3iFromIntArrayTag(@Nonnull class_2487 tag, String tagName) {
        int[] pos;
        if (NbtWrap.containsIntArray(tag, tagName) && (pos = NbtWrap.getIntArray(tag, tagName)).length == 3) {
            return new class_2382(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Nonnull
    public static class_2487 removeBlockPos(@Nonnull class_2487 tag) {
        return NbtUtils.removeBlockPosFromTag(tag);
    }

    @Nonnull
    public static class_2487 removeBlockPosFromTag(@Nonnull class_2487 tag) {
        NbtWrap.remove(tag, "x");
        NbtWrap.remove(tag, "y");
        NbtWrap.remove(tag, "z");
        return tag;
    }

    @Nonnull
    public static class_2487 writeEntityPosition(@Nonnull class_243 pos, @Nonnull class_2487 tag) {
        return NbtUtils.writeVec3dToListTag(pos, tag, "Pos");
    }

    @Nonnull
    public static class_2487 writeEntityPositionToTag(@Nonnull class_243 pos, @Nonnull class_2487 tag) {
        return NbtUtils.writeVec3dToListTag(pos, tag, "Pos");
    }

    @Nonnull
    public static class_2487 writeVec3dToListTag(@Nonnull class_243 pos, @Nonnull class_2487 tag) {
        return NbtUtils.writeVec3dToListTag(pos, tag, "Pos");
    }

    @Nonnull
    public static class_2487 writeVec3dToListTag(@Nonnull class_243 pos, @Nonnull class_2487 tag, String tagName) {
        class_2499 posList = new class_2499();
        NbtWrap.addTag(posList, (class_2520)NbtWrap.asDoubleTag(pos.field_1352));
        NbtWrap.addTag(posList, (class_2520)NbtWrap.asDoubleTag(pos.field_1351));
        NbtWrap.addTag(posList, (class_2520)NbtWrap.asDoubleTag(pos.field_1350));
        NbtWrap.putTag(tag, tagName, (class_2520)posList);
        return tag;
    }

    @Nullable
    public static class_243 readVec3d(@Nullable class_2487 tag) {
        if (tag != null && NbtWrap.containsDouble(tag, "dx") && NbtWrap.containsDouble(tag, "dy") && NbtWrap.containsDouble(tag, "dz")) {
            return new class_243(NbtWrap.getDouble(tag, "dx"), NbtWrap.getDouble(tag, "dy"), NbtWrap.getDouble(tag, "dz"));
        }
        return null;
    }

    @Nullable
    public static class_243 readVec3dFromListTag(@Nullable class_2487 tag) {
        return NbtUtils.readVec3dFromListTag(tag, "Pos");
    }

    @Nullable
    public static class_243 readEntityPositionFromTag(@Nullable class_2487 tag) {
        return NbtUtils.readVec3dFromListTag(tag, "Pos");
    }

    @Nullable
    public static class_243 readVec3dFromListTag(@Nullable class_2487 tag, String tagName) {
        class_2499 tagList;
        if (tag != null && NbtWrap.containsList(tag, tagName) && NbtWrap.getListStoredType(tagList = NbtWrap.getList(tag, tagName, 6)) == 6 && NbtWrap.getListSize(tagList) == 3) {
            return new class_243(NbtWrap.getDoubleAt(tagList, 0), NbtWrap.getDoubleAt(tagList, 1), NbtWrap.getDoubleAt(tagList, 2));
        }
        return null;
    }

    @Nullable
    public static class_2338 readAttachedPosFromTag(@Nonnull class_2487 tag) {
        if (tag.method_10573("TileX", 3) && tag.method_10573("TileY", 3) && tag.method_10573("TileZ", 3)) {
            return new class_2338(tag.method_10550("TileX"), tag.method_10550("TileY"), tag.method_10550("TileZ"));
        }
        return null;
    }

    @Nonnull
    public static class_2487 writeAttachedPosToTag(@Nonnull class_2338 pos, @Nonnull class_2487 tag) {
        tag.method_10569("TileX", pos.method_10263());
        tag.method_10569("TileY", pos.method_10264());
        tag.method_10569("TileZ", pos.method_10260());
        return tag;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static class_2487 readNbtFromFile(@Nonnull File file) {
        return NbtUtils.readNbtFromFile(file, class_2505.method_53898());
    }

    @Nullable
    public static class_2487 readNbtFromFileAsPath(@Nonnull Path file) {
        return NbtUtils.readNbtFromFileAsPath(file, class_2505.method_53898());
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static class_2487 readNbtFromFile(@Nonnull File file, class_2505 tracker) {
        FileInputStream is;
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        try {
            is = new FileInputStream(file);
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("readNbtFromFile: Failed to read NBT data from file '{}' (failed to create the input stream)", (Object)file.getAbsolutePath());
            return null;
        }
        class_2487 nbt = null;
        if (is != null) {
            try {
                nbt = class_2507.method_10629((InputStream)is, (class_2505)tracker);
            }
            catch (Exception e) {
                try {
                    is.close();
                    is = new FileInputStream(file);
                    nbt = class_2507.method_10633((Path)file.toPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (nbt == null) {
            MaLiLib.LOGGER.warn("readNbtFromFile: Failed to read NBT data from file '{}'", (Object)file.getAbsolutePath());
        }
        return nbt;
    }

    @Nullable
    public static class_2487 readNbtFromFileAsPath(@Nonnull Path file, class_2505 tracker) {
        if (!Files.exists(file, new LinkOption[0]) || !Files.isReadable(file)) {
            return null;
        }
        try {
            return class_2507.method_10629((InputStream)Files.newInputStream(file, new OpenOption[0]), (class_2505)tracker);
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("readNbtFromFileAsPath: Failed to read NBT data from file '{}'", (Object)file.toString());
            return null;
        }
    }

    public static void writeCompressed(@Nonnull class_2487 tag, @Nonnull OutputStream outputStream) {
        try {
            class_2507.method_10634((class_2487)tag, (OutputStream)outputStream);
        }
        catch (Exception err) {
            MaLiLib.LOGGER.warn("writeCompressed: Failed to write NBT data to output stream");
        }
    }

    public static void writeCompressed(@Nonnull class_2487 tag, @Nonnull Path file) {
        try {
            class_2507.method_30614((class_2487)tag, (Path)file);
        }
        catch (Exception err) {
            MaLiLib.LOGGER.warn("writeCompressed: Failed to write NBT data to file");
        }
    }
}

