/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.customization;

import com.hidoni.customizableelytra.customization.ElytraCustomization;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.mixin.ItemStackInvoker;
import com.hidoni.customizableelytra.registry.ModDataComponents;
import com.hidoni.customizableelytra.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9307;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class CustomizationUtils {
    public static ElytraCustomization getElytraCustomization(class_1799 elytra) {
        if (!elytra.method_57826((class_9331)ModDataComponents.ELYTRA_CUSTOMIZATION.get())) {
            class_1799 emptyWing = new class_1799((class_1935)ModItems.ELYTRA_WING.get());
            return new ElytraCustomization(emptyWing, emptyWing);
        }
        return (ElytraCustomization)elytra.method_57824((class_9331)ModDataComponents.ELYTRA_CUSTOMIZATION.get());
    }

    public static List<class_2561> getElytraWingTooltipLines(class_1799 wing, class_1792.class_9635 tooltipContext, class_1836 tooltipFlag) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        class_1792 class_17922 = wing.method_7909();
        if (!(class_17922 instanceof CustomizableElytraItem)) {
            return lines;
        }
        CustomizableElytraItem item = (CustomizableElytraItem)class_17922;
        if (item.isCapeHidden(wing)) {
            CustomizationUtils.getCapeHiddenComponent(lines::add);
        }
        if (item.isGlowing(wing)) {
            CustomizationUtils.getGlowingComponent(lines::add);
        }
        if (item.hasBanner(wing)) {
            CustomizationUtils.getBannerComponents(wing, lines::add);
        }
        return lines;
    }

    private static void getCapeHiddenComponent(Consumer<class_2561> componentConsumer) {
        componentConsumer.accept((class_2561)class_2561.method_43471((String)"item.customizableelytra.cape_hidden").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
    }

    private static void getGlowingComponent(Consumer<class_2561> componentConsumer) {
        componentConsumer.accept((class_2561)class_2561.method_43471((String)"item.customizableelytra.glowing_wing").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
    }

    private static void getColorComponent(class_1799 wing, class_1792.class_9635 tooltipContext, class_1836 tooltipFlag, Consumer<class_2561> componentConsumer) {
        ((ItemStackInvoker)wing).invokeAddToTooltip(class_9334.field_49644, tooltipContext, componentConsumer, tooltipFlag);
    }

    private static void getBannerComponents(class_1799 wing, Consumer<class_2561> componentConsumer) {
        CustomizableElytraItem item = (CustomizableElytraItem)wing.method_7909();
        class_1767 baseColor = item.getBaseColor(wing);
        componentConsumer.accept((class_2561)class_2561.method_43471((String)("block.minecraft.banner.base." + baseColor.method_7792())).method_27692(class_124.field_1080));
        class_9307 bannerPatterns = item.getBannerPatterns(wing);
        for (class_9307.class_9308 layer : bannerPatterns.comp_2428()) {
            layer.comp_2429().method_40230().map(bannerPatternResourceKey -> bannerPatternResourceKey.method_29177().method_43903()).ifPresent(location -> {
                class_2960 bannerPatternLocation = class_2960.method_60654((String)location);
                componentConsumer.accept((class_2561)class_2561.method_43471((String)("block." + bannerPatternLocation.method_12836() + ".banner." + bannerPatternLocation.method_12832() + "." + layer.comp_2430().method_7792())).method_27692(class_124.field_1080));
            });
        }
    }

    private static void getArmorTrimComponents(class_1799 wing, class_1792.class_9635 tooltipContext, class_1836 tooltipFlag, Consumer<class_2561> componentConsumer) {
        ((ItemStackInvoker)wing).invokeAddToTooltip(class_9334.field_49607, tooltipContext, componentConsumer, tooltipFlag);
    }

    public static void addComponentsToLists(ElytraCustomization customization, List<class_2561> common, List<class_2561> left, List<class_2561> right, Predicate<class_1799> hasComponent, BiConsumer<class_1799, Consumer<class_2561>> componentProvider) {
        class_1799 leftWing = customization.leftWing();
        class_1799 rightWing = customization.rightWing();
        if (hasComponent.test(leftWing)) {
            ArrayList leftWingComponents = new ArrayList();
            componentProvider.accept(leftWing, leftWingComponents::add);
            if (hasComponent.test(rightWing)) {
                ArrayList rightWingComponents = new ArrayList();
                componentProvider.accept(rightWing, rightWingComponents::add);
                if (leftWingComponents.equals(rightWingComponents)) {
                    common.addAll(leftWingComponents);
                } else {
                    left.addAll(leftWingComponents);
                    right.addAll(rightWingComponents);
                }
            } else {
                left.addAll(leftWingComponents);
            }
        } else if (hasComponent.test(rightWing)) {
            componentProvider.accept(rightWing, right::add);
        }
    }

    public static List<class_2561> getElytraTooltipLines(class_1799 elytra, class_1792.class_9635 tooltipContext, class_1836 tooltipFlag) {
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(elytra);
        ArrayList<class_2561> leftWingLines = new ArrayList<class_2561>();
        ArrayList<class_2561> rightWingLines = new ArrayList<class_2561>();
        ArrayList<class_2561> outputLines = new ArrayList<class_2561>();
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.method_7909()).isGlowing((class_1799)stack), (stack, componentConsumer) -> CustomizationUtils.getGlowingComponent(componentConsumer));
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.method_7909()).isCapeHidden((class_1799)stack), (stack, componentConsumer) -> CustomizationUtils.getCapeHiddenComponent(componentConsumer));
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.method_7909()).isDyed((class_1799)stack), (stack, componentConsumer) -> CustomizationUtils.getColorComponent(stack, tooltipContext, tooltipFlag, componentConsumer));
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.method_7909()).hasBanner((class_1799)stack), CustomizationUtils::getBannerComponents);
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.method_7909()).hasArmorTrim((class_1799)stack), (stack, componentConsumer) -> CustomizationUtils.getArmorTrimComponents(stack, tooltipContext, tooltipFlag, componentConsumer));
        if (!leftWingLines.isEmpty()) {
            outputLines.add((class_2561)class_2561.method_43471((String)"item.customizableelytra.left_wing").method_27692(class_124.field_1080));
            outputLines.addAll(leftWingLines);
        }
        if (!rightWingLines.isEmpty()) {
            outputLines.add((class_2561)class_2561.method_43471((String)"item.customizableelytra.right_wing").method_27692(class_124.field_1080));
            outputLines.addAll(rightWingLines);
        }
        return outputLines;
    }
}

