/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.recipe;

import com.hidoni.customizableelytra.ElytraUtils;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.customization.ElytraCustomization;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.registry.ModDataComponents;
import com.hidoni.customizableelytra.registry.ModRecipes;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9331;
import net.minecraft.class_9694;
import org.jetbrains.annotations.NotNull;

public class ElytraMiscellaneousCustomizationRecipe
extends class_1852 {
    private static final class_1856 CUSTOMIZATION_INGREDIENT = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_28410, class_1802.field_8407});

    public ElytraMiscellaneousCustomizationRecipe(class_7710 category) {
        super(category);
    }

    public boolean matches(@NotNull class_9694 inv, @NotNull class_1937 level) {
        CustomizableElytraItem wingItem;
        class_1799 stack;
        class_1799 customizableStack = class_1799.field_8037;
        class_1799 modifierStack = class_1799.field_8037;
        for (int i = 0; i < inv.method_59983(); ++i) {
            stack = inv.method_59984(i);
            if (stack.method_7960()) continue;
            if (ElytraUtils.isElytra(stack) || stack.method_7909() instanceof CustomizableElytraItem) {
                if (!customizableStack.method_7960()) {
                    return false;
                }
                customizableStack = stack;
                continue;
            }
            if (!CUSTOMIZATION_INGREDIENT.method_8093(stack)) continue;
            if (!modifierStack.method_7960()) {
                return false;
            }
            modifierStack = stack;
        }
        if (customizableStack.method_7960() || modifierStack.method_7960()) {
            return false;
        }
        stack = customizableStack.method_7909();
        if (stack instanceof CustomizableElytraItem && ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(customizableStack, modifierStack, wingItem = (CustomizableElytraItem)stack)) {
            return false;
        }
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack);
        class_1799 leftWing = customization.leftWing();
        class_1799 rightWing = customization.rightWing();
        CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.method_7909();
        CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.method_7909();
        return !ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(leftWing, modifierStack, leftWingItem) || !ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(rightWing, modifierStack, rightWingItem);
    }

    @NotNull
    public class_1799 assemble(@NotNull class_9694 inv, @NotNull class_7225.class_7874 provider) {
        class_1799 stack;
        class_1799 customizableStack = class_1799.field_8037;
        class_1799 modifierStack = class_1799.field_8037;
        for (int i = 0; i < inv.method_59983(); ++i) {
            stack = inv.method_59984(i);
            if (stack.method_7960()) continue;
            if (ElytraUtils.isElytra(stack) || stack.method_7909() instanceof CustomizableElytraItem) {
                if (!customizableStack.method_7960()) {
                    return class_1799.field_8037;
                }
                customizableStack = stack.method_7972();
                continue;
            }
            if (!CUSTOMIZATION_INGREDIENT.method_8093(stack)) continue;
            if (!modifierStack.method_7960()) {
                return class_1799.field_8037;
            }
            modifierStack = stack;
        }
        if (customizableStack.method_7960() || modifierStack.method_7960()) {
            return class_1799.field_8037;
        }
        stack = customizableStack.method_7909();
        if (stack instanceof CustomizableElytraItem) {
            CustomizableElytraItem wingItem = (CustomizableElytraItem)stack;
            if (ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(customizableStack, modifierStack, wingItem)) {
                return class_1799.field_8037;
            }
            ElytraMiscellaneousCustomizationRecipe.modifyWing(customizableStack, modifierStack, wingItem);
        } else {
            ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack).copy();
            class_1799 leftWing = customization.leftWing();
            class_1799 rightWing = customization.rightWing();
            CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.method_7909();
            CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.method_7909();
            if (ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(leftWing, modifierStack, leftWingItem) && ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(rightWing, modifierStack, rightWingItem)) {
                return class_1799.field_8037;
            }
            ElytraMiscellaneousCustomizationRecipe.modifyWing(leftWing, modifierStack, (CustomizableElytraItem)leftWing.method_7909());
            ElytraMiscellaneousCustomizationRecipe.modifyWing(rightWing, modifierStack, (CustomizableElytraItem)rightWing.method_7909());
            customizableStack.method_57379((class_9331)ModDataComponents.ELYTRA_CUSTOMIZATION.get(), (Object)customization);
        }
        return customizableStack;
    }

    private static void modifyWing(class_1799 wingStack, class_1799 modifier, CustomizableElytraItem wingItem) {
        if (modifier.method_31574(class_1802.field_28410)) {
            wingItem.setGlowing(wingStack, true);
        } else {
            wingItem.setCapeHidden(wingStack, true);
        }
    }

    private static boolean isWingAlreadyCustomized(class_1799 wingStack, class_1799 modifier, CustomizableElytraItem wingItem) {
        if (modifier.method_31574(class_1802.field_28410)) {
            return wingItem.isGlowing(wingStack);
        }
        return wingItem.isCapeHidden(wingStack);
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)ModRecipes.ELYTRA_MISCELLANEOUS_CUSTOMIZATION_RECIPE.get();
    }
}

