/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.mixin.optimizations.fast_weather;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import me.flashyreese.mods.sodiumextra.client.render.vertex.formats.WeatherVertex;
import me.flashyreese.mods.sodiumextra.common.util.Utils;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2902;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_9801;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class}, priority=1500)
public class MixinLevelRenderer {
    @Shadow
    @Final
    private static class_2960 field_20797;
    @Shadow
    @Final
    private static class_2960 field_20798;
    @Unique
    private final Long2ReferenceMap<class_1959> biomeLong2ReferenceMap = new Long2ReferenceOpenHashMap();
    @Shadow
    @Final
    private class_310 field_4088;
    @Shadow
    private int field_4073;
    @Shadow
    @Final
    private float[] field_20794;
    @Shadow
    @Final
    private float[] field_20795;

    @Inject(method={"renderSnowAndRain"}, at={@At(value="HEAD")}, cancellable=true)
    public void sodiumExtra$renderWeather(class_765 lightTexture, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        assert (this.field_4088.field_1687 != null);
        float rainGradient = this.field_4088.field_1687.method_8430(tickDelta);
        if (rainGradient > 0.0f) {
            lightTexture.method_3316();
            class_638 world = this.field_4088.field_1687;
            int cameraPosX = class_3532.method_15357((double)cameraX);
            int cameraPosY = class_3532.method_15357((double)cameraY);
            int cameraPosZ = class_3532.method_15357((double)cameraZ);
            class_289 tessellator = class_289.method_1348();
            class_287 bufferBuilder = null;
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            int range = class_310.method_1517() ? 10 : 5;
            RenderSystem.depthMask((boolean)class_310.method_29611());
            int precipitationType = -1;
            float time = (float)this.field_4073 + tickDelta;
            RenderSystem.setShader(class_757::method_34546);
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int z = cameraPosZ - range; z <= cameraPosZ + range; ++z) {
                for (int x = cameraPosX - range; x <= cameraPosX + range; ++x) {
                    int positionIndex = (z - cameraPosZ + 16) * 32 + x - cameraPosX + 16;
                    double offsetX = (double)this.field_20794[positionIndex] * 0.5;
                    double offsetZ = (double)this.field_20795[positionIndex] * 0.5;
                    mutable.method_10102((double)x, cameraY, (double)z);
                    long biomePacked = Utils.packPosition(x, z);
                    class_1959 biome = (class_1959)this.biomeLong2ReferenceMap.computeIfAbsent(biomePacked, arg_0 -> MixinLevelRenderer.lambda$sodiumExtra$renderWeather$0((class_1937)world, mutable, arg_0));
                    if (!biome.method_48163()) continue;
                    int topY = world.method_8624(class_2902.class_2903.field_13197, x, z);
                    int minY = cameraPosY - range;
                    int maxY = cameraPosY + range;
                    if (minY < topY) {
                        minY = topY;
                    }
                    if (maxY < topY) {
                        maxY = topY;
                    }
                    int adjustedTopY = Math.max(topY, cameraPosY);
                    if (minY == maxY) continue;
                    class_5819 random = class_5819.method_43049((long)((long)x * (long)x * 3121L + (long)x * 45238971L ^ (long)z * (long)z * 418711L + (long)z * 13761L));
                    mutable.method_10103(x, minY, z);
                    class_1959.class_1963 precipitation = biome.method_48162((class_2338)mutable);
                    if (precipitation == class_1959.class_1963.field_9382) {
                        if (precipitationType != 0) {
                            if (precipitationType >= 0) {
                                class_286.method_43433((class_9801)bufferBuilder.method_60800());
                            }
                            precipitationType = 0;
                            RenderSystem.setShaderTexture((int)0, (class_2960)field_20797);
                            bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1584);
                        }
                        int ticksModulus = this.field_4073 & 0x1FFFF;
                        int randomOffset = x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0xFF;
                        float dropLength = 3.0f + random.method_43057();
                        float dropTimeOffset = -((float)(ticksModulus + randomOffset) + tickDelta) / 32.0f * dropLength;
                        float dropTextureOffset = dropTimeOffset % 32.0f;
                        double relativeX = (double)x + 0.5 - cameraX;
                        double relativeZ = (double)z + 0.5 - cameraZ;
                        float distance = (float)Math.sqrt(relativeX * relativeX + relativeZ * relativeZ) / (float)range;
                        float alpha = ((1.0f - distance * distance) * 0.5f + 0.5f) * rainGradient;
                        mutable.method_10103(x, adjustedTopY, z);
                        int color = ColorABGR.pack((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                        int light = class_761.method_23794((class_1920)world, (class_2338)mutable);
                        VertexBufferWriter writer = VertexBufferWriter.of((class_4588)bufferBuilder);
                        this.write(writer, cameraX, cameraY, cameraZ, x, z, offsetX, offsetZ, minY, maxY, 0.0f, dropTextureOffset, color, light);
                        continue;
                    }
                    if (precipitation != class_1959.class_1963.field_9383) continue;
                    if (precipitationType != 1) {
                        if (precipitationType >= 0) {
                            class_286.method_43433((class_9801)bufferBuilder.method_60800());
                        }
                        precipitationType = 1;
                        RenderSystem.setShaderTexture((int)0, (class_2960)field_20798);
                        bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1584);
                    }
                    float snowFallSpeed = -((float)(this.field_4073 & 0x1FF) + tickDelta) / 512.0f;
                    float snowTextureOffsetX = (float)(random.method_43058() + (double)time * 0.01 * (double)((float)random.method_43059()));
                    float snowTextureOffsetY = (float)(random.method_43058() + (double)(time * (float)random.method_43059()) * 0.001);
                    double relativeX = (double)x + 0.5 - cameraX;
                    double relativeZ = (double)z + 0.5 - cameraZ;
                    float distance = (float)Math.sqrt(relativeX * relativeX + relativeZ * relativeZ) / (float)range;
                    float alpha = ((1.0f - distance * distance) * 0.3f + 0.5f) * rainGradient;
                    mutable.method_10103(x, adjustedTopY, z);
                    int light = class_761.method_23794((class_1920)world, (class_2338)mutable);
                    int blockLight = light >> 16 & 0xFFFF;
                    int skyLight = light & 0xFFFF;
                    int adjustedBlockLight = (blockLight * 3 + 240) / 4;
                    int adjustedSkyLight = (skyLight * 3 + 240) / 4;
                    VertexBufferWriter writer = VertexBufferWriter.of((class_4588)bufferBuilder);
                    int color = ColorABGR.pack((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    int packedLight = Utils.packLight(adjustedSkyLight, adjustedBlockLight);
                    this.write(writer, cameraX, cameraY, cameraZ, x, z, offsetX, offsetZ, minY, maxY, snowTextureOffsetX, snowFallSpeed + snowTextureOffsetY, color, packedLight);
                }
            }
            if (precipitationType >= 0) {
                class_286.method_43433((class_9801)bufferBuilder.method_60800());
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightTexture.method_3315();
        }
        ci.cancel();
    }

    @Inject(method={"allChanged"}, at={@At(value="TAIL")})
    private void postReload(CallbackInfo ci) {
        this.biomeLong2ReferenceMap.clear();
    }

    @Unique
    private void write(VertexBufferWriter writer, double cameraX, double cameraY, double cameraZ, int x, int z, double offsetX, double offsetZ, int minY, int maxY, float textureOffsetX, float textureOffsetY, int color, int light) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(112);
            WeatherVertex.put(ptr, (float)((double)x - cameraX - offsetX + 0.5), (float)((double)maxY - cameraY), (float)((double)z - cameraZ - offsetZ + 0.5), 0.0f + textureOffsetX, (float)minY * 0.25f + textureOffsetY, color, light);
            WeatherVertex.put(ptr += 28L, (float)((double)x - cameraX + offsetX + 0.5), (float)((double)maxY - cameraY), (float)((double)z - cameraZ + offsetZ + 0.5), 1.0f + textureOffsetX, (float)minY * 0.25f + textureOffsetY, color, light);
            WeatherVertex.put(ptr += 28L, (float)((double)x - cameraX + offsetX + 0.5), (float)((double)minY - cameraY), (float)((double)z - cameraZ + offsetZ + 0.5), 1.0f + textureOffsetX, (float)maxY * 0.25f + textureOffsetY, color, light);
            WeatherVertex.put(ptr += 28L, (float)((double)x - cameraX - offsetX + 0.5), (float)((double)minY - cameraY), (float)((double)z - cameraZ - offsetZ + 0.5), 0.0f + textureOffsetX, (float)maxY * 0.25f + textureOffsetY, color, light);
            ptr += 28L;
            writer.push(stack, buffer, 4, WeatherVertex.FORMAT);
        }
    }

    private static /* synthetic */ class_1959 lambda$sodiumExtra$renderWeather$0(class_1937 world, class_2338.class_2339 mutable, long key) {
        return (class_1959)world.method_23753((class_2338)mutable).comp_349();
    }
}

