/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric.plugin;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.fabric.FabricCommandSender;
import me.lucko.spark.fabric.FabricPlatformInfo;
import me.lucko.spark.fabric.FabricSparkMod;
import me.lucko.spark.fabric.FabricTickHook;
import me.lucko.spark.fabric.FabricTickReporter;
import me.lucko.spark.fabric.FabricWorldInfoProvider;
import me.lucko.spark.fabric.mixin.MinecraftClientAccessor;
import me.lucko.spark.fabric.plugin.FabricSparkPlugin;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_2165;
import net.minecraft.class_310;
import net.minecraft.class_7157;

public class FabricClientSparkPlugin
extends FabricSparkPlugin
implements Command<FabricClientCommandSource>,
SuggestionProvider<FabricClientCommandSource> {
    private final class_310 minecraft;
    private final ThreadDumper.GameThread gameThreadDumper;

    public static void register(FabricSparkMod mod, class_310 client) {
        FabricClientSparkPlugin plugin = new FabricClientSparkPlugin(mod, client);
        plugin.enable();
    }

    public FabricClientSparkPlugin(FabricSparkMod mod, class_310 minecraft) {
        super(mod);
        this.minecraft = minecraft;
        this.gameThreadDumper = new ThreadDumper.GameThread(() -> ((MinecraftClientAccessor)minecraft).getThread());
    }

    @Override
    public void enable() {
        super.enable();
        ClientLifecycleEvents.CLIENT_STOPPING.register(this::onDisable);
        ClientCommandRegistrationCallback.EVENT.register(this::onCommandRegister);
    }

    private void onDisable(class_310 stoppingClient) {
        if (stoppingClient == this.minecraft) {
            this.disable();
        }
    }

    public void onCommandRegister(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        FabricClientSparkPlugin.registerCommands(dispatcher, this, this, "sparkc", "sparkclient");
    }

    public int run(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        String[] args = FabricClientSparkPlugin.processArgs(context, false, "sparkc", "sparkclient");
        if (args == null) {
            return 0;
        }
        this.platform.executeCommand(new FabricCommandSender((class_2165)((FabricClientCommandSource)context.getSource()).getEntity(), this), args);
        return 1;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String[] args = FabricClientSparkPlugin.processArgs(context, true, "/sparkc", "/sparkclient");
        if (args == null) {
            return Suggestions.empty();
        }
        return this.generateSuggestions(new FabricCommandSender((class_2165)((FabricClientCommandSource)context.getSource()).getEntity(), this), args, builder);
    }

    @Override
    public boolean hasPermission(class_2165 sender, String permission) {
        return true;
    }

    public Stream<FabricCommandSender> getCommandSenders() {
        return Stream.of(new FabricCommandSender((class_2165)this.minecraft.field_1724, this));
    }

    @Override
    public void executeSync(Runnable task) {
        this.minecraft.method_40000(task);
    }

    @Override
    public ThreadDumper getDefaultThreadDumper() {
        return this.gameThreadDumper.get();
    }

    @Override
    public TickHook createTickHook() {
        return new FabricTickHook.Client();
    }

    @Override
    public TickReporter createTickReporter() {
        return new FabricTickReporter.Client();
    }

    @Override
    public WorldInfoProvider createWorldInfoProvider() {
        return new FabricWorldInfoProvider.Client(this.minecraft);
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return new FabricPlatformInfo(PlatformInfo.Type.CLIENT);
    }

    @Override
    public String getCommandName() {
        return "sparkc";
    }
}

