/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.processor.small_nether_dungeon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.betterdungeons.world.DungeonContext;
import com.yungnickyoung.minecraft.betterdungeons.world.DungeonType;
import com.yungnickyoung.minecraft.yungsapi.world.banner.Banner;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1767;
import net.minecraft.class_2185;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import net.minecraft.class_7446;

@ParametersAreNonnullByDefault
@class_6328
public class SmallNetherDungeonBannerProcessor
extends class_3491 {
    public static final MapCodec<SmallNetherDungeonBannerProcessor> CODEC = RecordCodecBuilder.mapCodec(codecBuilder -> codecBuilder.group((App)Codec.STRING.fieldOf("dungeon_type").forGetter(processor -> processor.getDungeonType().getName())).apply((Applicative)codecBuilder, codecBuilder.stable(SmallNetherDungeonBannerProcessor::new)));
    private final DungeonType dungeonType;
    public static final Banner SKELETON_BANNER = new Banner.Builder().blockState(class_2246.field_10537.method_9564()).pattern(class_7446.field_39141, class_1767.field_7952).pattern(class_7446.field_39160, class_1767.field_7952).pattern(class_7446.field_39156, class_1767.field_7963).pattern(class_7446.field_39157, class_1767.field_7952).pattern(class_7446.field_39146, class_1767.field_7952).pattern(class_7446.field_39142, class_1767.field_7963).customName("Vengeful Banner").customColor("dark_gray").build();
    public static final Banner WITHER_SKELETON_BANNER = new Banner.Builder().blockState(class_2246.field_10279.method_9564()).pattern(class_7446.field_39141, class_1767.field_7963).pattern(class_7446.field_39160, class_1767.field_7963).pattern(class_7446.field_39156, class_1767.field_7964).pattern(class_7446.field_39146, class_1767.field_7963).pattern(class_7446.field_39157, class_1767.field_7963).pattern(class_7446.field_39143, class_1767.field_7963).customName("Banner of Decay").customColor("dark_purple").build();
    public static final Banner ZOMBIFIED_PIGLIN_BANNER = new Banner.Builder().blockState(class_2246.field_10531.method_9564()).pattern(class_7446.field_39158, class_1767.field_7942).pattern(class_7446.field_39170, class_1767.field_7963).pattern(class_7446.field_39170, class_1767.field_7954).pattern(class_7446.field_39160, class_1767.field_7954).pattern(class_7446.field_39138, class_1767.field_7967).pattern(class_7446.field_39172, class_1767.field_7942).pattern(class_7446.field_39146, class_1767.field_7952).pattern(class_7446.field_39139, class_1767.field_7954).pattern(class_7446.field_39176, class_1767.field_7954).pattern(class_7446.field_39150, class_1767.field_7963).pattern(class_7446.field_39143, class_1767.field_7954).pattern(class_7446.field_39156, class_1767.field_7963).customName("Banner of Pork").customColor("light_purple").build();
    public static final Banner BLAZE_BANNER = new Banner.Builder().blockState(class_2246.field_10279.method_9564()).pattern(class_7446.field_39164, class_1767.field_7947).pattern(class_7446.field_39168, class_1767.field_7964).pattern(class_7446.field_39168, class_1767.field_7964).pattern(class_7446.field_39148, class_1767.field_7946).pattern(class_7446.field_39147, class_1767.field_7947).pattern(class_7446.field_39141, class_1767.field_7964).pattern(class_7446.field_39143, class_1767.field_7963).customName("Banner of Rage").customColor("gold").build();

    private SmallNetherDungeonBannerProcessor(String dungeonType) {
        this.dungeonType = DungeonType.fromString(dungeonType);
    }

    public DungeonType getDungeonType() {
        return this.dungeonType;
    }

    public class_3499.class_3501 method_15110(class_4538 levelReader, class_2338 jigsawPiecePos, class_2338 jigsawPieceBottomCenterPos, class_3499.class_3501 blockInfoLocal, class_3499.class_3501 blockInfoGlobal, class_3492 structurePlacementData) {
        if (blockInfoGlobal.comp_1342().method_26204() instanceof class_2185 && blockInfoGlobal.comp_1342().method_26204() == class_2246.field_10267 && (blockInfoGlobal.comp_1343().method_10580("patterns") == null || blockInfoGlobal.comp_1343().method_10554("patterns", 10).isEmpty())) {
            DungeonContext context = DungeonContext.peek();
            if (context.getBannerCount() >= BetterDungeonsCommon.CONFIG.smallNetherDungeons.bannerMaxCount) {
                return new class_3499.class_3501(blockInfoGlobal.comp_1341(), class_2246.field_10124.method_9564(), null);
            }
            class_5819 random = structurePlacementData.method_15115(blockInfoGlobal.comp_1341());
            if (random.method_43057() > 0.1f) {
                return new class_3499.class_3501(blockInfoGlobal.comp_1341(), class_2246.field_10124.method_9564(), null);
            }
            Banner banner = this.getBannerForType();
            class_2350 facing = (class_2350)blockInfoGlobal.comp_1342().method_11654((class_2769)class_2741.field_12481);
            class_2680 newState = (class_2680)banner.getState().method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
            class_2487 newNBT = this.copyNBT(banner.getNbt());
            blockInfoGlobal = new class_3499.class_3501(blockInfoGlobal.comp_1341(), newState, newNBT);
            context.incrementBannerCount();
        }
        return blockInfoGlobal;
    }

    protected class_3828<?> method_16772() {
        return StructureProcessorTypeModule.SMALL_NETHER_DUNGEON_BANNER_PROCESSOR;
    }

    private Banner getBannerForType() {
        return switch (this.dungeonType) {
            case DungeonType.SKELETON -> SKELETON_BANNER;
            case DungeonType.ZOMBIFIED_PIGLIN -> ZOMBIFIED_PIGLIN_BANNER;
            case DungeonType.WITHER_SKELETON -> WITHER_SKELETON_BANNER;
            case DungeonType.BLAZE -> BLAZE_BANNER;
            default -> {
                BetterDungeonsCommon.LOGGER.warn("Invalid DungeonType {} for small_nether_dungeon_banner_processor! This shouldn't happen!", (Object)this.dungeonType);
                yield SKELETON_BANNER;
            }
        };
    }

    private class_2487 copyNBT(class_2487 other) {
        class_2487 nbt = new class_2487();
        nbt.method_10543(other);
        return nbt;
    }
}

