/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher;

import io.sigpipe.jbsdiff.InvalidHeaderException;
import io.sigpipe.jbsdiff.ui.FileUI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import mc.euphoria_patches.euphoria_patcher.ArchiveUtils;
import mc.euphoria_patches.euphoria_patcher.features.ModFolderVersionChecker;
import mc.euphoria_patches.euphoria_patcher.features.ModifyOutdatedPatches;
import mc.euphoria_patches.euphoria_patcher.features.ModifyPatchedShaderpacks;
import mc.euphoria_patches.euphoria_patcher.features.UpdateShaderConfig;
import mc.euphoria_patches.euphoria_patcher.features.UpdateShaderLoaderConfig;
import mc.euphoria_patches.euphoria_patcher.util.Config;
import mc.euphoria_patches.euphoria_patcher.util.JsonUtilReader;
import mc.euphoria_patches.euphoria_patcher.util.ModLoaderSpecifics;
import mc.euphoria_patches.euphoria_patcher.util.SodiumConsole;
import mc.euphoria_patches.euphoria_patcher.util.UpdateChecker;
import mc.euphoria_patches.euphoria_patcher.util.UsefulFunctions;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EuphoriaPatcher {
    private static final boolean IS_DEV = false;
    private static final boolean isDevModLoader = ModLoaderSpecifics.isDevMode;
    public static final String BRAND_NAME = "Complementary";
    public static final String PATCH_NAME = "EuphoriaPatches";
    public static final String VERSION = "_r5.4";
    public static final String PATCH_VERSION = "_1.5.2";
    private static final String BASE_TAR_HASH = "d2c7b2d30a992623e6b23cdecf7f997b";
    private static final int BASE_TAR_SIZE = 1328640;
    public static final String DOWNLOAD_URL = "https://www.complementary.dev/";
    public static final String COMMON_LOCATION = "shaders/lib/common.glsl";
    public static final String LANG_LOCATION = "shaders/lang";
    public static final String SHADERS_PROPERTIES_LOCATION = "shaders/shaders.properties";
    public static Path shaderpacks = ModLoaderSpecifics.shaderpacks;
    public static Path configDirectory = ModLoaderSpecifics.configDirectory;
    public static Path mainIntellijDir = shaderpacks.getParent().getParent();
    public static Path modDirectory = shaderpacks.getParent().resolve("mods");
    public static boolean doPopUpLogging = true;
    public static boolean doUpdateChecking = true;
    public static boolean doRenameOldShaderFiles = true;
    public static boolean doDeleteOldShaderFiles = false;
    public static Logger LOGGER = LogManager.getLogger((String)"euphoriaPatches");
    public static boolean isSodiumInstalled = false;
    private static boolean ALREADY_LAUNCHED = false;
    private static boolean IS_BASE_MESSAGE_SHOWN = false;

    public EuphoriaPatcher() {
        if (ALREADY_LAUNCHED) {
            return;
        }
        ALREADY_LAUNCHED = true;
        System.out.println("\nEuphoria Patcher:");
        if (ModFolderVersionChecker.existsNewerModInFolder()) {
            return;
        }
        this.configStuff();
        if (doPopUpLogging) {
            this.isSodiumInstalled();
        }
        if (doUpdateChecking) {
            UpdateChecker.checkForUpdates();
        }
        EuphoriaPatcher.log(0, JsonUtilReader.getRandomMessage("startupMessages"));
        ShaderInfo shaderInfo = this.detectInstalledShaders();
        if (!shaderInfo.isAlreadyInstalled) {
            if (shaderInfo.baseFile == null) {
                this.installBaseMessage();
                if (!EuphoriaPatcher.isDevFunc()) {
                    return;
                }
            }
        } else {
            this.thankYouMessage(shaderInfo.baseFile, shaderInfo.styleUnbound, shaderInfo.styleReimagined);
            return;
        }
        Path temp = this.createTempDirectory();
        if (temp == null || shaderInfo.baseFile == null && !EuphoriaPatcher.isDevFunc()) {
            return;
        }
        if (!this.processAndPatchShaders(shaderInfo, temp)) {
            return;
        }
        UpdateShaderConfig.updateShaderTxtConfigFile(shaderInfo.styleUnbound, shaderInfo.styleReimagined);
        UpdateShaderLoaderConfig.updateShaderLoaderConfig(shaderInfo.styleUnbound, shaderInfo.styleReimagined);
        if (doDeleteOldShaderFiles) {
            ModifyOutdatedPatches.delete();
        }
        if (doRenameOldShaderFiles) {
            ModifyOutdatedPatches.rename();
        }
        this.thankYouMessage(shaderInfo.baseFile, shaderInfo.styleUnbound, shaderInfo.styleReimagined);
    }

    private void configStuff() {
        doPopUpLogging = Boolean.parseBoolean(Config.readWriteConfig("doPopUpLogging", "true", "Option for the sodium message popup logging.\nDefault = true"));
        doUpdateChecking = Boolean.parseBoolean(Config.readWriteConfig("doUpdateChecking", "true", "Option that enables or disables the update checker, which verifies if a new version of the mod is available.\nMore info here: https://github.com/EuphoriaPatches/PatcherUpdateChecker\nDefault = true"));
        doRenameOldShaderFiles = Boolean.parseBoolean(Config.readWriteConfig("doRenameOldShaderFiles", "true", "Option that automatically renames outdated Euphoria Patches folders and config files to a new name.\nThis makes it easier for users to identify which ones are outdated.\nDefault = true"));
        doDeleteOldShaderFiles = Boolean.parseBoolean(Config.readWriteConfig("doDeleteOldShaderFiles", "false", "Option that automatically deleted outdated Euphoria Patches folders and config files.\nDefault = false"));
    }

    private void isSodiumInstalled() {
        String sodiumVersion = "me.jellysquid.mods.sodium.client.gui.console.Console";
        try {
            Class.forName(sodiumVersion);
            EuphoriaPatcher.log(0, "Sodium found, using Sodium logging!");
            isSodiumInstalled = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void log(int messageLevel, int messageFadeTimer, String message) {
        String loggingMessage = "EuphoriaPatcher: " + message;
        if (messageLevel == -1) {
            loggingMessage = "\n\n" + loggingMessage + "\n";
        }
        if (isSodiumInstalled && messageFadeTimer > 0) {
            SodiumConsole.logMessage(messageLevel, messageFadeTimer, loggingMessage);
        }
        switch (messageLevel) {
            case -1: 
            case 0: 
            case 1: {
                LOGGER.info(loggingMessage);
                break;
            }
            case 2: {
                LOGGER.warn(loggingMessage);
                break;
            }
            case 3: {
                LOGGER.error(loggingMessage);
                break;
            }
            default: {
                System.out.println(loggingMessage);
            }
        }
    }

    public static void log(int messageLevel, String message) {
        int messageFadeTimer = 0;
        switch (messageLevel) {
            case 1: {
                messageFadeTimer = 4;
                break;
            }
            case 2: {
                messageFadeTimer = 8;
                break;
            }
            case 3: {
                messageFadeTimer = 16;
            }
        }
        EuphoriaPatcher.log(messageLevel, messageFadeTimer, message);
    }

    public static boolean isDevFunc() {
        return false;
    }

    private ShaderInfo detectInstalledShaders() {
        ShaderInfo info = new ShaderInfo();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(shaderpacks, this::isComplementaryShader);){
            for (Path potentialFile : stream) {
                this.processShaderFile(potentialFile, info);
                if (!info.styleReimagined || !info.styleUnbound) continue;
                break;
            }
            if (!info.styleReimagined && !info.styleUnbound) {
                this.detectInstalledDirectories(info);
            }
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Error reading shaderpacks directory: " + e.getMessage());
        }
        return info;
    }

    private boolean isComplementaryShader(Path path) {
        String name = path.getFileName().toString();
        return name.matches("Complementary.*_r5.4.*") && name.endsWith(".zip") && !name.contains(PATCH_NAME);
    }

    private void processShaderFile(Path file, ShaderInfo info) {
        String name = file.getFileName().toString();
        if (name.contains("Reimagined")) {
            info.styleReimagined = true;
            if (info.baseFile == null) {
                info.baseFile = file;
            }
        } else if (name.contains("Unbound")) {
            info.styleUnbound = true;
            if (info.baseFile == null) {
                info.baseFile = file;
            }
        }
        this.checkIfAlreadyInstalled(file, info);
    }

    private void checkIfAlreadyInstalled(Path file, ShaderInfo info) {
        Path potentialInstallPath = file.resolveSibling(file.getFileName().toString().replace(".zip", "") + " + " + PATCH_NAME + PATCH_VERSION);
        if (info.baseFile != null && Files.exists(potentialInstallPath, new LinkOption[0]) && !EuphoriaPatcher.isDevFunc() && !info.isAlreadyInstalled) {
            try {
                boolean containsEuphoriaFile = Files.walk(potentialInstallPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).anyMatch(p -> p.getFileName().toString().contains(PATCH_NAME));
                if (!containsEuphoriaFile) {
                    EuphoriaPatcher.log(0, "Found incomplete installation. Cleaning up " + potentialInstallPath.getFileName());
                    UsefulFunctions.deleteRecursively(potentialInstallPath);
                    info.isAlreadyInstalled = false;
                } else {
                    info.isAlreadyInstalled = true;
                    EuphoriaPatcher.log(0, "EuphoriaPatches_1.5.2 is already installed.");
                }
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, "Error checking installation status. Cleaning up: " + e.getMessage());
                try {
                    UsefulFunctions.deleteRecursively(potentialInstallPath);
                }
                catch (IOException ex) {
                    EuphoriaPatcher.log(3, "Error deleting directory: " + ex.getMessage());
                }
                info.isAlreadyInstalled = false;
            }
        }
    }

    private void thankYouMessage(Path baseFile, boolean styleUnbound, boolean styleReimagined) {
        if (UpdateChecker.NEW_VERSION_AVAILABLE && doUpdateChecking && baseFile != null) {
            try {
                Path shader = baseFile.resolveSibling(baseFile.getFileName().toString().replace(".zip", "") + " + " + PATCH_NAME + PATCH_VERSION);
                ModifyPatchedShaderpacks.modifyShadersProperties(shader, styleUnbound, styleReimagined, "screen=<empty> <empty>", "screen=info19 info20");
                ModifyPatchedShaderpacks.modifyLangFiles(shader, styleUnbound, styleReimagined, "value\\.info19\\.0=.*", "value.info19.0=\u00a7c" + PATCH_VERSION.replace("_", "") + " \u00a7r->\u00a7a " + UpdateChecker.NEW_MOD_VERSION);
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, 0, "Could not modify the shader to show the user that a new version is available" + e.getMessage());
            }
        }
        if (shaderpacks.toString().contains("SpacEagle")) {
            EuphoriaPatcher.log(1, "Have fun developing Euphoria Patches!\n");
        } else {
            EuphoriaPatcher.log(-1, "Thank you for using Euphoria Patches - SpacEagle17");
        }
    }

    private void installBaseMessage() {
        if (IS_BASE_MESSAGE_SHOWN) {
            return;
        }
        IS_BASE_MESSAGE_SHOWN = true;
        EuphoriaPatcher.log(3, 8, "You need to have ComplementaryShaders_r5.4 installed!");
        EuphoriaPatcher.log(3, 8, "Please download it from https://www.complementary.dev/, place it into your shaderpacks folder and restart Minecraft!");
    }

    private void detectInstalledDirectories(ShaderInfo info) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(shaderpacks, this::isComplementaryShaderDirectory);){
            for (Path potentialFile : stream) {
                this.processShaderDirectory(potentialFile, info);
                if (!info.styleReimagined || !info.styleUnbound) continue;
                break;
            }
        }
    }

    private boolean isComplementaryShaderDirectory(Path path) {
        return path.getFileName().toString().matches("Complementary.*_r5.4.*") && Files.isDirectory(path, new LinkOption[0]);
    }

    private void processShaderDirectory(Path directory, ShaderInfo info) {
        String name = directory.getFileName().toString();
        if (name.contains(PATCH_NAME)) {
            if (name.contains("EuphoriaPatches_1.5.2") && !info.isAlreadyInstalled) {
                info.isAlreadyInstalled = true;
                EuphoriaPatcher.log(0, "EuphoriaPatches_1.5.2 is already installed.");
            }
            return;
        }
        if (name.contains("Reimagined")) {
            info.styleReimagined = true;
            if (info.baseFile == null) {
                info.baseFile = directory;
            }
        } else if (name.contains("Unbound")) {
            info.styleUnbound = true;
            if (info.baseFile == null) {
                info.baseFile = directory;
            }
        }
    }

    private Path createTempDirectory() {
        try {
            return Files.createTempDirectory("euphoria-patcher-", new FileAttribute[0]);
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Error creating temporary directory: " + e.getMessage());
            return null;
        }
    }

    private boolean processAndPatchShaders(ShaderInfo info, Path temp) {
        if (info.baseFile == null && !EuphoriaPatcher.isDevFunc()) {
            this.installBaseMessage();
            return false;
        }
        String baseName = info.baseFile.getFileName().toString().replace(".zip", "");
        String patchedName = baseName + " + " + PATCH_NAME + PATCH_VERSION;
        Path baseExtracted = this.extractBase(info.baseFile, temp, baseName);
        if (baseExtracted == null) {
            return false;
        }
        if (!this.updateCommonFile(baseExtracted)) {
            return false;
        }
        Path baseArchived = this.archiveBase(baseExtracted, temp, baseName);
        if (!this.verifyBaseArchive(baseArchived)) {
            return false;
        }
        boolean result = this.applyPatch(baseArchived, temp, patchedName, info.styleUnbound, info.styleReimagined);
        try {
            EuphoriaPatcher.log(0, "Cleaning up the temporary directory...");
            FileUtils.deleteDirectory((File)temp.toFile());
        }
        catch (IOException e) {
            EuphoriaPatcher.log(2, "Error cleaning up temporary directory: " + e.getMessage());
        }
        return result;
    }

    private Path extractBase(Path baseFile, Path temp, String baseName) {
        Path baseExtracted = temp.resolve(baseName);
        if (!Files.isDirectory(baseFile, new LinkOption[0])) {
            try {
                ArchiveUtils.extract(baseFile, baseExtracted);
            }
            catch (IOException | ArchiveException e) {
                EuphoriaPatcher.log(2, "Error extracting archive: " + e.getMessage());
            }
        } else {
            baseExtracted = baseFile;
        }
        return baseExtracted;
    }

    private boolean updateCommonFile(Path baseExtracted) {
        try {
            Path commons = baseExtracted.resolve(COMMON_LOCATION);
            String config = FileUtils.readFileToString((File)commons.toFile(), (String)"UTF-8").replaceFirst("SHADER_STYLE [14]", "SHADER_STYLE 1");
            FileUtils.writeStringToFile((File)commons.toFile(), (String)config, (String)"UTF-8");
            return true;
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Error extracting style information: " + e.getMessage());
            return false;
        }
    }

    private Path archiveBase(Path baseExtracted, Path temp, String baseName) {
        Path baseArchived = temp.resolve(baseName + ".tar");
        try {
            ArchiveUtils.archive(baseExtracted, baseArchived);
        }
        catch (IOException e) {
            EuphoriaPatcher.log(2, "Error extracting archive: " + e.getMessage());
        }
        return baseArchived;
    }

    private boolean verifyBaseArchive(Path baseArchived) {
        try {
            if (EuphoriaPatcher.isDevFunc()) {
                String hash = DigestUtils.md5Hex((InputStream)Files.newInputStream(baseArchived, new OpenOption[0]));
                EuphoriaPatcher.log(0, "Hash of base: " + hash);
                EuphoriaPatcher.log(0, FileUtils.sizeOf((File)baseArchived.toFile()) + " bytes");
            } else {
                String hash = DigestUtils.md5Hex((byte[])Arrays.copyOf(Files.readAllBytes(baseArchived), 1328640));
                if (!hash.equals(BASE_TAR_HASH)) {
                    EuphoriaPatcher.log(3, 8, "The shader ComplementaryShaders that was found in your shaderpacks folder can't be used as a base for EuphoriaPatches");
                    EuphoriaPatcher.log(3, 8, "Please download ComplementaryShaders_r5.4 from https://www.complementary.dev/, place it into your shaderpacks folder and restart Minecraft.");
                    if (baseArchived.getFileName().toString().matches("Complementary.*_r5.4.*")) {
                        EuphoriaPatcher.log(3, 8, "Correct Shader Version Found. BUT it might have been modified. The expected hash does not match.");
                    } else {
                        EuphoriaPatcher.log(3, 8, "Incorrect Shader Version found or unexpected error. The expected hash does not match.");
                    }
                    return false;
                }
            }
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, "Something went wrong during the hash verification" + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean applyPatch(Path baseArchived, Path temp, String patchedName, boolean styleUnbound, boolean styleReimagined) {
        Path patchedArchive = temp.resolve(patchedName + ".tar");
        Path patchedFile = shaderpacks.resolve(patchedName);
        if (EuphoriaPatcher.isDevFunc()) {
            Path resourcesDir = mainIntellijDir.resolve("src/main/resources");
            Path patchDir = mainIntellijDir.resolve("EuphoriaPatchFiles");
            return this.devPatchFilePrep(resourcesDir, baseArchived, patchedFile, patchedArchive) && this.devPatchFilePrep(patchDir, baseArchived, patchedFile, patchedArchive);
        }
        Path patchFile = temp.resolve(patchedName + ".patch");
        return this.applyProductionPatch(baseArchived, patchedArchive, patchFile, patchedFile, styleUnbound, styleReimagined);
    }

    private boolean devPatchFilePrep(Path buildDir, Path baseArchived, Path patchedFile, Path patchedArchive) {
        this.checkBuildPath(buildDir);
        Path patchFile = buildDir.resolve("EuphoriaPatches_1.5.2.patch");
        return this.createDevPatch(baseArchived, patchedFile, patchedArchive, patchFile);
    }

    private void checkBuildPath(Path buildDir) {
        if (!Files.exists(buildDir, new LinkOption[0])) {
            try {
                Files.createDirectories(buildDir, new FileAttribute[0]);
                EuphoriaPatcher.log(2, "Build directory created successfully: " + buildDir);
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, "Failed to create directory: " + e.getMessage());
            }
        }
    }

    private boolean createDevPatch(Path baseArchived, Path patchedFile, Path patchedArchive, Path patchFile) {
        try {
            ArchiveUtils.archive(patchedFile, patchedArchive);
            FileUI.diff((File)baseArchived.toFile(), (File)patchedArchive.toFile(), (File)patchFile.toFile());
            EuphoriaPatcher.log(0, ".patch file successfully created in " + patchFile + "!");
            return true;
        }
        catch (InvalidHeaderException | IOException | CompressorException e) {
            EuphoriaPatcher.log(3, "Error creating dev patch: " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean applyProductionPatch(Path baseArchived, Path patchedArchive, Path patchFile, Path patchedFile, boolean styleUnbound, boolean styleReimagined) {
        try (InputStream patchStream = this.getClass().getClassLoader().getResourceAsStream("EuphoriaPatches_1.5.2.patch");){
            if (patchStream == null) return false;
            FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(patchStream), (File)patchFile.toFile());
            FileUI.patch((File)baseArchived.toFile(), (File)patchedArchive.toFile(), (File)patchFile.toFile());
            try {
                ArchiveUtils.extract(patchedArchive, patchedFile);
            }
            catch (IOException | ArchiveException e) {
                EuphoriaPatcher.log(2, "Error extracting archive: " + e.getMessage());
            }
            this.applyStyleSettings(patchedFile, styleUnbound, styleReimagined);
            EuphoriaPatcher.log(1, "EuphoriaPatches was successfully installed. Enjoy! -SpacEagle17");
            boolean bl = true;
            return bl;
        }
        catch (InvalidHeaderException | IOException | CompressorException e) {
            EuphoriaPatcher.log(3, "Error applying patch file: " + e.getMessage());
        }
        return false;
    }

    private void applyStyleSettings(Path patchedFile, boolean styleUnbound, boolean styleReimagined) throws IOException {
        if (styleUnbound) {
            File commons = new File(patchedFile.toFile(), COMMON_LOCATION);
            String unboundConfig = FileUtils.readFileToString((File)commons, (String)"UTF-8").replaceFirst("SHADER_STYLE 1", "SHADER_STYLE 4");
            if (!styleReimagined) {
                FileUtils.writeStringToFile((File)commons, (String)unboundConfig, (String)"UTF-8");
            } else if (patchedFile.getFileName().toString().contains("Reimagined")) {
                File unbound = new File(patchedFile.getParent().toFile(), patchedFile.getFileName().toString().replace("Reimagined", "Unbound"));
                FileUtils.copyDirectory((File)patchedFile.toFile(), (File)unbound);
                FileUtils.writeStringToFile((File)new File(unbound, COMMON_LOCATION), (String)unboundConfig, (String)"UTF-8");
            } else {
                File reimagined = new File(patchedFile.getParent().toFile(), patchedFile.getFileName().toString().replace("Unbound", "Reimagined"));
                FileUtils.copyDirectory((File)patchedFile.toFile(), (File)reimagined);
                FileUtils.writeStringToFile((File)commons, (String)unboundConfig, (String)"UTF-8");
            }
        }
    }

    private static class ShaderInfo {
        Path baseFile = null;
        boolean styleReimagined = false;
        boolean styleUnbound = false;
        boolean isAlreadyInstalled = false;

        private ShaderInfo() {
        }
    }
}

