/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.cicada.api.conversation;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import nl.enjarai.cicada.Cicada;
import nl.enjarai.cicada.api.conversation.Conversation;
import nl.enjarai.cicada.api.conversation.Line;
import nl.enjarai.cicada.api.conversation.SimpleLine;
import nl.enjarai.cicada.api.conversation.conditions.LineCondition;
import nl.enjarai.cicada.api.util.CicadaEntrypoint;
import nl.enjarai.cicada.api.util.JsonSource;
import nl.enjarai.cicada.api.util.random.RandomUtil;

public class ConversationManager {
    private static final ExecutorService THREAD_POOL = Executors.newFixedThreadPool(10, new ThreadFactoryBuilder().setNameFormat("Cicada thread %d").setThreadFactory(Executors.defaultThreadFactory()).setDaemon(true).build());
    private final Map<JsonSource, Consumer<String>> jsonSources = new HashMap<JsonSource, Consumer<String>>();
    private final Map<String, Conversation> conversations = new ConcurrentHashMap<String, Conversation>();

    public static ExecutorService getThreadPool() {
        return THREAD_POOL;
    }

    public void init() {
        FabricLoader.getInstance().getEntrypoints("cicada", CicadaEntrypoint.class).forEach(entrypoint -> entrypoint.registerConversations(this));
        this.getConversationsFuture(this.jsonSources).join();
        this.conversations.values().forEach(Conversation::complete);
    }

    public void run() {
        RandomUtil.chooseWeighted(this.conversations.values().stream().filter(Conversation::shouldRun).toList()).ifPresent(Conversation::run);
    }

    public void registerSource(JsonSource source, Consumer<String> logger) {
        this.jsonSources.put(source, logger);
    }

    @Deprecated
    public void registerUrlSource(String url, Consumer<String> logger) {
        this.registerSource(JsonSource.fromUrl(url), logger);
    }

    @Deprecated
    public void registerFileSource(Path path, Consumer<String> logger) {
        this.registerSource(JsonSource.fromFile(path), logger);
    }

    public Conversation getOrCreateConversation(String id) {
        Conversation conversation = this.conversations.get(id);
        if (conversation == null) {
            conversation = new Conversation(this);
            this.conversations.put(id, conversation);
        }
        return conversation;
    }

    protected void onLoadError(Exception e) {
        Cicada.LOGGER.debug("Failed to load conversation source", (Throwable)e);
    }

    private CompletableFuture<Void> getConversationsFuture(Map<JsonSource, Consumer<String>> sources) {
        return CompletableFuture.allOf((CompletableFuture[])sources.entrySet().stream().map(entry -> CompletableFuture.runAsync(() -> ((JsonSource)entry.getKey()).getSafely(this::onLoadError).ifPresent(json -> {
            try {
                this.decodeSideJson((JsonObject)json, line -> {
                    if (line instanceof SimpleLine) {
                        SimpleLine simpleLine = (SimpleLine)line;
                        simpleLine.setSourceLogger((Consumer)entry.getValue());
                    }
                });
            }
            catch (Exception e) {
                this.onLoadError(e);
            }
        }), THREAD_POOL)).toArray(CompletableFuture[]::new));
    }

    private void decodeSideJson(JsonObject json, Consumer<Line> lineModifier) {
        String modId = json.has("mod_id") ? json.get("mod_id").getAsString() : null;
        json.getAsJsonObject("conversations").entrySet().forEach(entry -> {
            Conversation conversation = this.getOrCreateConversation((String)entry.getKey());
            JsonObject conversationJson = ((JsonElement)entry.getValue()).getAsJsonObject();
            if (conversationJson.has("condition")) {
                conversation.addCondition((LineCondition)LineCondition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)conversationJson.get("condition")).getOrThrow());
            }
            if (conversationJson.has("priority")) {
                JsonObject priority = conversationJson.getAsJsonObject("priority");
                int convoPriority = priority.get("priority").getAsInt();
                int convoPriorityOverride = priority.has("override") ? priority.get("override").getAsInt() : 100;
                conversation.addPriority(convoPriority, convoPriorityOverride);
            }
            conversationJson.getAsJsonArray("lines").forEach(jsonElement -> {
                JsonObject lineJson = jsonElement.getAsJsonObject();
                SimpleLine line = (SimpleLine)SimpleLine.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)lineJson).getOrThrow();
                line.setConversation(conversation);
                lineModifier.accept(line);
                conversation.addLine(line);
            });
            conversation.addParticipantCount(1);
            conversation.addParticipant(modId);
        });
    }
}

