/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.linusdev.PackSodiumCompatibility;
import de.linusdev.mixin.MixinResourcePackProfile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_6489;
import net.minecraft.class_7367;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodiumCoreShaderSupport
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"sodiumcoreshadersupport");
    public static final ModContainer SODIUM = FabricLoader.getInstance().getModContainer("sodium").orElse(null);
    public static Map<String, Map<String, class_3298>> shaders;

    public void onInitializeClient() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleResourceReloadListener<Void>(){

            public class_2960 getFabricId() {
                return class_2960.method_60655((String)"sodium", (String)"shaders");
            }

            public CompletableFuture<Void> load(class_3300 manager, class_3695 profiler, Executor executor) {
                return CompletableFuture.supplyAsync(() -> {
                    LOGGER.info("Loading shaders...");
                    shaders = new HashMap<String, Map<String, class_3298>>();
                    manager.method_41265("shaders", path -> true).forEach((identifier, resources) -> {
                        Map nameSpace = shaders.computeIfAbsent(identifier.method_12836(), k -> new HashMap());
                        nameSpace.put(identifier.method_12832().substring("shaders/".length()), (class_3298)resources.get(resources.size() - 1));
                    });
                    shaders.forEach((nameSpace, map) -> {
                        System.out.println("nameSpace: " + nameSpace);
                        map.forEach((path, resource) -> System.out.println("    " + path + ": " + resource.method_45304().method_56926().comp_2330().getString()));
                    });
                    return null;
                }, executor);
            }

            public CompletableFuture<Void> apply(Void data, class_3300 manager, class_3695 profiler, Executor executor) {
                return CompletableFuture.runAsync(() -> {}, executor);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PackSodiumCompReturn isResourcePackCompatible(class_3288 resProfile) {
        if (SODIUM == null) {
            return new PackSodiumCompReturn(PackSodiumCompatibility.COMPATIBLE, null, null, null);
        }
        class_6489 currentGameVersion = class_155.method_16673();
        Version sodiumVersion = SODIUM.getMetadata().getVersion();
        class_3288.class_7680 packFactory = ((MixinResourcePackProfile)resProfile).getPackFactory();
        ArrayList<String> sodiumVersions = new ArrayList<String>();
        ArrayList<String> minecraftVersions = new ArrayList<String>();
        Integer correctMcVersionIndex = null;
        int mcVersionIndex = 0;
        try {
            JsonElement ele;
            Map.Entry entry;
            block35: {
                class_3262 res = packFactory.method_52424(resProfile.method_56933());
                AtomicBoolean hasShaders = new AtomicBoolean(false);
                res.method_14408(class_3264.field_14188, "minecraft", "shaders", (identifier, inputStreamInputSupplier) -> hasShaders.set(true));
                if (!hasShaders.get()) {
                    PackSodiumCompReturn packSodiumCompReturn = new PackSodiumCompReturn(PackSodiumCompatibility.COMPATIBLE, null, null, null);
                    return packSodiumCompReturn;
                }
                class_7367 streamSup = res.method_14405(class_3264.field_14188, class_2960.method_60655((String)"sodiumcoreshadersupport", (String)"versions.json"));
                if (streamSup == null) {
                    PackSodiumCompReturn packSodiumCompReturn = new PackSodiumCompReturn(PackSodiumCompatibility.MISSING_INFORMATION, null, null, null);
                    return packSodiumCompReturn;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)streamSup.get(), StandardCharsets.UTF_8));
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (element == null || !element.isJsonObject()) {
                    LOGGER.warn("{} has an invalid versions.json: first element must be json object ({...})", (Object)resProfile.method_14463());
                    PackSodiumCompReturn packSodiumCompReturn = new PackSodiumCompReturn(PackSodiumCompatibility.MALFORMED_INFORMATION, null, null, null);
                    return packSodiumCompReturn;
                }
                if ((element = element.getAsJsonObject().get("supported-versions")) == null || !element.isJsonObject()) {
                    LOGGER.warn("{} has an invalid versions.json: missing 'supported-versions' json element", (Object)resProfile.method_14463());
                    PackSodiumCompReturn packSodiumCompReturn = new PackSodiumCompReturn(PackSodiumCompatibility.MALFORMED_INFORMATION, null, null, null);
                    return packSodiumCompReturn;
                }
                Iterator iterator = element.getAsJsonObject().asMap().entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    if (!((JsonElement)entry.getValue()).isJsonArray()) {
                        LOGGER.warn("{} has an invalid versions.json: sodium versions must be specified as array", (Object)resProfile.method_14463());
                        PackSodiumCompReturn packSodiumCompReturn = new PackSodiumCompReturn(PackSodiumCompatibility.MALFORMED_INFORMATION, null, null, null);
                        return packSodiumCompReturn;
                    }
                    minecraftVersions.add((String)entry.getKey());
                    if (!((String)entry.getKey()).equals(currentGameVersion.method_48019())) {
                        ++mcVersionIndex;
                        continue;
                    }
                    break block35;
                }
                return new PackSodiumCompReturn(PackSodiumCompatibility.NOT_COMPATIBLE, sodiumVersions, minecraftVersions, correctMcVersionIndex);
                finally {
                    reader.close();
                }
                finally {
                    if (res != null) {
                        res.close();
                    }
                }
            }
            correctMcVersionIndex = mcVersionIndex;
            Iterator iterator = ((JsonElement)entry.getValue()).getAsJsonArray().iterator();
            do {
                if (!iterator.hasNext()) return new PackSodiumCompReturn(PackSodiumCompatibility.NOT_COMPATIBLE, sodiumVersions, minecraftVersions, correctMcVersionIndex);
                ele = (JsonElement)iterator.next();
                if (!ele.isJsonPrimitive() || !ele.getAsJsonPrimitive().isString()) {
                    LOGGER.warn("{} has an invalid versions.json: sodium versions array mus contain stringsb", (Object)resProfile.method_14463());
                    PackSodiumCompReturn packSodiumCompReturn = new PackSodiumCompReturn(PackSodiumCompatibility.MALFORMED_INFORMATION, null, null, null);
                    return packSodiumCompReturn;
                }
                sodiumVersions.add(ele.getAsJsonPrimitive().getAsString());
            } while (!sodiumVersion.equals((Object)Version.parse((String)ele.getAsJsonPrimitive().getAsString())));
            PackSodiumCompReturn packSodiumCompReturn = new PackSodiumCompReturn(PackSodiumCompatibility.COMPATIBLE, null, null, null);
            return packSodiumCompReturn;
        }
        catch (IOException | VersionParsingException e) {
            throw new RuntimeException(e);
        }
    }

    public record PackSodiumCompReturn(@NotNull PackSodiumCompatibility compatibility, @Nullable List<String> sodiumVersions, @Nullable List<String> minecraftVersions, @Nullable Integer correctMcVersionIndex) {
    }
}

