/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TriState {
    TRUE{

        @Override
        @Contract(value="_ -> true", pure=true)
        public boolean toBooleanOrElse(boolean fallback) {
            return true;
        }

        @Override
        @Contract(value="_ -> true")
        public boolean toBooleanOrElseGet(@NotNull BooleanSupplier fallbackSupplier) {
            Objects.requireNonNull(fallbackSupplier, "fallbackSupplier may not be null");
            return true;
        }

        @Override
        @Contract(value="-> true", pure=true)
        public boolean toBooleanOrElseThrow() {
            return true;
        }

        @Override
        @Contract(value="_ -> true")
        public <X extends Throwable> boolean toBooleanOrElseThrow(@NotNull Supplier<? extends X> exceptionSupplier) throws X {
            Objects.requireNonNull(exceptionSupplier, "exceptionSupplier may not be null");
            return true;
        }
    }
    ,
    FALSE{

        @Override
        @Contract(value="_ -> false", pure=true)
        public boolean toBooleanOrElse(boolean fallback) {
            return false;
        }

        @Override
        @Contract(value="_ -> false")
        public boolean toBooleanOrElseGet(@NotNull BooleanSupplier fallbackSupplier) {
            Objects.requireNonNull(fallbackSupplier, "fallbackSupplier may not be null");
            return false;
        }

        @Override
        @Contract(value="-> false", pure=true)
        public boolean toBooleanOrElseThrow() {
            return false;
        }

        @Override
        @Contract(value="_ -> false")
        public <X extends Throwable> boolean toBooleanOrElseThrow(@NotNull Supplier<? extends X> exceptionSupplier) throws X {
            Objects.requireNonNull(exceptionSupplier, "exceptionSupplier may not be null");
            return false;
        }
    }
    ,
    DEFAULT{

        @Override
        @Contract(value="_ -> param1", pure=true)
        public boolean toBooleanOrElse(boolean fallback) {
            return fallback;
        }

        @Override
        public boolean toBooleanOrElseGet(@NotNull BooleanSupplier fallbackSupplier) {
            Objects.requireNonNull(fallbackSupplier, "fallbackSupplier may not be null");
            return fallbackSupplier.getAsBoolean();
        }

        @Override
        @Contract(value="-> fail", pure=true)
        public boolean toBooleanOrElseThrow() {
            throw new NoSuchElementException("No value present");
        }

        @Override
        @Contract(value="_ -> fail")
        public <X extends Throwable> boolean toBooleanOrElseThrow(@NotNull Supplier<? extends X> exceptionSupplier) throws X {
            Objects.requireNonNull(exceptionSupplier, "exceptionSupplier may not be null");
            throw (Throwable)exceptionSupplier.get();
        }
    };


    @Contract(pure=true)
    @Nullable
    public Boolean toBoolean() {
        return switch (this) {
            case TRUE -> true;
            case FALSE -> false;
            default -> null;
        };
    }

    @Contract(pure=true)
    public abstract boolean toBooleanOrElse(boolean var1);

    public abstract boolean toBooleanOrElseGet(@NotNull BooleanSupplier var1);

    @Contract(pure=true)
    public abstract boolean toBooleanOrElseThrow();

    public abstract <X extends Throwable> boolean toBooleanOrElseThrow(@NotNull Supplier<? extends X> var1) throws X;

    @Contract(pure=true)
    @NotNull
    public static TriState from(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    @Contract(pure=true)
    @NotNull
    public static TriState from(@Nullable Boolean bool) {
        return bool == null ? DEFAULT : TriState.from((boolean)bool);
    }

    @NotNull
    public static TriState fromString(@Nullable String value) {
        if ("true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value)) {
            return TRUE;
        }
        if ("false".equalsIgnoreCase(value) || "off".equalsIgnoreCase(value)) {
            return FALSE;
        }
        return DEFAULT;
    }

    @NotNull
    public static TriState fromProperty(@NotNull String property) {
        String value = System.getProperty(property);
        return TriState.fromString(value);
    }
}

