/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_773;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import net.minecraft.class_816;
import org.betterx.bclib.interfaces.ItemModelProvider;
import org.betterx.bclib.interfaces.RuntimeBlockModelProvider;
import org.betterx.bclib.models.RecordItemModelProvider;

public class CustomModelBakery {
    private final Map<class_2960, class_1100> models = Maps.newConcurrentMap();
    private final Map<class_2248, List<StateModelPair>> blockModels = Maps.newConcurrentMap();

    public class_1100 getBlockModel(class_2960 location) {
        return this.models.get(location);
    }

    public class_1100 getItemModel(class_2960 location) {
        return this.models.get(location);
    }

    public void registerBlockStateResolvers(ModelLoadingPlugin.Context pluginContext) {
        for (Map.Entry<class_2248, List<StateModelPair>> e : this.blockModels.entrySet()) {
            pluginContext.registerBlockStateResolver(e.getKey(), context -> ((List)e.getValue()).forEach(p -> context.setModel(p.state, p.model)));
        }
    }

    public void loadCustomModels(class_3300 resourceManager) {
        ((Stream)class_7923.field_41175.method_10220().parallel()).filter(block -> block instanceof RuntimeBlockModelProvider).forEach(block -> {
            class_2960 blockID = class_7923.field_41175.method_10221(block);
            class_2960 storageID = class_2960.method_60655((String)blockID.method_12836(), (String)("blockstates/" + blockID.method_12832() + ".json"));
            if (resourceManager.method_14486(storageID).isEmpty()) {
                this.addBlockModel(blockID, (class_2248)block);
            }
            if (resourceManager.method_14486(storageID = class_2960.method_60655((String)blockID.method_12836(), (String)("models/item/" + blockID.method_12832() + ".json"))).isEmpty()) {
                this.addItemModel(blockID, (ItemModelProvider)block);
            }
        });
        ((Stream)class_7923.field_41178.method_10220().parallel()).filter(item -> item instanceof ItemModelProvider || RecordItemModelProvider.has(item)).forEach(item -> {
            ItemModelProvider provider;
            class_2960 registryID = class_7923.field_41178.method_10221(item);
            class_2960 storageID = class_2960.method_60655((String)registryID.method_12836(), (String)("models/item/" + registryID.method_12832() + ".json"));
            ItemModelProvider itemModelProvider = provider = item instanceof ItemModelProvider ? (ItemModelProvider)item : RecordItemModelProvider.get(item);
            if (resourceManager.method_14486(storageID).isEmpty()) {
                this.addItemModel(registryID, provider);
            }
        });
    }

    private void addBlockModel(class_2960 blockID, class_2248 block) {
        RuntimeBlockModelProvider provider = (RuntimeBlockModelProvider)block;
        ImmutableList states = block.method_9595().method_11662();
        class_2680 defaultState = block.method_9564();
        class_1091 defaultStateID = class_773.method_3336((class_2960)blockID, (class_2680)defaultState);
        class_1100 defaultModel = provider.getModelVariant(defaultStateID, defaultState, this.models);
        ArrayList stateModels = new ArrayList(states.size());
        if (defaultModel instanceof class_816) {
            states.forEach(blockState -> {
                class_1091 stateID = class_773.method_3336((class_2960)blockID, (class_2680)blockState);
                this.models.put(stateID.comp_2875(), defaultModel);
                stateModels.add(new StateModelPair((class_2680)blockState, defaultModel));
            });
        } else {
            states.forEach(blockState -> {
                class_1091 stateID = class_773.method_3336((class_2960)blockID, (class_2680)blockState);
                class_1100 model = stateID.equals((Object)defaultStateID) ? defaultModel : provider.getModelVariant(stateID, (class_2680)blockState, this.models);
                this.models.put(stateID.comp_2875(), model);
                stateModels.add(new StateModelPair((class_2680)blockState, model));
            });
        }
        this.blockModels.put(block, stateModels);
    }

    private void addItemModel(class_2960 itemID, ItemModelProvider provider) {
        class_1091 modelLocation = new class_1091(itemID, "inventory");
        if (!this.models.containsKey(modelLocation)) {
            class_2960 itemModelLocation = itemID.method_45138("item/");
            class_793 model = provider.getItemModel(modelLocation.comp_2875());
            this.models.put(modelLocation.comp_2875(), (class_1100)model);
            this.models.put(itemModelLocation, (class_1100)model);
        }
    }

    private record StateModelPair(class_2680 state, class_1100 model) {
    }
}

