/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.models;

import com.google.common.collect.Lists;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.betterx.bclib.client.models.OBJBlockModel;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class OBJModelBuilder {
    private static final OBJModelBuilder INSTANCE = new OBJModelBuilder();
    private final List<class_2960> textures = Lists.newArrayList();
    private final Vector3f offset = new Vector3f();
    private class_2960 modelLocation;
    private class_2960 particles;
    private boolean useCulling;
    private boolean useShading;

    private OBJModelBuilder() {
    }

    public static OBJModelBuilder start(class_2960 modelLocation) {
        OBJModelBuilder.INSTANCE.modelLocation = modelLocation;
        OBJModelBuilder.INSTANCE.offset.set(0.0f, 0.0f, 0.0f);
        OBJModelBuilder.INSTANCE.useCulling = true;
        OBJModelBuilder.INSTANCE.useShading = true;
        OBJModelBuilder.INSTANCE.particles = null;
        OBJModelBuilder.INSTANCE.textures.clear();
        return INSTANCE;
    }

    public OBJModelBuilder addTexture(class_2960 texture) {
        this.textures.add(texture);
        return this;
    }

    public OBJModelBuilder useCulling(boolean useCulling) {
        this.useCulling = useCulling;
        return this;
    }

    public OBJModelBuilder useShading(boolean useShading) {
        this.useShading = useShading;
        return this;
    }

    public OBJModelBuilder setParticlesTexture(class_2960 texture) {
        this.particles = texture;
        return this;
    }

    public OBJModelBuilder setOffset(float x, float y, float z) {
        this.offset.set(x, y, z);
        return this;
    }

    public OBJBlockModel build() {
        byte particleIndex = 0;
        if (this.particles != null && (particleIndex = (byte)this.textures.indexOf(this.particles)) < 0) {
            particleIndex = (byte)this.textures.size();
            this.textures.add(this.particles);
        }
        class_2960[] sprites = this.textures.toArray(new class_2960[this.textures.size()]);
        return new OBJBlockModel(this.modelLocation, this.offset, this.useCulling, this.useShading, particleIndex, sprites);
    }
}

