/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.interfaces;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeDataRegistry;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.surface.api.SurfaceRuleBuilder;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.jetbrains.annotations.Nullable;

public interface SurfaceMaterialProvider {
    public static final MapCodec<SurfaceMaterialProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2680.field_24734.fieldOf("top").forGetter(SurfaceMaterialProvider::getTopMaterial), (App)class_2680.field_24734.fieldOf("under").forGetter(SurfaceMaterialProvider::getUnderMaterial), (App)class_2680.field_24734.fieldOf("alt").forGetter(SurfaceMaterialProvider::getAltTopMaterial), (App)Codec.BOOL.fieldOf("floor_rule").forGetter(SurfaceMaterialProvider::generateFloorRule)).apply((Applicative)instance, SurfaceMaterialProvider::create));

    public static SurfaceMaterialProvider create(final class_2680 top, final class_2680 under, final class_2680 alt, final boolean genFloorRule) {
        return new SurfaceMaterialProvider(){

            @Override
            public class_2680 getTopMaterial() {
                return top;
            }

            @Override
            public class_2680 getUnderMaterial() {
                return under;
            }

            @Override
            public class_2680 getAltTopMaterial() {
                return alt;
            }

            @Override
            public boolean generateFloorRule() {
                return genFloorRule;
            }

            @Override
            public SurfaceRuleBuilder surface() {
                return null;
            }
        };
    }

    public class_2680 getTopMaterial();

    public class_2680 getUnderMaterial();

    public class_2680 getAltTopMaterial();

    public boolean generateFloorRule();

    public SurfaceRuleBuilder surface();

    default public void addBiomeSurfaceToEndGroup(TagBootstrapContext<class_2248> context, class_6862<class_2248> groundTag) {
        context.add(groundTag, (Object[])new class_2248[]{this.getTopMaterial().method_26204()});
        context.add(groundTag, (Object[])new class_2248[]{this.getAltTopMaterial().method_26204()});
        context.add(groundTag, (Object[])new class_2248[]{this.getUnderMaterial().method_26204()});
    }

    public static Optional<SurfaceMaterialProvider> findSurfaceMaterialProvider(class_5281 world, class_2338 pos) {
        return SurfaceMaterialProvider.findSurfaceMaterialProvider((class_6880<class_1959>)world.method_23753(pos));
    }

    public static Optional<SurfaceMaterialProvider> findSurfaceMaterialProvider(@Nullable class_6880<class_1959> biome) {
        BiomeData data;
        if (biome != null && (data = (BiomeData)((class_2378)WorldState.registryAccess().method_33310(BiomeDataRegistry.BIOME_DATA_REGISTRY).orElseThrow()).method_10223(((class_5321)biome.method_40230().orElseThrow()).method_29177())) instanceof SurfaceMaterialProvider) {
            SurfaceMaterialProvider smp = (SurfaceMaterialProvider)data;
            return Optional.of(smp);
        }
        return Optional.empty();
    }
}

