/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.components.image.CacheableImage;
import gg.essential.elementa.components.image.DefaultFailureImage;
import gg.essential.elementa.components.image.DefaultLoadingImage;
import gg.essential.elementa.components.image.ImageCache;
import gg.essential.elementa.components.image.ImageProvider;
import gg.essential.elementa.utils.ImageKt;
import gg.essential.elementa.utils.ResourceCache;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.utils.ReleasedDynamicTexture;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.imageio.ImageIO;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 92\u00020\u00012\u00020\u00022\u00020\u0003:\u00029:B\u0015\b\u0017\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B)\b\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\fJ\u0012\u0010*\u001a\u00020+2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0016J8\u0010/\u001a\u00020+2\u0006\u0010-\u001a\u00020.2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002012\u0006\u00103\u001a\u0002012\u0006\u00104\u001a\u0002012\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020+2\u0006\u00108\u001a\u00020\u0003H\u0016R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u0011\u0010\u001c\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lgg/essential/elementa/components/UIImage;", "Lgg/essential/elementa/UIComponent;", "Lgg/essential/elementa/components/image/ImageProvider;", "Lgg/essential/elementa/components/image/CacheableImage;", "imageFunction", "Lkotlin/Function0;", "Ljava/awt/image/BufferedImage;", "(Lkotlin/jvm/functions/Function0;)V", "imageFuture", "Ljava/util/concurrent/CompletableFuture;", "loadingImage", "failureImage", "(Ljava/util/concurrent/CompletableFuture;Lgg/essential/elementa/components/image/ImageProvider;Lgg/essential/elementa/components/image/ImageProvider;)V", "destroy", "", "getDestroy", "()Z", "setDestroy", "(Z)V", "imageHeight", "", "getImageHeight", "()F", "setImageHeight", "(F)V", "imageWidth", "getImageWidth", "setImageWidth", "isLoaded", "texture", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "textureMagFilter", "Lgg/essential/elementa/components/UIImage$TextureScalingMode;", "getTextureMagFilter", "()Lgg/essential/elementa/components/UIImage$TextureScalingMode;", "setTextureMagFilter", "(Lgg/essential/elementa/components/UIImage$TextureScalingMode;)V", "textureMinFilter", "getTextureMinFilter", "setTextureMinFilter", "waiting", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "applyTexture", "", "draw", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "drawImage", "x", "", "y", "width", "height", "color", "Ljava/awt/Color;", "supply", "image", "Companion", "TextureScalingMode", "Elementa"})
public class UIImage
extends UIComponent
implements ImageProvider,
CacheableImage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompletableFuture<BufferedImage> imageFuture;
    @NotNull
    private final ImageProvider loadingImage;
    @NotNull
    private final ImageProvider failureImage;
    @Nullable
    private ReleasedDynamicTexture texture;
    @NotNull
    private final ConcurrentLinkedQueue<CacheableImage> waiting;
    private float imageWidth;
    private float imageHeight;
    private boolean destroy;
    @NotNull
    private TextureScalingMode textureMinFilter;
    @NotNull
    private TextureScalingMode textureMagFilter;
    @NotNull
    private static final ResourceCache defaultResourceCache = new ResourceCache(50);

    @JvmOverloads
    public UIImage(@NotNull CompletableFuture<BufferedImage> imageFuture, @NotNull ImageProvider loadingImage, @NotNull ImageProvider failureImage) {
        Intrinsics.checkNotNullParameter(imageFuture, (String)"imageFuture");
        Intrinsics.checkNotNullParameter((Object)loadingImage, (String)"loadingImage");
        Intrinsics.checkNotNullParameter((Object)failureImage, (String)"failureImage");
        this.imageFuture = imageFuture;
        this.loadingImage = loadingImage;
        this.failureImage = failureImage;
        this.waiting = new ConcurrentLinkedQueue();
        this.imageWidth = 1.0f;
        this.imageHeight = 1.0f;
        this.destroy = true;
        this.textureMinFilter = TextureScalingMode.NEAREST;
        this.textureMagFilter = TextureScalingMode.NEAREST;
        ((CompletableFuture)this.imageFuture.exceptionally(UIImage::_init_$lambda$0)).thenAcceptAsync(arg_0 -> UIImage._init_$lambda$1((Function1)new Function1<BufferedImage, Unit>(){

            public final void invoke(BufferedImage it) {
                if (it == null) {
                    this.setDestroy(false);
                    return;
                }
                this.setImageWidth(it.getWidth());
                this.setImageHeight(it.getHeight());
                imageFuture.obtrudeValue(null);
                final ReleasedDynamicTexture texture = UGraphics.getTexture((BufferedImage)it);
                Window.Companion.enqueueRenderOperation((Function0<Unit>)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        ReleasedDynamicTexture releasedDynamicTexture = texture;
                        if (releasedDynamicTexture != null) {
                            releasedDynamicTexture.uploadTexture();
                        }
                        texture = texture;
                        while (!waiting.isEmpty()) {
                            ((CacheableImage)waiting.poll()).applyTexture(texture);
                        }
                    }
                }));
            }
        }, arg_0));
    }

    public /* synthetic */ UIImage(CompletableFuture completableFuture, ImageProvider imageProvider, ImageProvider imageProvider2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            imageProvider = DefaultLoadingImage.INSTANCE;
        }
        if ((n & 4) != 0) {
            imageProvider2 = DefaultFailureImage.INSTANCE;
        }
        this(completableFuture, imageProvider, imageProvider2);
    }

    public final float getImageWidth() {
        return this.imageWidth;
    }

    public final void setImageWidth(float f) {
        this.imageWidth = f;
    }

    public final float getImageHeight() {
        return this.imageHeight;
    }

    public final void setImageHeight(float f) {
        this.imageHeight = f;
    }

    public final boolean getDestroy() {
        return this.destroy;
    }

    public final void setDestroy(boolean bl) {
        this.destroy = bl;
    }

    public final boolean isLoaded() {
        return this.texture != null;
    }

    @NotNull
    public final TextureScalingMode getTextureMinFilter() {
        return this.textureMinFilter;
    }

    public final void setTextureMinFilter(@NotNull TextureScalingMode textureScalingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)textureScalingMode), (String)"<set-?>");
        this.textureMinFilter = textureScalingMode;
    }

    @NotNull
    public final TextureScalingMode getTextureMagFilter() {
        return this.textureMagFilter;
    }

    public final void setTextureMagFilter(@NotNull TextureScalingMode textureScalingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)textureScalingMode), (String)"<set-?>");
        this.textureMagFilter = textureScalingMode;
    }

    @Deprecated(message="Please provide a completable future instead", replaceWith=@ReplaceWith(expression="CompletableFuture.supplyAsync(imageFunction)", imports={"java.util.concurrent.CompletableFuture"}), level=DeprecationLevel.ERROR)
    public UIImage(@NotNull Function0<? extends BufferedImage> imageFunction) {
        Intrinsics.checkNotNullParameter(imageFunction, (String)"imageFunction");
        CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> UIImage._init_$lambda$2(imageFunction));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(imageFunction)");
        this(completableFuture, null, null, 6, null);
    }

    @Override
    public void drawImage(@NotNull UMatrixStack matrixStack, double x, double y, double width, double height, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (this.texture != null) {
            ReleasedDynamicTexture releasedDynamicTexture = this.texture;
            Intrinsics.checkNotNull((Object)releasedDynamicTexture);
            ImageKt.drawTexture(matrixStack, releasedDynamicTexture, color, x, y, width, height, this.textureMinFilter.getGlMode$Elementa(), this.textureMagFilter.getGlMode$Elementa());
        } else if (this.imageFuture.isCompletedExceptionally()) {
            this.failureImage.drawImageCompat(matrixStack, x, y, width, height, color);
        } else {
            this.loadingImage.drawImageCompat(matrixStack, x, y, width, height, color);
        }
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        double x = this.getLeft();
        double y = this.getTop();
        double width = this.getWidth();
        double height = this.getHeight();
        Color color = this.getColor();
        if (color.getAlpha() == 0) {
            super.draw(matrixStack);
            return;
        }
        this.drawImage(matrixStack, x, y, width, height, color);
        super.draw(matrixStack);
    }

    @Override
    public void supply(@NotNull CacheableImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (this.texture != null) {
            image.applyTexture(this.texture);
            return;
        }
        this.waiting.add(image);
    }

    @Override
    public void applyTexture(@Nullable ReleasedDynamicTexture texture) {
        this.texture = texture;
        while (!this.waiting.isEmpty()) {
            this.waiting.poll().applyTexture(texture);
        }
    }

    @JvmOverloads
    public UIImage(@NotNull CompletableFuture<BufferedImage> imageFuture, @NotNull ImageProvider loadingImage) {
        Intrinsics.checkNotNullParameter(imageFuture, (String)"imageFuture");
        Intrinsics.checkNotNullParameter((Object)loadingImage, (String)"loadingImage");
        this(imageFuture, loadingImage, null, 4, null);
    }

    @JvmOverloads
    public UIImage(@NotNull CompletableFuture<BufferedImage> imageFuture) {
        Intrinsics.checkNotNullParameter(imageFuture, (String)"imageFuture");
        this(imageFuture, null, null, 6, null);
    }

    private static final BufferedImage _init_$lambda$0(Throwable it) {
        it.printStackTrace();
        return null;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final BufferedImage _init_$lambda$2(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BufferedImage)$tmp0.invoke();
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofFile(@NotNull File file) {
        return Companion.ofFile(file);
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofURL(@NotNull URL url) {
        return Companion.ofURL(url);
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofURL(@NotNull URL url, @NotNull ImageCache cache) {
        return Companion.ofURL(url, cache);
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofResource(@NotNull String path) {
        return Companion.ofResource(path);
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofResourceCached(@NotNull String path) {
        return Companion.ofResourceCached(path);
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofResourceCached(@NotNull String path, @NotNull ResourceCache resourceCache) {
        return Companion.ofResourceCached(path, resourceCache);
    }

    @JvmStatic
    @NotNull
    public static final BufferedImage get(@NotNull URL url) {
        return Companion.get(url);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lgg/essential/elementa/components/UIImage$Companion;", "", "()V", "defaultResourceCache", "Lgg/essential/elementa/utils/ResourceCache;", "getDefaultResourceCache", "()Lgg/essential/elementa/utils/ResourceCache;", "get", "Ljava/awt/image/BufferedImage;", "url", "Ljava/net/URL;", "ofFile", "Lgg/essential/elementa/components/UIImage;", "file", "Ljava/io/File;", "ofResource", "path", "", "ofResourceCached", "resourceCache", "ofURL", "cache", "Lgg/essential/elementa/components/image/ImageCache;", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceCache getDefaultResourceCache() {
            return defaultResourceCache;
        }

        @JvmStatic
        @NotNull
        public final UIImage ofFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> Companion.ofFile$lambda$0(file));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync { ImageIO.read(file) }");
            return new UIImage(completableFuture, null, null, 6, null);
        }

        @JvmStatic
        @NotNull
        public final UIImage ofURL(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> Companion.ofURL$lambda$1(url));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync { get(url) }");
            return new UIImage(completableFuture, null, null, 6, null);
        }

        @JvmStatic
        @NotNull
        public final UIImage ofURL(@NotNull URL url, @NotNull ImageCache cache) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
            CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> Companion.ofURL$lambda$3(cache, url));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync {\n          \u2026          }\n            }");
            return new UIImage(completableFuture, null, null, 6, null);
        }

        @JvmStatic
        @NotNull
        public final UIImage ofResource(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            CompletableFuture<BufferedImage> completableFuture = CompletableFuture.supplyAsync(() -> Companion.ofResource$lambda$4(this, path));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync {\n          \u2026ream(path))\n            }");
            return new UIImage(completableFuture, null, null, 6, null);
        }

        @JvmStatic
        @NotNull
        public final UIImage ofResourceCached(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.ofResourceCached(path, this.getDefaultResourceCache());
        }

        @JvmStatic
        @NotNull
        public final UIImage ofResourceCached(@NotNull String path, @NotNull ResourceCache resourceCache) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)resourceCache, (String)"resourceCache");
            CacheableImage cacheableImage = resourceCache.getUIImage(path);
            Intrinsics.checkNotNull((Object)cacheableImage, (String)"null cannot be cast to non-null type gg.essential.elementa.components.UIImage");
            return (UIImage)cacheableImage;
        }

        @JvmStatic
        @NotNull
        public final BufferedImage get(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.setUseCaches(true);
            connection.addRequestProperty("User-Agent", "Mozilla/4.76 (Elementa)");
            connection.setDoOutput(true);
            BufferedImage bufferedImage = ImageIO.read(connection.getInputStream());
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(connection.inputStream)");
            return bufferedImage;
        }

        private static final BufferedImage ofFile$lambda$0(File $file) {
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            return ImageIO.read($file);
        }

        private static final BufferedImage ofURL$lambda$1(URL $url) {
            Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
            return Companion.get($url);
        }

        private static final BufferedImage ofURL$lambda$3(ImageCache $cache, URL $url) {
            Intrinsics.checkNotNullParameter((Object)$cache, (String)"$cache");
            Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
            BufferedImage bufferedImage = $cache.get($url);
            if (bufferedImage == null) {
                BufferedImage bufferedImage2;
                BufferedImage it = bufferedImage2 = Companion.get($url);
                boolean bl = false;
                $cache.set($url, it);
                bufferedImage = bufferedImage2;
            }
            return bufferedImage;
        }

        private static final BufferedImage ofResource$lambda$4(Companion this$0, String $path) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
            return ImageIO.read(this$0.getClass().getResourceAsStream($path));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lgg/essential/elementa/components/UIImage$TextureScalingMode;", "", "glMode", "", "(Ljava/lang/String;II)V", "getGlMode$Elementa", "()I", "NEAREST", "LINEAR", "NEAREST_MIPMAP_NEAREST", "LINEAR_MIPMAP_NEAREST", "NEAREST_MIPMAP_LINEAR", "LINEAR_MIPMAP_LINEAR", "Elementa"})
    public static final class TextureScalingMode
    extends Enum<TextureScalingMode> {
        private final int glMode;
        public static final /* enum */ TextureScalingMode NEAREST = new TextureScalingMode(9728);
        public static final /* enum */ TextureScalingMode LINEAR = new TextureScalingMode(9729);
        public static final /* enum */ TextureScalingMode NEAREST_MIPMAP_NEAREST = new TextureScalingMode(9984);
        public static final /* enum */ TextureScalingMode LINEAR_MIPMAP_NEAREST = new TextureScalingMode(9985);
        public static final /* enum */ TextureScalingMode NEAREST_MIPMAP_LINEAR = new TextureScalingMode(9986);
        public static final /* enum */ TextureScalingMode LINEAR_MIPMAP_LINEAR = new TextureScalingMode(9987);
        private static final /* synthetic */ TextureScalingMode[] $VALUES;

        private TextureScalingMode(int glMode) {
            this.glMode = glMode;
        }

        public final int getGlMode$Elementa() {
            return this.glMode;
        }

        public static TextureScalingMode[] values() {
            return (TextureScalingMode[])$VALUES.clone();
        }

        public static TextureScalingMode valueOf(String value) {
            return Enum.valueOf(TextureScalingMode.class, value);
        }

        static {
            $VALUES = textureScalingModeArray = new TextureScalingMode[]{TextureScalingMode.NEAREST, TextureScalingMode.LINEAR, TextureScalingMode.NEAREST_MIPMAP_NEAREST, TextureScalingMode.LINEAR_MIPMAP_NEAREST, TextureScalingMode.NEAREST_MIPMAP_LINEAR, TextureScalingMode.LINEAR_MIPMAP_LINEAR};
        }
    }
}

