/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.utils.ExtensionsKt;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.shader.Float4Uniform;
import gg.essential.universal.shader.FloatUniform;
import gg.essential.universal.shader.UShader;
import java.awt.Color;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lgg/essential/elementa/components/UIRoundedRectangle;", "Lgg/essential/elementa/UIComponent;", "radius", "", "(F)V", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "Companion", "Elementa"})
public class UIRoundedRectangle
extends UIComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static UShader shader;
    private static FloatUniform shaderRadiusUniform;
    private static Float4Uniform shaderInnerRectUniform;

    public UIRoundedRectangle(float radius) {
        this.setRadius(UtilitiesKt.pixels$default(Float.valueOf(radius), false, false, 3, null));
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        float radius = this.getRadius();
        Color color = this.getColor();
        if (color.getAlpha() != 0) {
            Companion.drawRoundedRectangle(matrixStack, this.getLeft(), this.getTop(), this.getRight(), this.getBottom(), radius, color);
        }
        super.draw(matrixStack);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J8\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0006\u0010\u0015\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgg/essential/elementa/components/UIRoundedRectangle$Companion;", "", "()V", "shader", "Lgg/essential/universal/shader/UShader;", "shaderInnerRectUniform", "Lgg/essential/universal/shader/Float4Uniform;", "shaderRadiusUniform", "Lgg/essential/universal/shader/FloatUniform;", "drawRoundedRectangle", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "left", "", "top", "right", "bottom", "radius", "color", "Ljava/awt/Color;", "initShaders", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        public final void initShaders() {
            if (shader != null) {
                return;
            }
            shader = ExtensionsKt.readFromLegacyShader(UShader.Companion, "rect", "rounded_rect", BlendState.NORMAL);
            UShader uShader = shader;
            if (uShader == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
                uShader = null;
            }
            if (!uShader.getUsable()) {
                String string = "Failed to load Elementa UIRoundedRectangle shader";
                System.out.println((Object)string);
                return;
            }
            UShader uShader2 = shader;
            if (uShader2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
                uShader2 = null;
            }
            shaderRadiusUniform = uShader2.getFloatUniform("u_Radius");
            UShader uShader3 = shader;
            if (uShader3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
                uShader3 = null;
            }
            shaderInnerRectUniform = uShader3.getFloat4Uniform("u_InnerRect");
        }

        @Deprecated(message="For 1.17 this method requires you pass a UMatrixStack as the first argument.\n\nIf you are currently extending this method, you should instead extend the method with the added argument.\nNote however for this to be non-breaking, your parent class needs to transition before you do.\n\nIf you are calling this method and you cannot guarantee that your target class has been fully updated (such as when\ncalling an open method on an open class), you should instead call the method with the \"Compat\" suffix, which will\ncall both methods, the new and the deprecated one.\nIf you are sure that your target class has been updated (such as when calling the super method), you should\n(for super calls you must!) instead just call the method with the original name and added argument.", replaceWith=@ReplaceWith(expression="drawRoundedRectangle(matrixStack, left, top, right, bottom, radius, color)", imports={}))
        public final void drawRoundedRectangle(float left2, float top, float right, float bottom, float radius, @NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.drawRoundedRectangle(new UMatrixStack(), left2, top, right, bottom, radius, color);
        }

        public final void drawRoundedRectangle(@NotNull UMatrixStack matrixStack, float left2, float top, float right, float bottom, float radius, @NotNull Color color) {
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                    Intrinsics.checkNotNullParameter((Object)color, (String)"color");
                    if (shader == null) break block8;
                    UShader uShader = shader;
                    if (uShader == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
                        uShader = null;
                    }
                    if (uShader.getUsable()) break block9;
                }
                return;
            }
            UShader uShader = shader;
            if (uShader == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
                uShader = null;
            }
            uShader.bind();
            FloatUniform floatUniform = shaderRadiusUniform;
            if (floatUniform == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shaderRadiusUniform");
                floatUniform = null;
            }
            floatUniform.setValue(radius);
            Float4Uniform float4Uniform = shaderInnerRectUniform;
            if (float4Uniform == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shaderInnerRectUniform");
                float4Uniform = null;
            }
            float4Uniform.setValue(left2 + radius, top + radius, right - radius, bottom - radius);
            UIBlock.Companion.drawBlockWithActiveShader(matrixStack, color, left2, top, right, bottom);
            UShader uShader2 = shader;
            if (uShader2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
                uShader2 = null;
            }
            uShader2.unbind();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

