/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.markdown;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.MarkdownNode;
import gg.essential.elementa.components.TreeListComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.events.UIEvent;
import gg.essential.elementa.font.ElementaFonts;
import gg.essential.elementa.font.FontProvider;
import gg.essential.elementa.markdown.DrawState;
import gg.essential.elementa.markdown.MarkdownConfig;
import gg.essential.elementa.markdown.MarkdownRenderer;
import gg.essential.elementa.markdown.drawables.BlockquoteDrawable;
import gg.essential.elementa.markdown.drawables.Drawable;
import gg.essential.elementa.markdown.drawables.DrawableList;
import gg.essential.elementa.markdown.drawables.HeaderDrawable;
import gg.essential.elementa.markdown.drawables.ListDrawable;
import gg.essential.elementa.markdown.drawables.ParagraphDrawable;
import gg.essential.elementa.markdown.selection.Cursor;
import gg.essential.elementa.markdown.selection.Selection;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.elementa.utils.OptionsKt;
import gg.essential.universal.UDesktop;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 G2\u00020\u0001:\u0003GHIB-\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u00104\u001a\u00020!H\u0016J\u0014\u00105\u001a\u00020\u00002\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000303J\b\u00107\u001a\u00020\u001cH\u0002J\r\u00108\u001a\u000209H\u0000\u00a2\u0006\u0002\b:J\u0010\u0010;\u001a\u00020!2\u0006\u0010<\u001a\u00020=H\u0016J\u0015\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020 H\u0000\u00a2\u0006\u0002\b@J\u0006\u0010A\u001a\u00020!J%\u0010B\u001a\u00020!2\u001d\u0010C\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f\u00a2\u0006\u0002\b\"J\b\u0010D\u001a\u00020!H\u0002J\u000e\u0010E\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010F\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R+\u0010\u001d\u001a\u001f\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f\u00a2\u0006\u0002\b\"0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020!0+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070,2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070,@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\u000303X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lgg/essential/elementa/markdown/MarkdownComponent;", "Lgg/essential/elementa/UIComponent;", "text", "", "config", "Lgg/essential/elementa/markdown/MarkdownConfig;", "codeFontPointSize", "", "codeFontRenderer", "Lgg/essential/elementa/font/FontProvider;", "(Ljava/lang/String;Lgg/essential/elementa/markdown/MarkdownConfig;FLgg/essential/elementa/font/FontProvider;)V", "disableSelection", "", "(Ljava/lang/String;Lgg/essential/elementa/markdown/MarkdownConfig;FLgg/essential/elementa/font/FontProvider;Z)V", "baseX", "baseY", "canDrag", "getConfig", "()Lgg/essential/elementa/markdown/MarkdownConfig;", "configState", "Lgg/essential/elementa/state/BasicState;", "cursor", "Lgg/essential/elementa/markdown/selection/Cursor;", "drawables", "Lgg/essential/elementa/markdown/drawables/DrawableList;", "getDrawables", "()Lgg/essential/elementa/markdown/drawables/DrawableList;", "lastValues", "Lgg/essential/elementa/markdown/MarkdownComponent$ConstraintValues;", "linkClickListeners", "", "Lkotlin/Function2;", "Lgg/essential/elementa/markdown/MarkdownComponent$LinkClickEvent;", "", "Lkotlin/ExtensionFunctionType;", "maxHeight", "Lgg/essential/elementa/constraints/HeightConstraint;", "<set-?>", "maxTextLineWidth", "getMaxTextLineWidth", "()F", "needsInitialLayout", "removeListener", "Lkotlin/Function0;", "", "sectionOffsets", "getSectionOffsets", "()Ljava/util/Map;", "selection", "Lgg/essential/elementa/markdown/selection/Selection;", "textState", "Lgg/essential/elementa/state/State;", "animationFrame", "bindText", "state", "constraintValues", "createLayoutTree", "Lgg/essential/elementa/components/TreeListComponent;", "createLayoutTree$Elementa", "draw", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "fireLinkClickEvent", "event", "fireLinkClickEvent$Elementa", "layout", "onLinkClicked", "block", "reparse", "setMaxHeight", "updateConfig", "Companion", "ConstraintValues", "LinkClickEvent", "Elementa"})
@SourceDebugExtension(value={"SMAP\nMarkdownComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownComponent.kt\ngg/essential/elementa/markdown/MarkdownComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n1849#2,2:286\n798#2,11:288\n1177#2,2:299\n1251#2,4:301\n798#2,11:305\n1849#2,2:317\n1849#2,2:319\n1849#2,2:321\n1#3:316\n*S KotlinDebug\n*F\n+ 1 MarkdownComponent.kt\ngg/essential/elementa/markdown/MarkdownComponent\n*L\n158#1:286,2\n162#1:288,11\n162#1:299,2\n162#1:301,4\n169#1:305,11\n206#1:317,2\n222#1:319,2\n224#1:321,2\n*E\n"})
public final class MarkdownComponent
extends UIComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float codeFontPointSize;
    @NotNull
    private final FontProvider codeFontRenderer;
    private final boolean disableSelection;
    @NotNull
    private final BasicState<MarkdownConfig> configState;
    @NotNull
    private State<String> textState;
    @NotNull
    private Function0<Unit> removeListener;
    @NotNull
    private final DrawableList drawables;
    @NotNull
    private Map<String, Float> sectionOffsets;
    private float baseX;
    private float baseY;
    private ConstraintValues lastValues;
    @NotNull
    private HeightConstraint maxHeight;
    @Nullable
    private Cursor<?> cursor;
    @Nullable
    private Selection selection;
    private boolean canDrag;
    private boolean needsInitialLayout;
    @NotNull
    private final List<Function2<MarkdownComponent, LinkClickEvent, Unit>> linkClickListeners;
    private float maxTextLineWidth;
    public static final boolean DEBUG = false;

    public MarkdownComponent(@NotNull String text, @NotNull MarkdownConfig config, float codeFontPointSize, @NotNull FontProvider codeFontRenderer, boolean disableSelection) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)codeFontRenderer, (String)"codeFontRenderer");
        this.codeFontPointSize = codeFontPointSize;
        this.codeFontRenderer = codeFontRenderer;
        this.disableSelection = disableSelection;
        this.configState = new BasicState<MarkdownConfig>(config);
        this.textState = new BasicState<String>(text);
        this.removeListener = this.textState.onSetValue((Function1<String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ MarkdownComponent this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MarkdownComponent.access$reparse(this.this$0);
                this.this$0.layout();
            }
        }));
        this.drawables = new DrawableList(this, CollectionsKt.emptyList());
        this.sectionOffsets = MapsKt.emptyMap();
        this.baseX = -1.0f;
        this.baseY = -1.0f;
        this.maxHeight = UtilitiesKt.pixels$default(Integer.MAX_VALUE, false, false, 3, null);
        this.needsInitialLayout = true;
        this.linkClickListeners = new ArrayList();
        this.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                float xShift = $this$onMouseClick.getLeft() - baseX;
                float yShift = $this$onMouseClick.getTop() - baseY;
                cursor = this.getDrawables().cursorAt(it.getAbsoluteX() - xShift, it.getAbsoluteY() - yShift, false, it.getMouseButton());
                Selection selection = selection;
                if (selection != null) {
                    selection.remove();
                }
                selection = null;
                $this$onMouseClick.releaseWindowFocus();
            }
        }));
        if (!this.disableSelection) {
            this.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>(){

                public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                    Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    canDrag = true;
                }
            }));
            this.onMouseRelease((Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>(){

                public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                    Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
                    canDrag = false;
                }
            }));
            this.onMouseDrag((Function4<? super UIComponent, ? super Float, ? super Float, ? super Integer, Unit>)((Function4)new Function4<UIComponent, Float, Float, Integer, Unit>(){

                public final void invoke(@NotNull UIComponent $this$onMouseDrag, float mouseX, float mouseY, int mouseButton) {
                    Intrinsics.checkNotNullParameter((Object)$this$onMouseDrag, (String)"$this$onMouseDrag");
                    if (mouseButton != 0 || !canDrag) {
                        return;
                    }
                    float x = baseX + RangesKt.coerceIn((float)mouseX, (float)0.0f, (float)$this$onMouseDrag.getWidth());
                    float y = baseY + RangesKt.coerceIn((float)mouseY, (float)0.0f, (float)$this$onMouseDrag.getHeight());
                    Cursor<?> otherEnd = this.getDrawables().cursorAt(x, y, true, mouseButton);
                    if (Intrinsics.areEqual((Object)cursor, otherEnd)) {
                        return;
                    }
                    Selection selection = selection;
                    if (selection != null) {
                        selection.remove();
                    }
                    Cursor cursor = cursor;
                    Intrinsics.checkNotNull((Object)cursor);
                    selection = Selection.Companion.fromCursors(cursor, otherEnd);
                    $this$onMouseDrag.grabWindowFocus();
                }
            }));
            this.onKeyType((Function3<? super UIComponent, ? super Character, ? super Integer, Unit>)((Function3)new Function3<UIComponent, Character, Integer, Unit>(){

                public final void invoke(@NotNull UIComponent $this$onKeyType, char c, int keyCode) {
                    Intrinsics.checkNotNullParameter((Object)$this$onKeyType, (String)"$this$onKeyType");
                    if (selection != null && keyCode == UKeyboard.KEY_C && UKeyboard.isCtrlKeyDown()) {
                        UDesktop.setClipboardString((String)this.getDrawables().selectedText(UKeyboard.isShiftKeyDown()));
                    }
                }
            }));
        }
        this.configState.onSetValue((Function1<MarkdownConfig, Unit>)((Function1)new Function1<MarkdownConfig, Unit>(){

            public final void invoke(@NotNull MarkdownConfig it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.reparse();
                this.layout();
            }
        }));
    }

    public /* synthetic */ MarkdownComponent(String string, MarkdownConfig markdownConfig, float f, FontProvider fontProvider, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            markdownConfig = new MarkdownConfig(null, null, null, null, null, null, null, null, 255, null);
        }
        if ((n & 4) != 0) {
            f = 10.0f;
        }
        if ((n & 8) != 0) {
            fontProvider = ElementaFonts.getJETBRAINS_MONO();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(string, markdownConfig, f, fontProvider, bl);
    }

    @JvmOverloads
    public MarkdownComponent(@NotNull String text, @NotNull MarkdownConfig config, float codeFontPointSize, @NotNull FontProvider codeFontRenderer) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)codeFontRenderer, (String)"codeFontRenderer");
        this(text, config, codeFontPointSize, codeFontRenderer, false);
    }

    public /* synthetic */ MarkdownComponent(String string, MarkdownConfig markdownConfig, float f, FontProvider fontProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            markdownConfig = new MarkdownConfig(null, null, null, null, null, null, null, null, 255, null);
        }
        if ((n & 4) != 0) {
            f = 10.0f;
        }
        if ((n & 8) != 0) {
            fontProvider = ElementaFonts.getJETBRAINS_MONO();
        }
        this(string, markdownConfig, f, fontProvider);
    }

    @NotNull
    public final MarkdownConfig getConfig() {
        return this.configState.get();
    }

    @NotNull
    public final DrawableList getDrawables() {
        return this.drawables;
    }

    @NotNull
    public final Map<String, Float> getSectionOffsets() {
        return this.sectionOffsets;
    }

    public final float getMaxTextLineWidth() {
        return this.maxTextLineWidth;
    }

    @NotNull
    public final MarkdownComponent bindText(@NotNull State<String> state) {
        MarkdownComponent markdownComponent;
        Intrinsics.checkNotNullParameter(state, (String)"state");
        MarkdownComponent $this$bindText_u24lambda_u240 = markdownComponent = this;
        boolean bl = false;
        $this$bindText_u24lambda_u240.removeListener.invoke();
        $this$bindText_u24lambda_u240.textState = state;
        $this$bindText_u24lambda_u240.reparse();
        $this$bindText_u24lambda_u240.layout();
        $this$bindText_u24lambda_u240.removeListener = $this$bindText_u24lambda_u240.textState.onSetValue((Function1<String, Unit>)((Function1)new Function1<String, Unit>($this$bindText_u24lambda_u240){
            final /* synthetic */ MarkdownComponent $this_apply;
            {
                this.$this_apply = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MarkdownComponent.access$reparse(this.$this_apply);
                this.$this_apply.layout();
            }
        }));
        return markdownComponent;
    }

    @NotNull
    public final MarkdownComponent setMaxHeight(@NotNull HeightConstraint maxHeight) {
        MarkdownComponent markdownComponent;
        Intrinsics.checkNotNullParameter((Object)maxHeight, (String)"maxHeight");
        MarkdownComponent $this$setMaxHeight_u24lambda_u241 = markdownComponent = this;
        boolean bl = false;
        $this$setMaxHeight_u24lambda_u241.maxHeight = maxHeight;
        return markdownComponent;
    }

    private final void reparse() {
        this.drawables.setDrawables(new MarkdownRenderer(this.textState.get(), this, this.getConfig()).render());
    }

    /*
     * WARNING - void declaration
     */
    public final void layout() {
        Float f;
        Object object;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        this.baseX = this.getLeft();
        this.baseY = this.getTop();
        float currY = 0.0f;
        currY = this.baseY;
        float width = this.getWidth();
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            currY += it.layout(this.baseX, currY, width).getHeight();
        }
        $this$forEach$iv = this.drawables;
        MarkdownComponent markdownComponent = this;
        boolean $i$f$filterIsInstance = false;
        Iterator iterator = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof HeaderDrawable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo2 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv2;
            HeaderDrawable it = (HeaderDrawable)element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)it.getId$Elementa(), (Object)Float.valueOf(it.getY()));
            object.put(it.getFirst(), it.getSecond());
        }
        markdownComponent.sectionOffsets = destination$iv$iv2;
        this.setHeight(UtilitiesKt.pixels$default(Float.valueOf(RangesKt.coerceAtMost((float)(currY - this.baseY), (float)this.maxHeight.getHeight(this))), false, false, 3, null));
        Iterable iterable = this.drawables;
        markdownComponent = this;
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            f = null;
        } else {
            Object object2;
            float f2;
            Drawable drawable = (Drawable)iterator2.next();
            boolean bl = false;
            Drawable $i$f$associateTo2 = drawable;
            if ($i$f$associateTo2 instanceof ParagraphDrawable) {
                f2 = ((ParagraphDrawable)drawable).getMaxTextLineWidth();
            } else if ($i$f$associateTo2 instanceof HeaderDrawable) {
                Float f3;
                void $this$filterIsInstanceTo$iv$iv2;
                Iterable $this$filterIsInstance$iv2 = drawable.getChildren();
                boolean $i$f$filterIsInstance22 = false;
                object = $this$filterIsInstance$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv instanceof ParagraphDrawable)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                object2 = (List)destination$iv$iv3;
                Iterator $i$f$filterIsInstance22 = object2.iterator();
                if (!$i$f$filterIsInstance22.hasNext()) {
                    f3 = null;
                } else {
                    ParagraphDrawable it22 = (ParagraphDrawable)$i$f$filterIsInstance22.next();
                    boolean bl2 = false;
                    float it22 = it22.getMaxTextLineWidth();
                    while ($i$f$filterIsInstance22.hasNext()) {
                        ParagraphDrawable it32 = (ParagraphDrawable)$i$f$filterIsInstance22.next();
                        $i$a$-maxOfOrNull-MarkdownComponent$layout$3$1 = false;
                        float it32 = it32.getMaxTextLineWidth();
                        it22 = Math.max(it22, it32);
                    }
                    f3 = Float.valueOf(it22);
                }
                f2 = f3 != null ? f3.floatValue() : 0.0f;
            } else {
                f2 = $i$f$associateTo2 instanceof ListDrawable ? ((ListDrawable)drawable).getMaxTextLineWidth() : ($i$f$associateTo2 instanceof BlockquoteDrawable ? ((BlockquoteDrawable)drawable).getMaxTextLineWidth() : 0.0f);
            }
            float f4 = f2;
            while (iterator2.hasNext()) {
                float f5;
                Drawable drawable2 = (Drawable)iterator2.next();
                $i$a$-maxOfOrNull-MarkdownComponent$layout$3 = false;
                object2 = drawable2;
                if (object2 instanceof ParagraphDrawable) {
                    f5 = ((ParagraphDrawable)drawable2).getMaxTextLineWidth();
                } else if (object2 instanceof HeaderDrawable) {
                    Float f6;
                    void $this$filterIsInstanceTo$iv$iv3;
                    Iterable $this$filterIsInstance$iv3 = drawable2.getChildren();
                    boolean $i$f$filterIsInstance2 = false;
                    Object it32 = $this$filterIsInstance$iv3;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo3 = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                        if (!(element$iv$iv instanceof ParagraphDrawable)) continue;
                        destination$iv$iv4.add(element$iv$iv);
                    }
                    Iterable iterable2 = (List)destination$iv$iv4;
                    Iterator iterator3 = iterable2.iterator();
                    if (!iterator3.hasNext()) {
                        f6 = null;
                    } else {
                        it32 = (ParagraphDrawable)iterator3.next();
                        boolean bl3 = false;
                        float f7 = ((ParagraphDrawable)it32).getMaxTextLineWidth();
                        while (iterator3.hasNext()) {
                            ParagraphDrawable it = (ParagraphDrawable)iterator3.next();
                            $i$a$-maxOfOrNull-MarkdownComponent$layout$3$1 = false;
                            float f8 = it.getMaxTextLineWidth();
                            f7 = Math.max(f7, f8);
                        }
                        f6 = Float.valueOf(f7);
                    }
                    f5 = f6 != null ? f6.floatValue() : 0.0f;
                } else {
                    f5 = object2 instanceof ListDrawable ? ((ListDrawable)drawable2).getMaxTextLineWidth() : (object2 instanceof BlockquoteDrawable ? ((BlockquoteDrawable)drawable2).getMaxTextLineWidth() : 0.0f);
                }
                float f9 = f5;
                f4 = Math.max(f4, f9);
            }
            f = Float.valueOf(f4);
        }
        markdownComponent.maxTextLineWidth = f != null ? f.floatValue() : 0.0f;
    }

    @Override
    public void animationFrame() {
        super.animationFrame();
        if (this.needsInitialLayout) {
            this.needsInitialLayout = false;
            this.reparse();
            this.layout();
            this.lastValues = this.constraintValues();
        }
        ConstraintValues currentValues = this.constraintValues();
        ConstraintValues constraintValues = this.lastValues;
        if (constraintValues == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lastValues");
            constraintValues = null;
        }
        if (!Intrinsics.areEqual((Object)currentValues, (Object)constraintValues)) {
            this.layout();
        }
        this.lastValues = currentValues;
    }

    public final void updateConfig(@NotNull MarkdownConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.configState.set(config);
    }

    @NotNull
    public final TreeListComponent createLayoutTree$Elementa() {
        List nodes = new ArrayList();
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            nodes.add(new MarkdownNode(it));
        }
        return new TreeListComponent(nodes);
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Drawable it;
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        if (this.needsInitialLayout) {
            this.animationFrame();
        }
        this.beforeDraw(matrixStack);
        DrawState drawState = new DrawState(this.getLeft() - this.baseX, this.getTop() - this.baseY);
        Window parentWindow = Window.Companion.of(this);
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Drawable)element$iv;
            boolean bl = false;
            it.beforeDraw(drawState);
        }
        $this$forEach$iv = this.drawables;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Drawable)element$iv;
            boolean bl = false;
            if (!parentWindow.isAreaVisible((double)it.getLayout().getLeft() + (double)drawState.getXShift(), (double)it.getLayout().getTop() + (double)drawState.getYShift(), (double)it.getLayout().getRight() + (double)drawState.getXShift(), (double)it.getLayout().getBottom() + (double)drawState.getYShift())) continue;
            if (OptionsKt.getElementaDebug()) {
                UIComponent.Companion.drawDebugOutline$Elementa(matrixStack, (double)it.getLayout().getLeft() + (double)drawState.getXShift(), (double)it.getLayout().getTop() + (double)drawState.getYShift(), (double)it.getLayout().getRight() + (double)drawState.getXShift(), (double)it.getLayout().getBottom() + (double)drawState.getYShift(), this);
            }
            it.draw(matrixStack, drawState);
        }
        if (!this.disableSelection) {
            Selection selection = this.selection;
            if (selection != null) {
                selection.draw(matrixStack, drawState);
            } else {
                Cursor<?> cursor = this.cursor;
                if (cursor != null) {
                    cursor.draw(matrixStack, drawState);
                }
            }
        }
        super.draw(matrixStack);
    }

    private final ConstraintValues constraintValues() {
        return new ConstraintValues(this.getWidth(), this.getTextScale());
    }

    public final void onLinkClicked(@NotNull Function2<? super MarkdownComponent, ? super LinkClickEvent, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.linkClickListeners.add(block);
    }

    public final boolean fireLinkClickEvent$Elementa(@NotNull LinkClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (Function2<MarkdownComponent, LinkClickEvent, Unit> listener : this.linkClickListeners) {
            listener.invoke((Object)this, (Object)event);
            if (!event.getPropagationStoppedImmediately()) continue;
            return false;
        }
        return !event.getPropagationStopped();
    }

    @JvmOverloads
    public MarkdownComponent(@NotNull String text, @NotNull MarkdownConfig config, float codeFontPointSize) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(text, config, codeFontPointSize, null, 8, null);
    }

    @JvmOverloads
    public MarkdownComponent(@NotNull String text, @NotNull MarkdownConfig config) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(text, config, 0.0f, null, 12, null);
    }

    @JvmOverloads
    public MarkdownComponent(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(text, null, 0.0f, null, 14, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgg/essential/elementa/markdown/MarkdownComponent$Companion;", "", "()V", "DEBUG", "", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lgg/essential/elementa/markdown/MarkdownComponent$ConstraintValues;", "", "width", "", "textScale", "(FF)V", "getTextScale", "()F", "getWidth", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Elementa"})
    public static final class ConstraintValues {
        private final float width;
        private final float textScale;

        public ConstraintValues(float width, float textScale) {
            this.width = width;
            this.textScale = textScale;
        }

        public final float getWidth() {
            return this.width;
        }

        public final float getTextScale() {
            return this.textScale;
        }

        public final float component1() {
            return this.width;
        }

        public final float component2() {
            return this.textScale;
        }

        @NotNull
        public final ConstraintValues copy(float width, float textScale) {
            return new ConstraintValues(width, textScale);
        }

        public static /* synthetic */ ConstraintValues copy$default(ConstraintValues constraintValues, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = constraintValues.width;
            }
            if ((n & 2) != 0) {
                f2 = constraintValues.textScale;
            }
            return constraintValues.copy(f, f2);
        }

        @NotNull
        public String toString() {
            return "ConstraintValues(width=" + this.width + ", textScale=" + this.textScale + ')';
        }

        public int hashCode() {
            int result = Float.hashCode(this.width);
            result = result * 31 + Float.hashCode(this.textScale);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConstraintValues)) {
                return false;
            }
            ConstraintValues constraintValues = (ConstraintValues)other;
            if (Float.compare(this.width, constraintValues.width) != 0) {
                return false;
            }
            return Float.compare(this.textScale, constraintValues.textScale) == 0;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/elementa/markdown/MarkdownComponent$LinkClickEvent;", "Lgg/essential/elementa/events/UIEvent;", "url", "", "(Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "Elementa"})
    public static final class LinkClickEvent
    extends UIEvent {
        @NotNull
        private final String url;

        public LinkClickEvent(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }
    }
}

