/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.markdown.drawables;

import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.markdown.DrawState;
import gg.essential.elementa.markdown.HeaderLevelConfig;
import gg.essential.elementa.markdown.MarkdownComponent;
import gg.essential.elementa.markdown.drawables.Drawable;
import gg.essential.elementa.markdown.drawables.HeaderDrawable;
import gg.essential.elementa.markdown.drawables.ParagraphDrawable;
import gg.essential.elementa.markdown.selection.Cursor;
import gg.essential.universal.UMatrixStack;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J\f\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\f\u0010#\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J \u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u001dH\u0014J\u0010\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u00020 H\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lgg/essential/elementa/markdown/drawables/HeaderDrawable;", "Lgg/essential/elementa/markdown/drawables/Drawable;", "md", "Lgg/essential/elementa/markdown/MarkdownComponent;", "level", "", "paragraph", "Lgg/essential/elementa/markdown/drawables/ParagraphDrawable;", "(Lgg/essential/elementa/markdown/MarkdownComponent;ILgg/essential/elementa/markdown/drawables/ParagraphDrawable;)V", "children", "", "getChildren", "()Ljava/util/List;", "dividerWidth", "", "getDividerWidth", "()Ljava/lang/Double;", "setDividerWidth", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "headerConfig", "Lgg/essential/elementa/markdown/HeaderLevelConfig;", "id", "", "getId$Elementa", "()Ljava/lang/String;", "cursorAt", "Lgg/essential/elementa/markdown/selection/Cursor;", "mouseX", "", "mouseY", "dragged", "", "mouseButton", "cursorAtEnd", "cursorAtStart", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "state", "Lgg/essential/elementa/markdown/DrawState;", "layoutImpl", "Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "x", "y", "width", "selectedText", "asMarkdown", "Elementa"})
public final class HeaderDrawable
extends Drawable {
    private final int level;
    @NotNull
    private final ParagraphDrawable paragraph;
    @NotNull
    private final String id;
    @Nullable
    private Double dividerWidth;
    @NotNull
    private final HeaderLevelConfig headerConfig;

    public HeaderDrawable(@NotNull MarkdownComponent md, int level, @NotNull ParagraphDrawable paragraph) {
        HeaderLevelConfig headerLevelConfig;
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"paragraph");
        super(md);
        this.level = level;
        this.paragraph = paragraph;
        this.id = CollectionsKt.joinToString$default((Iterable)this.paragraph.getTextDrawables(), (CharSequence)" ", null, null, (int)0, null, (Function1)id.1.INSTANCE, (int)30, null);
        this.paragraph.setParent(this);
        switch (this.level) {
            case 1: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel1();
                break;
            }
            case 2: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel2();
                break;
            }
            case 3: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel3();
                break;
            }
            case 4: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel4();
                break;
            }
            case 5: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel5();
                break;
            }
            case 6: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel6();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.headerConfig = headerLevelConfig;
        this.paragraph.setHeaderConfig$Elementa(this.headerConfig);
        Drawable.Companion.trim(this.paragraph);
    }

    @Override
    @NotNull
    public List<Drawable> getChildren() {
        return CollectionsKt.listOf((Object)this.paragraph);
    }

    @NotNull
    public final String getId$Elementa() {
        return this.id;
    }

    @Nullable
    public final Double getDividerWidth() {
        return this.dividerWidth;
    }

    public final void setDividerWidth(@Nullable Double d) {
        this.dividerWidth = d;
    }

    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width) {
        float spaceBefore = this.getInsertSpaceBefore() ? this.headerConfig.getVerticalSpaceBefore() : 0.0f;
        float spaceAfter = this.getInsertSpaceAfter() ? this.headerConfig.getVerticalSpaceAfter() : 0.0f;
        this.paragraph.layout(x, y + spaceBefore, width);
        float height = spaceBefore + this.paragraph.getHeight() + spaceAfter + (this.headerConfig.getHasDivider() ? this.headerConfig.getSpaceBeforeDivider() + this.headerConfig.getDividerWidth() : 0.0f);
        return new Drawable.Layout(x, y, width, height, new Drawable.Margin(0.0f, spaceBefore, 0.0f, spaceAfter));
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.paragraph.drawCompat(matrixStack, state);
        if (this.headerConfig.getHasDivider()) {
            float y = this.getLayout().getBottom() - this.getLayout().getMargin().getBottom() - this.headerConfig.getDividerWidth();
            Double d = this.dividerWidth;
            UIBlock.Companion.drawBlockSized(matrixStack, this.headerConfig.getDividerColor(), this.getX() + state.getXShift(), y + state.getYShift(), d != null ? d : (double)this.getWidth(), this.headerConfig.getDividerWidth());
        }
    }

    @Override
    @NotNull
    public Cursor<?> cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        return this.paragraph.cursorAt(mouseX, mouseY, dragged, mouseButton);
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtStart() {
        return this.paragraph.cursorAtStart();
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtEnd() {
        return this.paragraph.cursorAtEnd();
    }

    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        if (!this.hasSelectedText()) {
            return "";
        }
        String text = this.paragraph.selectedText(asMarkdown);
        return asMarkdown ? StringsKt.repeat((CharSequence)"#", (int)this.level) + ' ' + text : text;
    }
}

